/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.items.relics;

import com.mojang.datafixers.util.Pair;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import it.mralxart.arcaneabilities.items.ArcaneItem;
import it.mralxart.arcaneabilities.utils.ABLootCollections;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;

public class FateBeacon
extends RelicItem
implements ArcaneItem {
    public static final String TAG_POSITION = "pos";
    public static final String TAG_WORLD = "world";
    private static String randomStructureName = "";

    public FateBeacon() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC));
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"compass").maxLevel(0).active(CastData.builder().type(CastType.INSTANTANEOUS).castPredicate("overworld", (player, stack) -> player.m_9236_().m_46472_().equals((Object)Level.f_46428_)).build()).build()).ability(AbilityData.builder((String)"set_beacon").maxLevel(0).active(CastData.builder().type(CastType.INSTANTANEOUS).castPredicate("overworld", (player, stack) -> player.m_9236_().m_46472_().equals((Object)Level.f_46428_)).build()).build()).ability(AbilityData.builder((String)"instant_return").maxLevel(4).active(CastData.builder().type(CastType.INSTANTANEOUS).castPredicate("overworld", (player, stack) -> player.m_9236_().m_46472_().equals((Object)Level.f_46428_)).build()).stat(StatData.builder((String)"delay").initialValue(10.0, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_TOTAL, -0.5).formatValue(value -> (int)MathUtils.round((double)value, (int)2)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).loot(LootData.builder().entry(ABLootCollections.RARE).entry(ABLootCollections.LEGENDARY).entry(LootCollections.END).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(12571107).borderBottom(4614803).build()).build()).build();
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        Level world;
        if (ability.equals("compass")) {
            List<String> structureNames = List.of("shipwreck", "monument", "buried_treasure", "ocean_ruin_cold", "ocean_ruin_warm");
            Random random = new Random();
            randomStructureName = structureNames.get(random.nextInt(structureNames.size()));
            int duration = 200;
            this.spreadExperience((LivingEntity)player, stack, 1);
            this.setAbilityCooldown(stack, "compass", duration * 3);
            NBTUtils.setInt((ItemStack)stack, (String)"compass_tick", (int)duration);
        }
        if (ability.equals("set_beacon")) {
            world = player.m_9236_();
            this.setAbilityCooldown(stack, "set_beacon", 100);
            if (world.m_46472_().equals((Object)Level.f_46428_)) {
                double x = player.m_20185_();
                double y = player.m_20186_();
                double z = player.m_20189_();
                String playerPosString = x + "," + y + "," + z;
                NBTUtils.setString((ItemStack)stack, (String)TAG_POSITION, (String)playerPosString);
                NBTUtils.setString((ItemStack)stack, (String)TAG_WORLD, (String)world.m_46472_().m_135782_().toString());
                world.m_5594_(null, player.m_20183_(), SoundEvents.f_11739_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        if (ability.equals("instant_return")) {
            world = player.m_9236_();
            String worldKey = NBTUtils.getString((ItemStack)stack, (String)TAG_WORLD, (String)"");
            if (world.m_46472_().m_135782_().toString().equals(worldKey)) {
                String playerPosString = NBTUtils.getString((ItemStack)stack, (String)TAG_POSITION, (String)"");
                String[] coordinates = playerPosString.split(",");
                double playerX = Double.parseDouble(coordinates[0]);
                double playerY = Double.parseDouble(coordinates[1]);
                double playerZ = Double.parseDouble(coordinates[2]);
                this.spreadExperience((LivingEntity)player, stack, (int)(1.0 + player.m_20182_().m_82554_(new Vec3(playerX, player.m_20186_(), playerZ)) / 50.0));
                player.m_6021_(playerX + 0.5, playerY + 1.0, playerZ + 0.5);
                world.m_5594_(null, player.m_20183_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 1.0f, 1.0f);
                int duration = (int)Math.round(this.getAbilityValue(stack, "instant_return", "delay") * 60.0 * 20.0);
                this.setAbilityCooldown(stack, "instant_return", duration);
            }
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int tick = NBTUtils.getInt((ItemStack)stack, (String)"compass_tick", (int)0);
            if (tick >= 0) {
                int i;
                NBTUtils.setInt((ItemStack)stack, (String)"compass_tick", (int)(--tick));
                Level world = player.m_9236_();
                if (world.m_5776_() || !world.m_46472_().equals((Object)Level.f_46428_)) {
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)world;
                Optional<HolderSet> optional = serverLevel.m_9598_().m_6632_(Registries.f_256944_).flatMap(reg -> reg.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(randomStructureName)))).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0}));
                if (optional.isEmpty()) {
                    return;
                }
                Pair structure = serverLevel.m_7726_().m_8481_().m_223037_(serverLevel, optional.get(), player.m_20183_(), 100, false);
                if (structure == null) {
                    return;
                }
                BlockPos structurePos = (BlockPos)structure.getFirst();
                player.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 20, 255, false, false));
                Vec3 currentVec = player.m_20182_();
                Vec3 finalVec = currentVec.m_82549_(new Vec3((double)structurePos.m_123341_(), player.m_20186_(), (double)structurePos.m_123343_()).m_82546_(currentVec).m_82541_().m_82490_(2.0));
                int distance = (int)Math.round(currentVec.m_82554_(finalVec)) * 20;
                Color particleColor = switch (randomStructureName) {
                    case "shipwreck" -> new Color(40, 224, 255);
                    case "buried_treasure" -> new Color(227, 164, 56);
                    case "monument" -> new Color(40, 107, 234);
                    default -> new Color(86, 14, 134);
                };
                for (i = 0; i < distance; ++i) {
                    float x = (float)((finalVec.f_82479_ - currentVec.f_82479_) * (double)i / (double)distance + currentVec.f_82479_);
                    float z = (float)((finalVec.f_82481_ - currentVec.f_82481_) * (double)i / (double)distance + currentVec.f_82481_);
                    serverLevel.m_8767_(ParticleUtils.constructSimpleSpark((Color)particleColor, (float)(0.2f - (float)i * 0.00375f), (int)1, (float)0.99f), (double)x, player.m_20186_() + (double)(player.m_20192_() / 1.75f), (double)z, 1, 0.0, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < 2; ++i) {
                    float angle = 0.02f * (float)(player.f_19797_ * 3 + i * 160);
                    double extraX = (double)(0.75f * Mth.m_14089_((float)((float)(Math.PI + (double)angle)))) + player.m_20185_();
                    double extraZ = (double)(0.75f * Mth.m_14031_((float)angle)) + player.m_20189_();
                    serverLevel.m_8767_(ParticleUtils.constructSimpleSpark((Color)particleColor, (float)0.2f, (int)30, (float)0.95f), extraX, player.m_20186_() + (double)(player.m_20192_() / 1.75f), extraZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

