/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.items.relics;

import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicSlotModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.mralxart.arcaneabilities.client.renderer.item.CombinedRelicRenderer;
import it.mralxart.arcaneabilities.data.AbilityRelicsData;
import it.mralxart.arcaneabilities.utils.RelicsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.curios.api.SlotContext;

public class CombinedRelicItem
extends RelicItem
implements IRelicItem {
    @Nonnull
    public RelicData getRelicData() {
        ItemStack stack = RelicsUtils.getCurrentStack();
        if (stack != null && stack.m_41720_() == this && stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            AbilitiesData.AbilitiesDataBuilder abilitiesDataBuilder = AbilitiesData.builder();
            if (tag.m_128425_("CombinedAbilities", 9)) {
                ListTag idList = tag.m_128437_("CombinedAbilities", 8);
                for (Tag idTag : idList) {
                    String abilityId = idTag.m_7916_();
                    AbilityRelicsData.get(abilityId).ifPresent(abilityData -> {
                        AbilityData.AbilityDataBuilder abilityBuilder = AbilityData.builder((String)abilityId).maxLevel(abilityData.getMaxLevel()).icon(abilityData.getIcon()).stats(abilityData.getStats());
                        if (abilityData.getCastData() != null) {
                            CastData.CastDataBuilder castBuilder = CastData.builder().type(abilityData.getCastData().getType());
                            abilityData.getCastData().getVisibilityPredicates().forEach(arg_0 -> ((CastData.CastDataBuilder)castBuilder).visibilityPredicate(arg_0));
                            abilityData.getCastData().getCastPredicates().forEach((predicateId, predicate2) -> {
                                BiFunction<Player, ItemStack, Boolean> predicate = (player, newStack) -> (Boolean)predicate2.apply(player, this.createChildStack((ItemStack)newStack, abilityId));
                                castBuilder.castPredicate(predicateId, predicate);
                            });
                            abilityBuilder.active(castBuilder.build());
                        }
                        abilitiesDataBuilder.ability(abilityBuilder.build());
                    });
                }
            }
            if (tag.m_128425_("Synergies", 9)) {
                ListTag synergyList = tag.m_128437_("Synergies", 10);
                for (Tag synergyTagNBT : synergyList) {
                    CompoundTag synergyTag = (CompoundTag)synergyTagNBT;
                    String synergyId = synergyTag.m_128461_("SynergyID");
                    String parent1Id = synergyTag.m_128461_("parent1");
                    Optional<AbilityData> abilityDataOptional = AbilityRelicsData.get(parent1Id);
                    if (!abilityDataOptional.isPresent()) continue;
                    AbilityData abilityData2 = abilityDataOptional.get();
                    AbilityData.AbilityDataBuilder synergyBuilder = AbilityData.builder((String)synergyId);
                    synergyBuilder.icon(abilityData2.getIcon());
                    ListTag parentIds = synergyTag.m_128437_("ParentAbilities", 8);
                    for (Tag parentIdTag : parentIds) {
                        AbilityRelicsData.get(parentIdTag.m_7916_()).ifPresent(parentTemplate -> parentTemplate.getStats().values().forEach(arg_0 -> ((AbilityData.AbilityDataBuilder)synergyBuilder).stat(arg_0)));
                    }
                    if (abilityData2.getCastData() != null) {
                        CastData.CastDataBuilder castBuilder = CastData.builder().type(abilityData2.getCastData().getType());
                        for (Tag tag1 : parentIds) {
                            String parentId = tag1.m_7916_();
                            AbilityRelicsData.get(parentId).ifPresent(abilityData1 -> abilityData1.getCastData().getCastPredicates().forEach((predicateId, predicate2) -> {
                                BiFunction<Player, ItemStack, Boolean> predicate = (player, originalStack) -> (Boolean)predicate2.apply(player, this.createChildStack((ItemStack)originalStack, parentId));
                                castBuilder.castPredicate(parentId + "_" + predicateId, predicate);
                            }));
                        }
                        synergyBuilder.active(castBuilder.build());
                    }
                    abilitiesDataBuilder.ability(synergyBuilder.build());
                }
            }
            LevelingData levelingData = new LevelingData(100, 20, 200);
            if (tag.m_128425_("CombinedLeveling", 10)) {
                CompoundTag levelingTag = tag.m_128469_("CombinedLeveling");
                levelingData = new LevelingData(levelingTag.m_128451_("cost"), levelingTag.m_128451_("maxLvl"), levelingTag.m_128451_("step"));
            }
            return RelicData.builder().abilities(abilitiesDataBuilder.build()).leveling(levelingData).style(StyleData.builder().build()).loot(LootData.builder().build()).build();
        }
        return this.constructDefaultRelicData();
    }

    public void castActiveAbility(ItemStack stack, Player player, String abilityId, CastType type, CastStage stage) {
        if (abilityId.startsWith("synergy_")) {
            List<String> parentIds = this.getSynergyParents(stack, abilityId);
            if (parentIds != null) {
                for (String parentId : parentIds) {
                    this.castAbility(stack, player, parentId, type, stage);
                }
            }
        } else {
            this.castAbility(stack, player, abilityId, type, stage);
        }
    }

    private void castAbility(ItemStack mainStack, Player player, String abilityId, CastType type, CastStage stage) {
        RelicItem relicItem = this.getOriginRelicItem(mainStack, abilityId);
        if (relicItem == null) {
            return;
        }
        ItemStack childStack = this.createChildStack(mainStack, abilityId);
        relicItem.castActiveAbility(childStack, player, abilityId, type, stage);
        this.saveChildStack(mainStack, abilityId, childStack);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        if (stack.m_41720_() instanceof CombinedRelicItem) {
            RelicsUtils.setCurrentStack(stack);
        }
        CompoundTag mainRelicData = tag.m_128425_("RelicData", 10) ? tag.m_128469_("RelicData") : new CompoundTag();
        ResourceLocation parent1Id = new ResourceLocation(tag.m_128461_("Parent1"));
        ResourceLocation parent2Id = new ResourceLocation(tag.m_128461_("Parent2"));
        HashSet<ResourceLocation> parentRelicIds = new HashSet<ResourceLocation>();
        parentRelicIds.add(parent1Id);
        parentRelicIds.add(parent2Id);
        for (ResourceLocation relicId : parentRelicIds) {
            RelicItem originRelic = AbilityRelicsData.getInstance(relicId);
            if (originRelic == null) continue;
            ItemStack childStack = new ItemStack((ItemLike)originRelic);
            Set<String> abilities = this.getAbilities(stack);
            for (String abilityId : abilities) {
                CompoundTag abilityTag;
                ResourceLocation abilityOrigin = this.getAbilityOrigin(stack, abilityId);
                if (!relicId.equals((Object)abilityOrigin) || (abilityTag = this.getTagAbilityData(stack, abilityId)) == null) continue;
                childStack.m_41784_().m_128469_("abilities");
                CompoundTag abilitiesTag = childStack.m_41784_().m_128469_("abilities");
                abilityTag.m_128469_("abilities").m_128469_(abilityId);
                abilitiesTag.m_128365_(abilityId, (Tag)abilityTag.m_128469_("abilities").m_128469_(abilityId));
            }
            CompoundTag mainTag = stack.m_41783_();
            if (mainTag != null && mainTag.m_128425_("leveling", 10)) {
                childStack.m_41783_().m_128365_("leveling", (Tag)mainTag.m_128469_("leveling").m_6426_());
            }
            childStack.m_41784_().m_128391_(mainRelicData);
            CompoundTag relicDataTag = stack.m_41784_().m_128469_("RelicData");
            for (String key : relicDataTag.m_128431_()) {
                if (key.equals("abilities") || key.equals("leveling") || childStack.m_41783_() == null || relicDataTag.m_128423_(key) == null) continue;
                childStack.m_41783_().m_128365_(key, relicDataTag.m_128423_(key));
            }
            originRelic.curioTick(slotContext, childStack);
            CompoundTag compoundTag = childStack.m_41783_();
            if (compoundTag != null) {
                for (String key : compoundTag.m_128431_()) {
                    if (key.equals("abilities") || key.equals("leveling")) continue;
                    mainRelicData.m_128365_(key, compoundTag.m_128423_(key).m_6426_());
                }
            }
            for (String abilityId : abilities) {
                ResourceLocation origin = this.getAbilityOrigin(stack, abilityId);
                if (!relicId.equals((Object)origin) || childStack.m_41783_() == null || !childStack.m_41782_() || !childStack.m_41783_().m_128441_("abilities")) continue;
                CompoundTag compoundTag1 = new CompoundTag();
                compoundTag1.m_128365_("abilities", (Tag)childStack.m_41783_().m_128469_("abilities"));
                this.setAbilityDataTag(stack, abilityId, compoundTag1);
            }
        }
        stack.m_41784_().m_128365_("RelicData", (Tag)mainRelicData);
    }

    public boolean canPlayerUseActiveAbility(Player player, ItemStack stack, String abilityId) {
        if (abilityId.startsWith("synergy_")) {
            List<String> parentIds = this.getSynergyParents(stack, abilityId);
            if (parentIds == null || parentIds.isEmpty()) {
                return false;
            }
            for (String parentId : parentIds) {
                RelicItem relicItem = this.getOriginRelicItem(stack, parentId);
                if (relicItem == null) {
                    return false;
                }
                ItemStack childStack = this.createChildStack(stack, parentId);
                if (relicItem.canPlayerUseActiveAbility(player, childStack, parentId)) continue;
                return false;
            }
            return true;
        }
        RelicItem relicItem = this.getOriginRelicItem(stack, abilityId);
        if (relicItem == null) {
            return false;
        }
        return relicItem.canPlayerUseActiveAbility(player, this.createChildStack(stack, abilityId), abilityId);
    }

    public boolean canUseAbility(ItemStack stack, String abilityId) {
        if (abilityId.startsWith("synergy_")) {
            List<String> parentIds = this.getSynergyParents(stack, abilityId);
            if (parentIds == null || parentIds.isEmpty()) {
                return false;
            }
            for (String parentId : parentIds) {
                RelicItem relicItem = this.getOriginRelicItem(stack, parentId);
                if (relicItem == null) {
                    return false;
                }
                ItemStack childStack = this.createChildStack(stack, parentId);
                if (relicItem.getLevel(childStack) >= relicItem.getAbilityData(parentId).getRequiredLevel()) continue;
                return false;
            }
            return true;
        }
        RelicItem originRelic = this.getOriginRelicItem(stack, abilityId);
        if (originRelic == null) {
            return false;
        }
        return originRelic.getLevel(this.createChildStack(stack, abilityId)) >= originRelic.getAbilityData(abilityId).getRequiredLevel();
    }

    public ItemStack createChildStack(ItemStack mainStack, String abilityId) {
        ResourceLocation origin = this.getAbilityOrigin(mainStack, abilityId);
        return this.createChildStack(mainStack, origin);
    }

    public ItemStack createChildStack(ItemStack mainStack, ResourceLocation origin) {
        RelicItem relicItem = AbilityRelicsData.getInstance(origin);
        if (relicItem == null) {
            return ItemStack.f_41583_;
        }
        ItemStack childStack = new ItemStack((ItemLike)relicItem);
        CompoundTag childTag = new CompoundTag();
        CompoundTag mainTag = mainStack.m_41783_();
        if (mainTag == null) {
            childStack.m_41751_(childTag);
            return childStack;
        }
        if (mainTag.m_128425_("leveling", 10)) {
            childTag.m_128365_("leveling", (Tag)mainTag.m_128469_("leveling").m_6426_());
        }
        if (mainTag.m_128425_("RelicData", 10)) {
            childTag.m_128391_(mainTag.m_128469_("RelicData").m_6426_());
        }
        CompoundTag abilitiesTag = new CompoundTag();
        Set<String> allAbilities = this.getAbilities(mainStack);
        for (String abilityId : allAbilities) {
            CompoundTag abilities;
            CompoundTag tag;
            if (!origin.equals((Object)this.getAbilityOrigin(mainStack, abilityId)) || (tag = this.getTagAbilityData(mainStack, abilityId)) == null) continue;
            if (tag.m_128425_("abilities", 10) && (abilities = tag.m_128469_("abilities")).m_128441_(abilityId)) {
                abilitiesTag.m_128365_(abilityId, (Tag)abilities.m_128469_(abilityId).m_6426_());
            }
            for (String key : tag.m_128431_()) {
                if (key.equals("abilities")) continue;
                childTag.m_128365_(key, tag.m_128423_(key).m_6426_());
            }
        }
        if (!abilitiesTag.m_128456_()) {
            childTag.m_128365_("abilities", (Tag)abilitiesTag);
        }
        childStack.m_41751_(childTag);
        return childStack;
    }

    public void updateFromChild(ItemStack stack, ItemStack childStack) {
        if (!childStack.m_41782_() || !(childStack.m_41720_() instanceof IRelicItem)) {
            return;
        }
        HashSet<ResourceLocation> ids = new HashSet<ResourceLocation>();
        ids.add(new ResourceLocation(stack.m_41784_().m_128461_("Parent1")));
        ids.add(new ResourceLocation(stack.m_41784_().m_128461_("Parent2")));
        RelicItem childItem = (RelicItem)childStack.m_41720_();
        ResourceLocation childRelicId = ForgeRegistries.ITEMS.getKey((Object)childItem.m_5456_());
        if (ids.contains(childRelicId)) {
            Set<String> allAbilities = this.getAbilities(stack);
            for (String abilityId : allAbilities) {
                if (!childRelicId.equals((Object)this.getAbilityOrigin(stack, abilityId))) continue;
                this.saveChildStack(stack, abilityId, childStack);
            }
        }
    }

    public Set<String> getAbilities(ItemStack stack) {
        HashSet<String> abilities = new HashSet<String>(this.getSingleAbilities(stack));
        List<CompoundTag> synergies = this.getSynergies(stack);
        if (synergies != null) {
            for (CompoundTag synergyTag : synergies) {
                abilities.addAll(this.getSynergyParentsFromTag(synergyTag));
            }
        }
        return abilities;
    }

    public void tickActiveAbilitySelection(ItemStack mainStack, Player player, String abilityId) {
        RelicItem originRelic = this.getOriginRelicItem(mainStack, abilityId);
        if (originRelic == null) {
            return;
        }
        ItemStack childStack = this.createChildStack(mainStack, abilityId);
        originRelic.tickActiveAbilitySelection(childStack, player, abilityId);
        this.saveChildStack(mainStack, abilityId, childStack);
    }

    @Nullable
    private CompoundTag getTagAbilityData(ItemStack mainStack, String abilityId) {
        CompoundTag persistenceTag;
        CompoundTag rootTag = mainStack.m_41783_();
        if (rootTag != null && rootTag.m_128435_("AbilityData") == 10 && (persistenceTag = rootTag.m_128469_("AbilityData")).m_128441_(abilityId)) {
            return persistenceTag.m_128469_(abilityId).m_6426_();
        }
        return null;
    }

    private void setAbilityDataTag(ItemStack mainStack, String abilityId, @Nullable CompoundTag data) {
        CompoundTag persistenceTag;
        CompoundTag rootTag = mainStack.m_41784_();
        if (rootTag.m_128425_("AbilityData", 10)) {
            persistenceTag = rootTag.m_128469_("AbilityData");
        } else {
            persistenceTag = new CompoundTag();
            rootTag.m_128365_("AbilityData", (Tag)persistenceTag);
        }
        if (data != null && !data.m_128456_()) {
            persistenceTag.m_128365_(abilityId, (Tag)data);
        } else {
            persistenceTag.m_128473_(abilityId);
        }
    }

    public AbilityData getAbilityData(String abilityId) {
        AbilityData data;
        RelicData relicData = this.getRelicData();
        if (relicData.getAbilities() != null && relicData.getAbilities().getAbilities() != null && (data = (AbilityData)relicData.getAbilities().getAbilities().get(abilityId)) != null) {
            return data;
        }
        Optional<AbilityData> globalData = AbilityRelicsData.get(abilityId);
        if (globalData.isPresent()) {
            return globalData.get();
        }
        return AbilityData.builder((String)abilityId).build();
    }

    @Nullable
    public RelicItem getOriginRelicItem(ItemStack stack, String abilityId) {
        RelicItem item;
        if (stack.m_41720_() != this) {
            return null;
        }
        ResourceLocation originId = this.getAbilityOrigin(stack, abilityId);
        if (originId != null && (item = AbilityRelicsData.getInstance(originId)) != null) {
            if (item.getAbilityData(abilityId) != null) {
                int maxLevel = item.getAbilityData(abilityId).getMaxLevel();
                if (item.getAbilityData(abilityId).getRequiredLevel() > maxLevel) {
                    item.getAbilityData(abilityId).setRequiredLevel(maxLevel);
                }
            }
            return AbilityRelicsData.getInstance(originId);
        }
        return null;
    }

    @Nonnull
    public List<String> getSingleAbilities(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41720_() == this && stack.m_41782_() && (tag = stack.m_41783_()).m_128425_("CombinedAbilities", 9)) {
            return tag.m_128437_("CombinedAbilities", 8).stream().map(Tag::m_7916_).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Nullable
    public List<CompoundTag> getSynergies(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41720_() == this && stack.m_41782_() && stack.m_41783_().m_128425_("Synergies", 9)) {
            ArrayList<CompoundTag> result = new ArrayList<CompoundTag>();
            ListTag listTag = stack.m_41783_().m_128437_("Synergies", 10);
            for (Tag tag : listTag) {
                result.add((CompoundTag)tag);
            }
            return result;
        }
        return null;
    }

    @Nullable
    public List<String> getSynergyParentsFromTag(CompoundTag synergyTag) {
        if (synergyTag.m_128425_("ParentAbilities", 9)) {
            return synergyTag.m_128437_("ParentAbilities", 8).stream().map(Tag::m_7916_).collect(Collectors.toList());
        }
        return null;
    }

    public int getAbilityCooldown(ItemStack stack, String abilityId) {
        if (abilityId.startsWith("synergy_")) {
            List<String> parentIds = this.getSynergyParents(stack, abilityId);
            if (parentIds == null || parentIds.isEmpty()) {
                return 0;
            }
            int maxCooldown = 0;
            for (String parentId : parentIds) {
                int parentCooldown = this.getAbilityCooldown(stack, parentId);
                if (parentCooldown <= maxCooldown) continue;
                maxCooldown = parentCooldown;
            }
            return maxCooldown;
        }
        RelicItem originRelic = this.getOriginRelicItem(stack, abilityId);
        if (originRelic == null) {
            return 0;
        }
        ItemStack childStack = this.createChildStack(stack, abilityId);
        return originRelic.getAbilityCooldown(childStack, abilityId);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level.m_5776_()) {
            return;
        }
        Set<String> abilities2 = this.getAbilities(stack);
        for (String abilityId : abilities2) {
            RelicItem relicItem = this.getOriginRelicItem(stack, abilityId);
            if (relicItem == null) continue;
            ItemStack childStack = this.createChildStack(stack, abilityId);
            relicItem.m_6883_(childStack, level, entity, slotId, isSelected);
            if (relicItem.isAbilityOnCooldown(childStack, abilityId)) {
                relicItem.addAbilityCooldown(childStack, abilityId, 2);
            }
            this.saveChildStack(stack, abilityId, childStack);
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        if (stack.m_41720_() instanceof CombinedRelicItem) {
            RelicsUtils.setCurrentStack(stack);
        }
        CompoundTag mainRelicData = tag.m_128425_("RelicData", 10) ? tag.m_128469_("RelicData") : new CompoundTag();
        ResourceLocation parent1Id = new ResourceLocation(tag.m_128461_("Parent1"));
        ResourceLocation parent2Id = new ResourceLocation(tag.m_128461_("Parent2"));
        HashSet<ResourceLocation> parentRelicIds = new HashSet<ResourceLocation>();
        parentRelicIds.add(parent1Id);
        parentRelicIds.add(parent2Id);
        for (ResourceLocation relicId : parentRelicIds) {
            RelicItem originRelic = AbilityRelicsData.getInstance(relicId);
            if (originRelic == null) continue;
            ItemStack childStack = new ItemStack((ItemLike)originRelic);
            Set<String> abilities = this.getAbilities(stack);
            for (String abilityId : abilities) {
                CompoundTag abilityTag;
                ResourceLocation abilityOrigin = this.getAbilityOrigin(stack, abilityId);
                if (!relicId.equals((Object)abilityOrigin) || (abilityTag = this.getTagAbilityData(stack, abilityId)) == null) continue;
                childStack.m_41784_().m_128469_("abilities");
                CompoundTag abilitiesTag = childStack.m_41784_().m_128469_("abilities");
                abilityTag.m_128469_("abilities").m_128469_(abilityId);
                abilitiesTag.m_128365_(abilityId, (Tag)abilityTag.m_128469_("abilities").m_128469_(abilityId));
            }
            CompoundTag mainTag = stack.m_41783_();
            if (mainTag != null && mainTag.m_128425_("leveling", 10)) {
                childStack.m_41783_().m_128365_("leveling", (Tag)mainTag.m_128469_("leveling").m_6426_());
            }
            childStack.m_41784_().m_128391_(mainRelicData);
            CompoundTag relicDataTag = stack.m_41784_().m_128469_("RelicData");
            for (String key : relicDataTag.m_128431_()) {
                if (key.equals("abilities") || key.equals("leveling") || childStack.m_41783_() == null || relicDataTag.m_128423_(key) == null) continue;
                childStack.m_41783_().m_128365_(key, relicDataTag.m_128423_(key));
            }
            CompoundTag compoundTag = childStack.m_41783_();
            if (compoundTag != null) {
                for (String key : compoundTag.m_128431_()) {
                    if (key.equals("abilities") || key.equals("leveling")) continue;
                    mainRelicData.m_128365_(key, compoundTag.m_128423_(key).m_6426_());
                }
            }
            for (String abilityId : abilities) {
                ResourceLocation origin = this.getAbilityOrigin(stack, abilityId);
                if (!relicId.equals((Object)origin) || childStack.m_41783_() == null || !childStack.m_41782_() || !childStack.m_41783_().m_128441_("abilities")) continue;
                CompoundTag compoundTag1 = new CompoundTag();
                compoundTag1.m_128365_("abilities", (Tag)childStack.m_41783_().m_128469_("abilities"));
                this.setAbilityDataTag(stack, abilityId, compoundTag1);
            }
        }
        stack.m_41784_().m_128365_("RelicData", (Tag)mainRelicData);
    }

    public void saveChildStack(ItemStack mainStack, String ability, ItemStack childStack) {
        ResourceLocation originRelicId = this.getAbilityOrigin(mainStack, ability);
        this.saveChildStack(mainStack, childStack, originRelicId);
    }

    private void saveChildStack(ItemStack mainStack, ItemStack childStack, ResourceLocation originId) {
        CompoundTag childTag = childStack.m_41783_();
        if (childTag == null) {
            return;
        }
        CompoundTag tag = mainStack.m_41784_();
        CompoundTag relicDataTag = tag.m_128425_("RelicData", 10) ? tag.m_128469_("RelicData") : new CompoundTag();
        for (String key : childTag.m_128431_()) {
            if (key.equals("abilities") || key.equals("leveling")) continue;
            relicDataTag.m_128365_(key, childTag.m_128423_(key).m_6426_());
        }
        tag.m_128365_("RelicData", (Tag)relicDataTag);
        if (childTag.m_128425_("abilities", 10)) {
            CompoundTag abilitiesTag = childTag.m_128469_("abilities");
            for (String abilityId : abilitiesTag.m_128431_()) {
                if (!originId.equals((Object)this.getAbilityOrigin(mainStack, abilityId))) continue;
                CompoundTag compoundTag = this.getTagAbilityData(mainStack, abilityId);
                if (compoundTag == null) {
                    compoundTag = new CompoundTag();
                }
                for (String key : childTag.m_128431_()) {
                    if (key.equals("abilities") || key.equals("leveling")) continue;
                    compoundTag.m_128365_(key, childTag.m_128423_(key).m_6426_());
                }
                CompoundTag var3 = compoundTag.m_128425_("abilities", 10) ? compoundTag.m_128469_("abilities") : new CompoundTag();
                var3.m_128365_(abilityId, (Tag)abilitiesTag.m_128469_(abilityId).m_6426_());
                compoundTag.m_128365_("abilities", (Tag)var3);
                this.setAbilityDataTag(mainStack, abilityId, compoundTag);
            }
        }
    }

    public int getAbilityCooldownCap(ItemStack stack, String abilityId) {
        if (abilityId.startsWith("synergy_")) {
            List<String> parentIds = this.getSynergyParents(stack, abilityId);
            if (parentIds == null || parentIds.isEmpty()) {
                return 0;
            }
            int maxCap = 0;
            for (String parentId : parentIds) {
                int parentCap = this.getAbilityCooldownCap(stack, parentId);
                if (parentCap <= maxCap) continue;
                maxCap = parentCap;
            }
            return maxCap;
        }
        RelicItem originRelic = this.getOriginRelicItem(stack, abilityId);
        if (originRelic == null) {
            return 0;
        }
        ItemStack childStack = this.createChildStack(stack, abilityId);
        return originRelic.getAbilityCooldownCap(childStack, abilityId);
    }

    public boolean isAbilityOnCooldown(ItemStack stack, String abilityId) {
        if (abilityId.startsWith("synergy_")) {
            List<String> parentIds = this.getSynergyParents(stack, abilityId);
            if (parentIds == null || parentIds.isEmpty()) {
                return false;
            }
            return parentIds.stream().anyMatch(parentId -> this.isAbilityOnCooldown(stack, (String)parentId));
        }
        RelicItem originRelic = this.getOriginRelicItem(stack, abilityId);
        if (originRelic == null) {
            return false;
        }
        ItemStack childStack = this.createChildStack(stack, abilityId);
        return originRelic.isAbilityOnCooldown(childStack, abilityId);
    }

    public boolean isAbilityTicking(ItemStack stack, String abilityId) {
        if (abilityId.startsWith("synergy_")) {
            List<String> parentIds = this.getSynergyParents(stack, abilityId);
            if (parentIds == null || parentIds.isEmpty()) {
                return false;
            }
            return parentIds.stream().anyMatch(parentId -> this.isAbilityTicking(stack, (String)parentId));
        }
        RelicItem originRelic = this.getOriginRelicItem(stack, abilityId);
        if (originRelic == null) {
            return false;
        }
        ItemStack childStack = this.createChildStack(stack, abilityId);
        return originRelic.isAbilityTicking(childStack, abilityId);
    }

    @Nullable
    public ResourceLocation getAbilityOrigin(ItemStack stack, String abilityId) {
        CompoundTag origins;
        CompoundTag tag;
        if (stack.m_41720_() == this && stack.m_41782_() && (tag = stack.m_41783_()) != null && tag.m_128425_("AbilityOrigins", 10) && (origins = tag.m_128469_("AbilityOrigins")).m_128441_(abilityId)) {
            return new ResourceLocation(origins.m_128461_(abilityId));
        }
        return null;
    }

    @Nullable
    public List<String> getSynergyParents(ItemStack stack, String synergyId) {
        CompoundTag tag;
        if (!synergyId.startsWith("synergy_")) {
            return null;
        }
        if (stack.m_41720_() == this && stack.m_41782_() && (tag = stack.m_41783_()).m_128425_("Synergies", 9)) {
            ListTag synergyList = tag.m_128437_("Synergies", 10);
            for (Tag synergyTagNBT : synergyList) {
                CompoundTag synergyTag = (CompoundTag)synergyTagNBT;
                if (!synergyTag.m_128461_("SynergyID").equals(synergyId)) continue;
                ListTag parentIds = synergyTag.m_128437_("ParentAbilities", 8);
                return parentIds.stream().map(Tag::m_7916_).collect(Collectors.toList());
            }
        }
        return null;
    }

    @Nullable
    public CompoundTag getSynergyTag(ItemStack stack, String synergyId) {
        CompoundTag tag;
        if (!synergyId.startsWith("synergy_")) {
            return null;
        }
        if (stack.m_41720_() == this && stack.m_41782_() && (tag = stack.m_41783_()).m_128425_("Synergies", 9)) {
            ListTag synergyList = tag.m_128437_("Synergies", 10);
            for (Tag synergyTagNBT : synergyList) {
                CompoundTag synergyTag = (CompoundTag)synergyTagNBT;
                if (!synergyTag.m_128461_("SynergyID").equals(synergyId)) continue;
                return synergyTag;
            }
        }
        return null;
    }

    public void setAbilityTicking(ItemStack stack, String abilityId, boolean ticking) {
        if (abilityId.startsWith("synergy_")) {
            List<String> parentIds = this.getSynergyParents(stack, abilityId);
            if (parentIds != null) {
                for (String parentId : parentIds) {
                    this.setAbilityTicking(stack, parentId, ticking);
                }
            }
        } else {
            RelicItem originRelic = this.getOriginRelicItem(stack, abilityId);
            if (originRelic == null) {
                return;
            }
            ItemStack proxyStack = this.createChildStack(stack, abilityId);
            originRelic.setAbilityTicking(proxyStack, abilityId, ticking);
            this.saveChildStack(stack, abilityId, proxyStack);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        RelicItem originRelic;
        ItemStack mainStack = player.m_21120_(hand);
        if (player.m_6144_() && this.unfuse(level, player, mainStack)) {
            return InteractionResultHolder.m_19090_((Object)ItemStack.f_41583_);
        }
        if (player.m_6117_() && player.m_21211_() == mainStack) {
            return InteractionResultHolder.m_19098_((Object)mainStack);
        }
        if (player.m_6144_()) {
            return super.m_7203_(level, player, hand);
        }
        CompoundTag tag = mainStack.m_41784_();
        HashSet<ResourceLocation> parentRelicIds = new HashSet<ResourceLocation>(Arrays.asList(new ResourceLocation(tag.m_128461_("Parent1")), new ResourceLocation(tag.m_128461_("Parent2"))));
        boolean instantActionPerformed = false;
        ResourceLocation longUseCandidate = null;
        for (ResourceLocation relicId : parentRelicIds) {
            RelicItem originRelic2 = AbilityRelicsData.getInstance(relicId);
            if (originRelic2 == null) continue;
            ItemStack childStack = this.createChildStack(mainStack, relicId);
            if (originRelic2.m_8105_(childStack) > 0) {
                if (longUseCandidate != null) continue;
                longUseCandidate = relicId;
                continue;
            }
            player.m_21008_(hand, childStack);
            InteractionResultHolder result = originRelic2.m_7203_(level, player, hand);
            player.m_21008_(hand, mainStack);
            instantActionPerformed = true;
            this.saveChildStack(mainStack, childStack, relicId);
        }
        if (longUseCandidate != null && (originRelic = AbilityRelicsData.getInstance(longUseCandidate)) != null) {
            ItemStack childStack = this.createChildStack(mainStack, longUseCandidate);
            player.m_21008_(hand, childStack);
            originRelic.m_7203_(level, player, hand);
            boolean didChildStartUsing = player.m_6117_() && player.m_21211_() == childStack;
            this.saveChildStack(mainStack, childStack, longUseCandidate);
            player.m_21008_(hand, mainStack);
            if (didChildStartUsing) {
                player.m_6672_(hand);
                mainStack.m_41784_().m_128359_("active_relic", longUseCandidate.toString());
                return InteractionResultHolder.m_19096_((Object)mainStack);
            }
        }
        if (instantActionPerformed) {
            return InteractionResultHolder.m_19090_((Object)mainStack);
        }
        return InteractionResultHolder.m_19098_((Object)mainStack);
    }

    public boolean unfuse(Level level, Player player, ItemStack combinedStack) {
        if (level.f_46443_) {
            return false;
        }
        CompoundTag tag = combinedStack.m_41783_();
        if (tag == null || !tag.m_128441_("Parent1") || !tag.m_128441_("Parent2")) {
            return false;
        }
        ResourceLocation parent1Id = new ResourceLocation(tag.m_128461_("Parent1"));
        ResourceLocation parent2Id = new ResourceLocation(tag.m_128461_("Parent2"));
        ItemStack stack1 = this.createChildStack(combinedStack, parent1Id);
        ItemStack stack2 = this.createChildStack(combinedStack, parent2Id);
        if (stack1.m_41619_() || stack2.m_41619_()) {
            return false;
        }
        this.sanitizeChildLeveling(stack1, combinedStack);
        this.sanitizeChildLeveling(stack2, combinedStack);
        combinedStack.m_41774_(1);
        if (!player.m_150109_().m_36054_(stack1)) {
            player.m_36176_(stack1, false);
        }
        if (!player.m_150109_().m_36054_(stack2)) {
            player.m_36176_(stack2, false);
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11998_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    private void sanitizeChildLeveling(ItemStack childStack, ItemStack parentStack) {
        CompoundTag childTag = childStack.m_41783_();
        if (childTag == null || !childTag.m_128441_("leveling")) {
            return;
        }
        CompoundTag levelingTag = childTag.m_128469_("leveling");
        levelingTag.m_128473_("cost");
        levelingTag.m_128473_("step");
        levelingTag.m_128473_("maxLvl");
        Item item = childStack.m_41720_();
        if (item instanceof IRelicItem) {
            int maxLevel;
            IRelicItem relicItem = (IRelicItem)item;
            LevelingData defaultLeveling = relicItem.getLevelingData();
            int currentLevel = levelingTag.m_128451_("level");
            if (currentLevel > (maxLevel = defaultLeveling.getMaxLevel())) {
                levelingTag.m_128405_("level", maxLevel);
            }
        }
        childTag.m_128365_("leveling", (Tag)levelingTag);
    }

    public void m_5929_(Level level, LivingEntity player, ItemStack mainStack, int count) {
        CompoundTag tag = mainStack.m_41783_();
        if (tag != null && tag.m_128441_("active_relic")) {
            ResourceLocation relicId = new ResourceLocation(tag.m_128461_("active_relic"));
            RelicItem originRelic = AbilityRelicsData.getInstance(relicId);
            if (originRelic != null) {
                ItemStack childStack = this.createChildStack(mainStack, relicId);
                originRelic.m_5929_(level, player, childStack, count);
                this.saveChildStack(mainStack, childStack, relicId);
            }
        } else {
            super.m_5929_(level, player, mainStack, count);
        }
    }

    public void m_5551_(ItemStack mainStack, Level level, LivingEntity player, int timeLeft) {
        CompoundTag tag = mainStack.m_41783_();
        if (tag != null && tag.m_128441_("active_relic")) {
            ResourceLocation relicId = new ResourceLocation(tag.m_128461_("active_relic"));
            RelicItem originRelic = AbilityRelicsData.getInstance(relicId);
            if (originRelic != null) {
                ItemStack childStack = this.createChildStack(mainStack, relicId);
                originRelic.m_5551_(childStack, level, player, timeLeft);
                this.saveChildStack(mainStack, childStack, relicId);
            }
            tag.m_128473_("active_relic");
        } else {
            super.m_5551_(mainStack, level, player, timeLeft);
        }
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public RelicSlotModifier getSlotModifiers(ItemStack stack) {
        RelicSlotModifier.RelicSlotModifierBuilder finalModifiers = RelicSlotModifier.builder();
        Set<String> abilities = this.getAbilities(stack);
        HashMap<String, Integer> slotCounts = new HashMap<String, Integer>();
        for (String string : abilities) {
            ItemStack proxyStack;
            RelicSlotModifier parentModifiers;
            RelicItem relicItem = this.getOriginRelicItem(stack, string);
            if (relicItem == null || (parentModifiers = relicItem.getSlotModifiers(proxyStack = this.createChildStack(stack, string))) == null) continue;
            List parentEntries = parentModifiers.getModifiers();
            for (Pair entry : parentEntries) {
                String slotId = (String)entry.getKey();
                int size = (Integer)entry.getValue();
                slotCounts.merge(slotId, size, Integer::sum);
            }
        }
        for (Map.Entry entry : slotCounts.entrySet()) {
            finalModifiers.entry(Pair.of((Object)((String)entry.getKey()), (Object)((Integer)entry.getValue())));
        }
        return finalModifiers.build();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private BlockEntityWithoutLevelRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new CombinedRelicRenderer();
                }
                return this.renderer;
            }
        });
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().build();
    }

    public int getAbilityPoints(ItemStack stack, String abilityId) {
        if (abilityId.startsWith("synergy_")) {
            return 0;
        }
        RelicItem originRelic = this.getOriginRelicItem(stack, abilityId);
        if (originRelic == null) {
            return 0;
        }
        ItemStack childStack = this.createChildStack(stack, abilityId);
        return originRelic.getAbilityPoints(childStack, abilityId);
    }

    public void setAbilityPoints(ItemStack stack, String abilityId, int amount) {
        if (abilityId.startsWith("synergy_")) {
            return;
        }
        RelicItem originRelic = this.getOriginRelicItem(stack, abilityId);
        if (originRelic == null) {
            return;
        }
        ItemStack childStack = this.createChildStack(stack, abilityId);
        originRelic.setAbilityPoints(childStack, abilityId, amount);
        this.saveChildStack(stack, abilityId, childStack);
    }

    public void addAbilityPoints(ItemStack stack, String abilityId, int amount) {
        if (abilityId.startsWith("synergy_")) {
            return;
        }
        RelicItem originRelic = this.getOriginRelicItem(stack, abilityId);
        if (originRelic == null) {
            return;
        }
        ItemStack childStack = this.createChildStack(stack, abilityId);
        originRelic.addAbilityPoints(childStack, abilityId, amount);
        this.saveChildStack(stack, abilityId, childStack);
    }

    public double getAbilityValue(ItemStack stack, String abilityId, String stat, int points) {
        if (abilityId.startsWith("synergy_")) {
            return 0.0;
        }
        RelicItem originRelic = this.getOriginRelicItem(stack, abilityId);
        if (originRelic == null) {
            return 0.0;
        }
        ItemStack childStack = this.createChildStack(stack, abilityId);
        return originRelic.getAbilityValue(childStack, abilityId, stat, points);
    }

    public double getAbilityValue(ItemStack stack, String abilityId, String stat) {
        if (abilityId.startsWith("synergy_")) {
            return 0.0;
        }
        RelicItem originRelic = this.getOriginRelicItem(stack, abilityId);
        if (originRelic == null) {
            return 0.0;
        }
        ItemStack childStack = this.createChildStack(stack, abilityId);
        return originRelic.getAbilityValue(childStack, abilityId, stat);
    }

    public void setAbilityValue(ItemStack stack, String abilityId, String stat, double value) {
        if (abilityId.startsWith("synergy_")) {
            return;
        }
        RelicItem originRelic = this.getOriginRelicItem(stack, abilityId);
        if (originRelic == null) {
            return;
        }
        ItemStack childStack = this.createChildStack(stack, abilityId);
        originRelic.setAbilityValue(childStack, abilityId, stat, value);
        this.saveChildStack(stack, abilityId, childStack);
    }

    public double getAbilityInitialValue(ItemStack stack, String abilityId, String stat) {
        if (abilityId.startsWith("synergy_")) {
            return 0.0;
        }
        RelicItem originRelic = this.getOriginRelicItem(stack, abilityId);
        if (originRelic == null) {
            return 0.0;
        }
        ItemStack childStack = this.createChildStack(stack, abilityId);
        return originRelic.getAbilityInitialValue(childStack, abilityId, stat);
    }

    public boolean mayUpgrade(ItemStack stack, String abilityId) {
        if (abilityId.startsWith("synergy_")) {
            return false;
        }
        RelicItem originRelic = this.getOriginRelicItem(stack, abilityId);
        if (originRelic == null) {
            return false;
        }
        ItemStack childStack = this.createChildStack(stack, abilityId);
        return originRelic.mayUpgrade(childStack, abilityId);
    }

    public int getUpgradeRequiredExperience(ItemStack stack, String abilityId) {
        if (abilityId.startsWith("synergy_")) {
            return 0;
        }
        RelicItem originRelic = this.getOriginRelicItem(stack, abilityId);
        if (originRelic == null) {
            return 0;
        }
        ItemStack childStack = this.createChildStack(stack, abilityId);
        return originRelic.getUpgradeRequiredExperience(childStack, abilityId);
    }

    public StatData getStatData(String abilityId, String statId) {
        AbilityData abilityData = this.getAbilityData(abilityId);
        if (abilityData != null && abilityData.getStats() != null) {
            return (StatData)abilityData.getStats().get(statId);
        }
        return null;
    }

    public int getStatQuality(ItemStack stack, String abilityId, String statId) {
        if (abilityId.startsWith("synergy_")) {
            return this.getMaxQuality();
        }
        RelicItem origin = this.getOriginRelicItem(stack, abilityId);
        if (origin == null) {
            return 0;
        }
        ItemStack childStack = this.createChildStack(stack, abilityId);
        return origin.getStatQuality(childStack, abilityId, statId);
    }

    public int getAbilityQuality(ItemStack stack, String abilityId) {
        if (abilityId.startsWith("synergy_")) {
            List<String> parents = this.getSynergyParents(stack, abilityId);
            if (parents != null && parents.size() >= 2) {
                int q1 = this.getAbilityQuality(stack, parents.get(0));
                int q2 = this.getAbilityQuality(stack, parents.get(1));
                return (q1 + q2) / 2;
            }
            return 0;
        }
        RelicItem origin = this.getOriginRelicItem(stack, abilityId);
        if (origin == null) {
            return 0;
        }
        ItemStack childStack = this.createChildStack(stack, abilityId);
        return origin.getAbilityQuality(childStack, abilityId);
    }

    private int getChildRelicQuality(ItemStack mainStack, ResourceLocation relicId) {
        RelicItem item = AbilityRelicsData.getInstance(relicId);
        if (item == null) {
            return 0;
        }
        ItemStack child = this.createChildStack(mainStack, relicId);
        return item.getRelicQuality(child);
    }

    public Map<String, Double> getAbilityInitialValues(ItemStack stack, String abilityId) {
        if (abilityId.startsWith("synergy_")) {
            return Collections.emptyMap();
        }
        RelicItem origin = this.getOriginRelicItem(stack, abilityId);
        if (origin == null) {
            return Collections.emptyMap();
        }
        ItemStack childStack = this.createChildStack(stack, abilityId);
        return origin.getAbilityInitialValues(childStack, abilityId);
    }

    public int getRelicQuality(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("Parent1")) {
            return 0;
        }
        List<String> abilities = this.getSingleAbilities(stack);
        if (abilities.isEmpty()) {
            return 0;
        }
        int sum = 0;
        int count = 0;
        for (String ability : abilities) {
            sum += this.getAbilityQuality(stack, ability);
            ++count;
        }
        if (count == 0) {
            return 0;
        }
        return Math.min(10, sum / count);
    }
}

