/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.init;

import it.mralxart.arcaneabilities.capability.skills.PlayerSkills;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CapabilityRegistry {
    public static final Capability<PlayerSkills> DATA = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerSkills>(){});

    @SubscribeEvent
    public static void onCapabilityRegistry(RegisterCapabilitiesEvent event) {
        event.register(PlayerSkills.PlayerCapability.class);
    }

    @SubscribeEvent
    public static void onCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("arcane_abilities", "data"), (ICapabilityProvider)new PlayerSkills.RelicsCapabilityProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player oldPlayer = event.getOriginal();
        Player newPlayer = event.getEntity();
        oldPlayer.reviveCaps();
        oldPlayer.getCapability(DATA).ifPresent(oldData -> newPlayer.getCapability(DATA).ifPresent(newData -> newData.deserializeNBT((Tag)((CompoundTag)oldData.serializeNBT()))));
        oldPlayer.invalidateCaps();
    }
}

