/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.events.utils;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.server.ServerLifecycleHooks;

public class EventUtils {
    public static final float REGENERATION_CHANCE = 0.02f;
    private static final double ATTRACT_RANGE_SQUARED = 5.0;
    public static final float HASTE_EFFECT_CHANCE = 0.02f;
    public static final float TREASURE_DROP_CHANCE = 0.004f;
    public static final int STUN_DURATION = 20;

    public static void breakBlocksIn3x1(BlockPos pos, ServerLevel world, Player player) {
        for (int yOffset = -1; yOffset <= 1; ++yOffset) {
            BlockPos targetPos = pos.m_7918_(0, yOffset, 0);
            BlockState targetState = world.m_8055_(targetPos);
            if (!EventUtils.isBlockBreakable(targetState.m_60734_(), targetState, player)) continue;
            Block.m_49892_((BlockState)targetState, (LevelAccessor)world, (BlockPos)targetPos, null);
            world.m_46961_(targetPos, false);
        }
    }

    public static ItemStack getRandomTreasureItem(Level level) {
        LootParams.Builder builder;
        LootTable lootTable = ServerLifecycleHooks.getCurrentServer().m_278653_().m_278676_(BuiltInLootTables.f_78692_);
        ObjectArrayList loot = lootTable.m_287195_((builder = new LootParams.Builder((ServerLevel)level)).m_287235_(LootContextParamSets.f_81411_));
        return loot.isEmpty() ? ItemStack.f_41583_ : (ItemStack)loot.get(new Random().nextInt(loot.size()));
    }

    public static void breakBlocksIn3x3(BlockPos pos, ServerLevel world, Player entity) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        Direction facing = entity.m_6350_();
        if (facing == Direction.WEST || facing == Direction.EAST) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    EventUtils.breakBlockIfBreakable(world, entity, x, y + dy, z + dz);
                }
            }
        } else {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dx = -1; dx <= 1; ++dx) {
                    EventUtils.breakBlockIfBreakable(world, entity, x + dx, y + dy, z);
                }
            }
        }
    }

    public static void breakBlockIfBreakable(ServerLevel world, Player entity, int x, int y, int z) {
        BlockPos targetPos = new BlockPos(x, y, z);
        BlockState targetState = world.m_8055_(targetPos);
        if (EventUtils.isBlockBreakable(targetState.m_60734_(), targetState, entity)) {
            Block.m_49892_((BlockState)targetState, (LevelAccessor)world, (BlockPos)targetPos, null);
            world.m_46961_(targetPos, false);
            ItemStack mainHandItem = entity.m_21205_();
            mainHandItem.m_41622_(1, (LivingEntity)entity, e -> {});
        }
    }

    public static boolean isBlockBreakable(Block block, BlockState state, Player player) {
        if (block == Blocks.f_50752_ || block == Blocks.f_50258_) {
            return false;
        }
        return state.m_60800_((BlockGetter)player.m_9236_(), BlockPos.f_121853_) >= 0.0f;
    }

    public static void attractDrops(Player player, Level world, BlockPos pos) {
        List entities = world.m_45933_(null, player.m_20191_().m_82400_(Math.sqrt(5.0)));
        for (Entity entity : entities) {
            ItemEntity itemEntity;
            if (!(entity instanceof ItemEntity) || !((itemEntity = (ItemEntity)entity).m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < 5.0)) continue;
            itemEntity.m_32010_(0);
            itemEntity.m_6123_(player);
        }
    }

    public static void increaseDrop(Player player, ServerLevel level, BlockPos pos, BlockState state) {
        List blockDrops = Block.m_49874_((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)level.m_7702_(pos), (Entity)player, (ItemStack)ItemStack.f_41583_);
        for (ItemStack drop : blockDrops) {
            ItemEntity entityToSpawn = new ItemEntity((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), drop);
            entityToSpawn.m_32060_();
            level.m_7967_((Entity)entityToSpawn);
        }
    }

    public static void increaseGemDrop(ServerLevel world, BlockState state, int x, int y, int z) {
        if (state.m_60713_(Blocks.f_50089_)) {
            EventUtils.dropItem(world, new ItemStack((ItemLike)Items.f_42415_), x, y, z);
        } else if (state.m_60713_(Blocks.f_50264_)) {
            EventUtils.dropItem(world, new ItemStack((ItemLike)Items.f_42616_), x, y, z);
        }
    }

    private static void dropItem(ServerLevel world, ItemStack stack, int x, int y, int z) {
        ItemEntity entityToSpawn = new ItemEntity((Level)world, (double)x, (double)y, (double)z, stack);
        entityToSpawn.m_32060_();
        world.m_7967_((Entity)entityToSpawn);
    }

    public static void dropTreasure(ServerLevel world, int x, int y, int z) {
    }
}

