/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.events;

import it.hurts.sskirillss.relics.api.events.leveling.ExperienceAddEvent;
import it.mralxart.arcaneabilities.capability.PlayerUtils;
import it.mralxart.arcaneabilities.capability.skills.PlayerSkillsUtils;
import it.mralxart.arcaneabilities.init.EffectRegistry;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="arcane_abilities")
public class XpEvents {
    private static int sprintTickCounter = 0;

    @SubscribeEvent
    public void onBreakBlock(@NotNull // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull @NotNull BlockEvent.BreakEvent event) {
        BlockPos pos;
        Player player;
        Level world;
        BlockState state = event.getState();
        if (state.m_60800_((BlockGetter)(world = (player = event.getPlayer()).m_9236_()), pos = event.getPos()) > 0.0f) {
            int xpGain = 1 + 2 * event.getExpToDrop() * XpEvents.getModifier(player);
            PlayerUtils.setSkillValue(player, "skillXp", PlayerUtils.getSkillValue(player, "skillXp") + xpGain);
        }
    }

    @SubscribeEvent
    public static void onExperienceAdd(ExperienceAddEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int xpGain = event.getAmount() / 2;
            PlayerUtils.setSkillValue(player, "skillXp", PlayerUtils.getSkillValue(player, "skillXp") + xpGain);
        }
    }

    @SubscribeEvent
    public static void onMobKill(LivingDeathEvent event) {
        Entity attacker = event.getSource().m_7639_();
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            LivingEntity mob = event.getEntity();
            AttributeInstance maxHealthAttr = mob.m_21051_(Attributes.f_22276_);
            if (maxHealthAttr != null) {
                int initialHealth = (int)maxHealthAttr.m_22135_();
                int experience = (int)((double)initialHealth * 0.1);
                PlayerUtils.setSkillValue(player, "skillXp", PlayerUtils.getSkillValue(player, "skillXp") + experience * XpEvents.getModifier(player));
            }
        }
    }

    private static int getModifier(Player player) {
        Collection activeEffects = player.m_21220_();
        return activeEffects.stream().filter(effect -> effect.m_19544_() == EffectRegistry.XP_BOOST.get()).findFirst().map(MobEffectInstance::m_19564_).map(amplifier -> amplifier + 1).orElse(0);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        sprintTickCounter = player.m_20142_() ? ++sprintTickCounter : 0;
        if (sprintTickCounter >= 300) {
            sprintTickCounter = 0;
            PlayerUtils.setSkillValue(player, "skillXp", PlayerUtils.getSkillValue(player, "skillXp") + 1);
        }
        if (PlayerUtils.getSkillValue(player, "skillXp") >= 250) {
            PlayerUtils.setSkillValue(player, "skillXp", 0);
            PlayerSkillsUtils.setSkillPoints(player, PlayerSkillsUtils.getSkillPoints(player) + 1);
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7r+1 SkillPoint"), true);
        }
    }
}

