/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.events;

import it.hurts.sskirillss.relics.api.events.common.ContainerSlotClickEvent;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.mralxart.arcaneabilities.capability.skills.PlayerSkillsUtils;
import it.mralxart.arcaneabilities.data.AbilityRelicsData;
import it.mralxart.arcaneabilities.data.CombinedRelicManager;
import it.mralxart.arcaneabilities.entities.MagicStoneEntity;
import it.mralxart.arcaneabilities.events.utils.EventUtils;
import it.mralxart.arcaneabilities.items.relics.CombinedRelicItem;
import it.mralxart.arcaneabilities.utils.RelicsUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class Events {
    private static int cooldown = 0;

    public Events() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        CombinedRelicManager.setup(server);
        AbilityRelicsData.buildRegistry();
        System.out.println("CombinedRelicManager initialized for server.");
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!event.getLevel().m_5776_()) {
            BlockPos pos = event.getPos();
            BlockState state = event.getState();
            ServerLevel world = (ServerLevel)event.getLevel();
            Player player = event.getPlayer();
            ItemStack heldItem = player.m_21205_();
            ItemStack leftItem = player.m_21206_();
            if (!player.m_7500_() && EventUtils.isBlockBreakable(world.m_8055_(pos).m_60734_(), world.m_8055_(pos), player) && heldItem.m_41720_() instanceof PickaxeItem) {
                if (PlayerSkillsUtils.isSkillActiveById(player, "m_skill_1") && world.f_46441_.m_188501_() < 0.03f) {
                    ItemEntity entityToSpawn = new ItemEntity((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge:raw_materials"))).getRandomElement(RandomSource.m_216327_()).orElse(Items.f_41852_)));
                    entityToSpawn.m_32010_(10);
                    world.m_7967_((Entity)entityToSpawn);
                }
                if (PlayerSkillsUtils.isSkillActiveById(player, "m_skill_2")) {
                    EventUtils.breakBlocksIn3x1(pos, world, player);
                }
                if (PlayerSkillsUtils.isSkillActiveById(player, "m_skill_3") && world.f_46441_.m_188501_() < 0.02f) {
                    player.m_5634_(2.0f);
                }
                if (PlayerSkillsUtils.isSkillActiveById(player, "m_skill_4")) {
                    EventUtils.attractDrops(player, (Level)world, BlockPos.m_274446_((Position)player.m_20182_()));
                }
                if (PlayerSkillsUtils.isSkillActiveById(player, "m_skill_5") && event.getExpToDrop() > 0) {
                    EventUtils.increaseDrop(player, world, pos, state);
                }
                if (PlayerSkillsUtils.isSkillActiveById(player, "m_skill_6") && world.f_46441_.m_188501_() < 0.02f * (float)PlayerSkillsUtils.getSkillLevelById(player, "m_skill_6")) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 100, 0));
                }
                if (PlayerSkillsUtils.isSkillActiveById(player, "m_skill_7") && world.f_46441_.m_188501_() < 0.05f) {
                    ItemStack treasure = EventUtils.getRandomTreasureItem((Level)world);
                    world.m_7967_((Entity)new ItemEntity((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), treasure));
                }
                if (PlayerSkillsUtils.isSkillActiveById(player, "m_skill_9") && player.m_21206_().m_41720_() instanceof PickaxeItem && player.m_9236_().f_46441_.m_188501_() < 0.15f) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 100, 0));
                }
                if (PlayerSkillsUtils.isSkillActiveById(player, "m_skill_10") && world.f_46441_.m_188501_() < 0.1f) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 40, 1));
                }
                if (PlayerSkillsUtils.isSkillActiveById(player, "m_skill_11")) {
                    EventUtils.breakBlocksIn3x3(pos, world, player);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (event.getAmount() > 0.0f && !event.getEntity().m_21224_()) {
                Level world = player.m_9236_();
                if (PlayerSkillsUtils.isSkillActiveById(player, "f_skill_1") && world.f_46441_.m_188500_() < 0.05) {
                    event.getEntity().m_20254_(5);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            int preciseLevel;
            int energyLevel;
            int lightningLevel;
            int stonesLevel;
            int explosiveLevel;
            Player player = (Player)entity;
            LivingEntity target = event.getEntity();
            Level level = player.m_9236_();
            if (PlayerSkillsUtils.isSkillActiveById(player, "f_skill_3") && player.m_9236_().f_46441_.m_188500_() < 0.5) {
                float originalDamage = event.getAmount();
                float newDamage = originalDamage * 1.1f;
                event.setAmount(newDamage);
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 10, false, false));
                target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60, 1, false, false));
                Level level2 = target.m_9236_();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level2;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123808_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), 15, 0.3, 0.5, 0.3, 0.1);
                }
            }
            if (PlayerSkillsUtils.isSkillActiveById(player, "f_skill_4") && (explosiveLevel = PlayerSkillsUtils.getSkillLevelById(player, "f_skill_4")) > 0 && level.f_46441_.m_188501_() < 0.01f * (float)explosiveLevel) {
                level.m_254849_((Entity)player, target.m_20185_(), target.m_20186_(), target.m_20189_(), 2.0f, Level.ExplosionInteraction.NONE);
            }
            if (PlayerSkillsUtils.isSkillActiveById(player, "f_skill_5") && (stonesLevel = PlayerSkillsUtils.getSkillLevelById(player, "f_skill_5")) > 0 && level.f_46441_.m_188501_() < 0.005f * (float)stonesLevel) {
                level.m_6249_((Entity)player, player.m_20191_().m_82400_(5.0), e -> e instanceof LivingEntity && e != player).forEach(e -> e.m_6469_(player.m_269291_().m_269425_(), 4.0f));
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, player.m_20185_(), player.m_20227_(0.5), player.m_20189_(), 20, 2.5, 1.0, 2.5, 0.1);
                }
            }
            if (PlayerSkillsUtils.isSkillActiveById(player, "f_skill_7") && (lightningLevel = PlayerSkillsUtils.getSkillLevelById(player, "f_skill_7")) > 0 && level.f_46441_.m_188501_() < 0.02f * (float)lightningLevel) {
                level.m_6249_((Entity)player, target.m_20191_().m_82400_(4.0), e -> e instanceof LivingEntity && e != player && e != target).stream().limit(3L).forEach(arg_0 -> ((Player)player).m_5706_(arg_0));
            }
            if (PlayerSkillsUtils.isSkillActiveById(player, "f_skill_8") && (energyLevel = PlayerSkillsUtils.getSkillLevelById(player, "f_skill_8")) > 0 && level.f_46441_.m_188501_() < 0.1f * (float)energyLevel) {
                player.m_5634_(1.0f);
            }
            if (PlayerSkillsUtils.isSkillActiveById(player, "f_skill_9") && (preciseLevel = PlayerSkillsUtils.getSkillLevelById(player, "f_skill_9")) > 0 && level.f_46441_.m_188501_() < 0.05f * (float)preciseLevel) {
                event.setAmount(event.getAmount() * 1.5f);
                if (level instanceof ServerLevel) {
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123797_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), 15, 0.3, 0.5, 0.3, 0.1);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        CombinedRelicItem relicItem;
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item instanceof CombinedRelicItem && (relicItem = (CombinedRelicItem)item).unfuse(event.getLevel(), event.getEntity(), stack)) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            return;
        }
        item = stack.m_41720_();
        if (item instanceof CombinedRelicItem) {
            CombinedRelicItem combinedRelic = (CombinedRelicItem)item;
            if (!player.m_6144_()) {
                combinedRelic.m_7203_(event.getLevel(), player, event.getHand());
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        MobEffectInstance existingEffect;
        Player player = event.player;
        if (event.phase == TickEvent.Phase.START && cooldown > 0) {
            --cooldown;
        }
        RelicsUtils.saveAllChanges();
        if (PlayerSkillsUtils.isSkillActiveById(player, "m_skill_8")) {
            MobEffectInstance nightVisionEffect = new MobEffectInstance(MobEffects.f_19611_, 220, 0, true, false);
            player.m_7292_(nightVisionEffect);
        } else if (player.m_21023_(MobEffects.f_19611_) && (existingEffect = player.m_21124_(MobEffects.f_19611_)) != null && !existingEffect.m_19572_()) {
            player.m_21195_(MobEffects.f_19611_);
        }
        if (PlayerSkillsUtils.isSkillActiveById(player, "f_skill_11")) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 10, 0, true, false));
        } else {
            existingEffect = player.m_21124_(MobEffects.f_19606_);
            if (existingEffect != null && !existingEffect.m_19572_()) {
                player.m_21195_(MobEffects.f_19606_);
            }
        }
    }

    @SubscribeEvent
    public static void onSlotRelic(ContainerSlotClickEvent event) {
        if (event.getSlotStack().m_41720_() instanceof RelicItem && event.getHeldStack().m_41720_() instanceof RelicItem) {
            RelicsUtils.mixRelics(event.getEntity(), event.getSlotStack(), event.getHeldStack());
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (player.m_9236_().m_5776_() || event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        if (PlayerSkillsUtils.isSkillActiveById(player, "f_skill_10")) {
            LivingEntity target;
            Entity entity2;
            AABB searchBox;
            Vec3 lookVector;
            Vec3 endPosition;
            double maxDistance = 8.0;
            Vec3 eyePosition = player.m_146892_();
            EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)player, (Vec3)eyePosition, (Vec3)(endPosition = eyePosition.m_82549_((lookVector = player.m_20154_()).m_82490_(maxDistance))), (AABB)(searchBox = player.m_20191_().m_82369_(lookVector.m_82490_(maxDistance)).m_82377_(1.0, 1.0, 1.0)), entity -> !entity.m_5833_() && entity.m_6087_(), (double)(maxDistance * maxDistance));
            if (entityHitResult != null && (entity2 = entityHitResult.m_82443_()) instanceof LivingEntity && (target = (LivingEntity)entity2).m_6084_()) {
                Vec3 targetPos = target.m_20182_();
                Vec3 playerLook = player.m_20154_().m_82541_();
                Vec3 teleportPos = targetPos.m_82546_(playerLook.m_82490_(1.5));
                player.m_6021_(teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_);
                player.f_19789_ = 0.0f;
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 0.8f, 1.2f);
                Level level = player.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 20, 0.2, 0.2, 0.2, 0.0);
                }
            }
        }
    }

    private static boolean spawnFangs(double x, double y, double z, int lowestYCheck, float yRot, int warmupDelayTicks, Level world, Player player) {
        BlockPos blockpos = new BlockPos((int)x, (int)y, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = world.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)world, blockpos1, Direction.UP)) continue;
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= lowestYCheck);
        if (flag) {
            world.m_7967_((Entity)new MagicStoneEntity(world, x, (double)blockpos.m_123342_() + d0, z, yRot, warmupDelayTicks, (LivingEntity)player));
            return true;
        }
        return false;
    }
}

