/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.entities;

import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.mralxart.arcaneabilities.init.ItemRegistry;
import it.mralxart.arcaneabilities.utils.ParticleUtils;
import java.awt.Color;
import java.util.Iterator;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VortexFallEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Float> RADIUS;
    private static final EntityDataAccessor<Integer> BASE_DAMAGE;
    private Vec3 move;
    private Vec3 prevPos;
    private Color color;
    private ItemStack stack = ItemStack.f_41583_;
    private float heal = 0.0f;
    private float damage = 0.0f;

    public VortexFallEntity(EntityType<? extends VortexFallEntity> entityType, Level level) {
        super(entityType, level);
        this.color = new Color(201, 223, 248);
    }

    public void setRadius(float radius) {
        this.m_20088_().m_135381_(RADIUS, (Object)Float.valueOf(radius));
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(RADIUS)).floatValue();
    }

    public void setBaseDamage(int baseDamage) {
        this.m_20088_().m_135381_(BASE_DAMAGE, (Object)baseDamage);
    }

    public int getBaseDamage() {
        return (Integer)this.m_20088_().m_135370_(BASE_DAMAGE);
    }

    public void m_8119_() {
        this.move = this.m_20184_();
        super.m_8119_();
        this.m_20256_(this.move);
        if (this.m_9236_().f_46443_) {
            double distance = this.m_20182_().m_82554_(this.prevPos == null ? this.m_20182_() : this.prevPos);
            ParticleUtils.spawnCylLine(this.m_9236_(), (ParticleOptions)ParticleTypes.f_123796_, this.prevPos == null ? this.m_20182_() : this.prevPos, this.m_20182_(), (int)Math.round(distance * (double)this.f_19797_ * (double)this.f_19797_ / 156.0 + 2.0), 0.0, 1.0f, 5.0f);
        }
        this.prevPos = this.m_20182_();
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.m_19749_() != null && entity.equals((Object)this.m_19749_())) {
                livingEntity.m_5634_(livingEntity.m_21233_() * this.getHeal());
                ItemStack stack = EntityUtils.findEquippedCurio((Entity)this.m_19749_(), (Item)((Item)ItemRegistry.ICY_CRYSTAL.get()));
                Item item = stack.m_41720_();
                if (!(item instanceof IRelicItem)) {
                    return;
                }
                IRelicItem relic = (IRelicItem)item;
                relic.addExperience(this.getStack(), Math.round(Math.min(livingEntity.m_21233_() * this.getHeal(), livingEntity.m_21233_() - livingEntity.m_21223_())));
            } else {
                entity.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), this.getDamage());
                entity.f_19802_ = 0;
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(this.m_20182_(), this.m_20182_().m_82520_(0.0, -5.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        Vec3 location = result.m_82450_();
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            ParticleUtils.particleAABB(this.m_9236_(), (ParticleOptions)ParticleTypes.f_123796_, new AABB(hitResult.m_82450_().f_82479_, hitResult.m_82450_().f_82480_, hitResult.m_82450_().f_82481_, hitResult.m_82450_().f_82479_ + 3.0, hitResult.m_82450_().f_82480_ + 3.0, hitResult.m_82450_().f_82481_ + 3.0), 300, 0.2);
            it.hurts.sskirillss.relics.utils.ParticleUtils.createBall((ParticleOptions)ParticleTypes.f_123796_, (Vec3)this.m_20182_(), (Level)this.m_9236_(), (int)((int)(1.0f + this.getRadius() / 10.0f)), (float)(0.1f + this.getRadius() * 0.005f));
        }
        this.m_146870_();
    }

    public void onRemovedFromWorld() {
        Entity owner;
        if (!this.m_9236_().f_46443_ && (owner = this.m_19749_()) != null) {
            Iterator iterator = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_((double)this.getRadius())).iterator();
            double knockbackRadiusMultiplier = 2.0;
            double knockbackRadius = (double)this.getRadius() * knockbackRadiusMultiplier;
            while (iterator.hasNext()) {
                double dz;
                double dy;
                double dx;
                double distanceSquared;
                LivingEntity entity = (LivingEntity)iterator.next();
                if (entity == owner || !((distanceSquared = (dx = entity.m_20185_() - this.m_20185_()) * dx + (dy = entity.m_20186_() - this.m_20186_()) * dy + (dz = entity.m_20189_() - this.m_20189_()) * dz) <= knockbackRadius * knockbackRadius)) continue;
                double distance = Math.sqrt(distanceSquared);
                double knockbackStrength = 2.0;
                double upwardMotion = 0.2;
                entity.m_20334_(dx / distance * knockbackStrength, Math.min(0.4, (dy / distance + upwardMotion) * knockbackStrength), dz / distance * knockbackStrength);
            }
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12473_, SoundSource.MASTER, 1.0f, 0.5f);
        }
    }

    public void m_6043_() {
        if (this.f_19797_ > 240) {
            this.m_146870_();
        }
    }

    public boolean m_6087_() {
        return false;
    }

    @SubscribeEvent
    public void onLevelUnload(PlayerEvent.PlayerLoggedOutEvent event) {
        this.m_146870_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BASE_DAMAGE, (Object)2);
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(5.0f));
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("basedmg", this.getBaseDamage());
        compound.m_128350_("radius", this.getRadius());
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBaseDamage(compound.m_128451_("basedmg"));
        this.setRadius(compound.m_128457_("radius"));
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setHeal(float heal) {
        this.heal = heal;
    }

    public float getHeal() {
        return this.heal;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    static {
        BASE_DAMAGE = SynchedEntityData.m_135353_(VortexFallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        RADIUS = SynchedEntityData.m_135353_(VortexFallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    }
}

