/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.entities;

import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import it.mralxart.arcaneabilities.entities.VortexFallEntity;
import it.mralxart.arcaneabilities.init.EntityRegistry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class VortexEntity
extends Projectile {
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.m_135353_(VortexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(VortexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(VortexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> HEAL = SynchedEntityData.m_135353_(VortexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> PERIOD = SynchedEntityData.m_135353_(VortexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Color[] colors = new Color[]{new Color(208, 208, 208), new Color(211, 211, 211), new Color(194, 194, 194), new Color(145, 145, 145)};
    private ItemStack stack;
    private double radiusGrowth;
    private double angleA;
    private double angleB;
    private float currentRadius;
    private LinkedList<DelayedRunnable> taskQueue;

    public VortexEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
        this.setStack(ItemStack.f_41583_);
        this.radiusGrowth = 1.0;
        this.angleA = 30.0;
        this.angleB = 0.0;
        this.taskQueue = new LinkedList();
    }

    public void setLifeTime(int lifeTime) {
        this.m_20088_().m_135381_(LIFETIME, (Object)lifeTime);
    }

    public void setRadius(float radius) {
        this.m_20088_().m_135381_(RADIUS, (Object)Float.valueOf(radius));
    }

    public void setDamage(float damage) {
        this.m_20088_().m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public void setHeal(float heal) {
        this.m_20088_().m_135381_(HEAL, (Object)Float.valueOf(heal));
    }

    public void setFrequency(int frequency) {
        this.m_20088_().m_135381_(PERIOD, (Object)frequency);
    }

    public int getLifeTime() {
        return (Integer)this.m_20088_().m_135370_(LIFETIME);
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(RADIUS)).floatValue();
    }

    public float getDamage() {
        return ((Float)this.m_20088_().m_135370_(DAMAGE)).floatValue();
    }

    public float getHeal() {
        return ((Float)this.m_20088_().m_135370_(HEAL)).floatValue();
    }

    public int getFrequency() {
        return (Integer)this.m_20088_().m_135370_(PERIOD);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && !this.taskQueue.isEmpty() && this.taskQueue.getFirst().startedAt + this.taskQueue.getFirst().delay <= this.f_19797_) {
            this.taskQueue.pop().runnable.run();
        }
        this.currentRadius = this.getRadius();
        int lifeTime = this.getLifeTime();
        int frequency = this.getFrequency();
        int i = 0;
        while ((double)i < this.radiusGrowth) {
            Vec3 direction = new Vec3(1.0, 0.0, 0.0);
            direction = direction.m_82524_((float)Math.toRadians(this.f_19796_.m_188501_() * 360.0f)).m_82496_(MathUtils.randomFloat((RandomSource)this.f_19796_));
            double x = (double)MathUtils.randomFloat((RandomSource)this.f_19796_) * this.radiusGrowth;
            double z = (double)MathUtils.randomFloat((RandomSource)this.f_19796_) * Math.sqrt(this.radiusGrowth * this.radiusGrowth - x * x);
            this.m_9236_().m_6493_(ParticleUtils.constructSimpleSpark((Color)this.colors[this.f_19796_.m_188503_(this.colors.length)], (float)((float)(1.0 + this.radiusGrowth / 2.0)), (int)80, (float)0.96f), true, this.m_20185_() + x, this.m_20186_() + (double)MathUtils.randomFloat((RandomSource)this.f_19796_) * this.radiusGrowth / 10.0, this.m_20189_() + z, direction.f_82479_ * 0.46, direction.f_82480_ * 0.1, direction.f_82481_ * 0.46);
            ++i;
        }
        if (this.radiusGrowth < (double)this.currentRadius * 1.2) {
            this.radiusGrowth += ((double)this.currentRadius * 1.2 - 1.0) / 120.0;
        }
        this.radiusGrowth = 6.0;
        if (this.f_19797_ > 20) {
            AABB box = this.m_20191_().m_82400_((double)this.currentRadius).m_82363_(0.0, 50.0, 0.0).m_82386_(0.0, -50.0, 0.0);
            ArrayList targets = new ArrayList(this.m_9236_().m_6443_(LivingEntity.class, box, entity -> !entity.equals((Object)this.m_19749_())));
            if (frequency != 0 && this.f_19797_ % frequency == 0) {
                VortexFallEntity drop = new VortexFallEntity((EntityType<? extends VortexFallEntity>)((EntityType)EntityRegistry.VORTEX_FALL.get()), this.m_9236_());
                drop.m_20334_(0.0, -3.0, 0.0);
                drop.m_5602_(this.m_19749_());
                drop.setStack(this.getStack());
                drop.setRadius(this.getRadius());
                drop.setHeal(this.getHeal());
                drop.setDamage(this.getDamage());
                drop.m_6034_(this.m_20185_(), this.m_20186_() + (double)0.1f, this.m_20189_());
                this.m_9236_().m_7967_((Entity)drop);
                it.mralxart.arcaneabilities.utils.ParticleUtils.particleEntity(ParticleUtils.constructSimpleSpark((Color)new Color(65, 10, 77), (float)0.2f, (int)15, (float)0.83f), (Entity)drop, 15, 0.1);
                this.m_146870_();
            }
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(5.0f));
        this.f_19804_.m_135372_(PERIOD, (Object)5);
        this.f_19804_.m_135372_(LIFETIME, (Object)100);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(8.0f));
        this.f_19804_.m_135372_(HEAL, (Object)Float.valueOf(1.0f));
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("radius", this.getRadius());
        compound.m_128350_("damage", this.getDamage());
        compound.m_128350_("heal", this.getHeal());
        compound.m_128405_("frequency", this.getFrequency());
        compound.m_128405_("lifetime", this.getLifeTime());
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setRadius(compound.m_128457_("radius"));
        this.setDamage(compound.m_128457_("damage"));
        this.setHeal(compound.m_128457_("heal"));
        this.setFrequency(compound.m_128451_("frequency"));
        this.setLifeTime(compound.m_128451_("lifetime"));
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public Color[] getColors() {
        return this.colors;
    }

    public double getRadiusGrowth() {
        return this.radiusGrowth;
    }

    public double getAngleA() {
        return this.angleA;
    }

    public double getAngleB() {
        return this.angleB;
    }

    public float getCurrentRadius() {
        return this.currentRadius;
    }

    public LinkedList<DelayedRunnable> getTaskQueue() {
        return this.taskQueue;
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
    }

    public void setRadiusGrowth(double radiusGrowth) {
        this.radiusGrowth = radiusGrowth;
    }

    public void setAngleA(double angleA) {
        this.angleA = angleA;
    }

    public void setAngleB(double angleB) {
        this.angleB = angleB;
    }

    public void setCurrentRadius(float currentRadius) {
        this.currentRadius = currentRadius;
    }

    public void setTaskQueue(LinkedList<DelayedRunnable> taskQueue) {
        this.taskQueue = taskQueue;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    private static class DelayedRunnable {
        Runnable runnable;
        int startedAt;
        int delay;

        DelayedRunnable(Runnable runnable, int startedAt, int delay) {
            this.runnable = runnable;
            this.startedAt = startedAt;
            this.delay = delay;
        }
    }
}

