/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.entities;

import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.mralxart.arcaneabilities.init.ItemRegistry;
import it.mralxart.arcaneabilities.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class StellarShowerFallEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Integer> BASE_DAMAGE = SynchedEntityData.m_135353_(StellarShowerFallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Vec3 move;
    private Vec3 prevPos;
    private Color color;
    private ItemStack stack = ItemStack.f_41583_;
    private float heal = 0.0f;
    private float damage = 0.0f;

    public StellarShowerFallEntity(EntityType<? extends StellarShowerFallEntity> entityType, Level level) {
        super(entityType, level);
        this.color = new Color(201, 223, 248);
    }

    public void setBaseDamage(int baseDamage) {
        this.m_20088_().m_135381_(BASE_DAMAGE, (Object)baseDamage);
    }

    public int getBaseDamage() {
        return (Integer)this.m_20088_().m_135370_(BASE_DAMAGE);
    }

    public void m_8119_() {
        this.move = this.m_20184_();
        super.m_8119_();
        this.m_20256_(this.move);
        if (this.m_9236_().f_46443_) {
            double distance = this.m_20182_().m_82554_(this.prevPos == null ? this.m_20182_() : this.prevPos);
            ParticleUtils.spawnParticleLine(this.m_9236_(), it.hurts.sskirillss.relics.utils.ParticleUtils.constructSimpleSpark((Color)this.color, (float)0.2f, (int)20, (float)0.85f), this.prevPos == null ? this.m_20182_() : this.prevPos, this.m_20182_(), (int)Math.round(distance * (double)this.f_19797_ * (double)this.f_19797_ / 156.0 + 2.0), 0.0);
        }
        this.prevPos = this.m_20182_();
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.m_19749_() != null && entity.equals((Object)this.m_19749_())) {
                livingEntity.m_5634_(livingEntity.m_21233_() * this.getHeal());
                ItemStack stack = EntityUtils.findEquippedCurio((Entity)this.m_19749_(), (Item)((Item)ItemRegistry.STELLAR_SPHERE.get()));
                Item item = stack.m_41720_();
                if (!(item instanceof IRelicItem)) {
                    return;
                }
                IRelicItem relic = (IRelicItem)item;
                relic.addExperience(this.getStack(), Math.round(Math.min(livingEntity.m_21233_() * this.getHeal(), livingEntity.m_21233_() - livingEntity.m_21223_())));
            } else {
                entity.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), this.getDamage());
                entity.f_19802_ = 0;
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(this.m_20182_(), this.m_20182_().m_82520_(0.0, -5.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        Vec3 location = result.m_82450_();
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            ParticleUtils.spawnParticleLine(this.m_9236_(), it.hurts.sskirillss.relics.utils.ParticleUtils.constructSimpleSpark((Color)this.color, (float)0.1f, (int)20, (float)0.9f), this.m_20182_(), hitResult.m_82450_(), (int)Math.round(Math.sqrt(this.m_20182_().m_82554_(hitResult.m_82450_())) * (double)this.f_19797_ * (double)this.f_19797_ / 156.0 + 2.0), 0.0);
            ParticleUtils.particleAABB(this.m_9236_(), it.hurts.sskirillss.relics.utils.ParticleUtils.constructSimpleSpark((Color)new Color(198, 225, 255), (float)0.2f, (int)20, (float)0.65f), new AABB(hitResult.m_82450_(), hitResult.m_82450_()), 5, 0.1);
            ParticleUtils.particleAABB(this.m_9236_(), it.hurts.sskirillss.relics.utils.ParticleUtils.constructSimpleSpark((Color)new Color(6, 134, 157), (float)0.2f, (int)20, (float)0.65f), new AABB(hitResult.m_82450_(), hitResult.m_82450_()), 5, 0.1);
        }
        this.m_146870_();
    }

    public void m_6043_() {
        if (this.f_19797_ > 240) {
            this.m_146870_();
        }
    }

    public boolean m_6087_() {
        return false;
    }

    @SubscribeEvent
    public void onLevelUnload(PlayerEvent.PlayerLoggedOutEvent event) {
        this.m_146870_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BASE_DAMAGE, (Object)2);
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("basedmg", this.getBaseDamage());
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBaseDamage(compound.m_128451_("basedmg"));
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setHeal(float heal) {
        this.heal = heal;
    }

    public float getHeal() {
        return this.heal;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }
}

