/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.entities;

import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import it.mralxart.arcaneabilities.init.EntityRegistry;
import it.mralxart.arcaneabilities.init.ItemRegistry;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class SnowballEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.m_135353_(SnowballEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public void setSize(int amount) {
        this.m_20088_().m_135381_(SIZE, (Object)amount);
    }

    public int getSize() {
        return (Integer)this.m_20088_().m_135370_(SIZE);
    }

    public SnowballEntity(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public SnowballEntity(Level level) {
        super((EntityType)EntityRegistry.SOLID_SNOWBALL.get(), level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 300) {
            this.m_146870_();
        }
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            float scale = (float)this.getSize() * 0.0035f;
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_175821_, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), 3, (double)scale, (double)scale, (double)scale, (double)0.025f);
        }
    }

    protected void m_8060_(BlockHitResult result) {
        BlockPos pos = result.m_82425_();
        BlockState state = this.m_9236_().m_8055_(pos);
        if (state.m_280296_()) {
            this.m_146870_();
        }
    }

    protected void m_5790_(@NotNull EntityHitResult result) {
        Entity entity;
        if (!this.m_9236_().f_46443_ && (entity = result.m_82443_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.m_19749_() == null || !livingEntity.m_20148_().equals(this.m_19749_().m_20148_())) {
                ItemStack stack = EntityUtils.findEquippedCurio((Entity)this.m_19749_(), (Item)((Item)ItemRegistry.ICY_CRYSTAL.get()));
                Item item = stack.m_41720_();
                if (!(item instanceof IRelicItem)) {
                    return;
                }
                IRelicItem relic = (IRelicItem)item;
                livingEntity.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), (float)((double)this.getSize() * relic.getAbilityValue(stack, "icy_projectiles", "damage")));
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.STUN.get(), (int)Math.round((double)this.getSize() * relic.getAbilityValue(stack, "icy_projectiles", "stun")) * 20, 0, true, false));
                this.m_146870_();
            }
        }
    }

    public void onRemovedFromWorld() {
        Entity owner;
        ParticleUtils.createBall((ParticleOptions)ParticleTypes.f_175821_, (Vec3)this.m_20182_(), (Level)this.m_9236_(), (int)(1 + this.getSize() / 10), (float)(0.1f + (float)this.getSize() * 0.005f));
        if (!this.m_9236_().f_46443_ && (owner = this.m_19749_()) != null) {
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)owner, (Item)((Item)ItemRegistry.ICY_CRYSTAL.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof IRelicItem)) {
                return;
            }
            IRelicItem relic = (IRelicItem)item;
            for (LivingEntity livingEntity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_((double)((float)this.getSize() / 15.0f)))) {
                if (livingEntity.m_20148_().equals(owner.m_20148_())) continue;
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.STUN.get(), (int)(100L + Math.round((double)this.getSize() * (double)Math.round(relic.getAbilityValue(stack, "icy_projectiles", "stun"))) * 20L), 0, true, false));
            }
            if (!stack.m_41619_()) {
                relic.spreadExperience((LivingEntity)owner, stack, (int)Math.floor((float)this.getSize() / 5.0f));
            }
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12473_, SoundSource.MASTER, 1.0f, 0.5f);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SIZE, (Object)0);
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Size", this.getSize());
    }

    protected void m_7378_(CompoundTag compound) {
        this.setSize(compound.m_128451_("Size"));
    }

    public boolean m_20068_() {
        return false;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

