/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.entities;

import it.mralxart.arcaneabilities.init.EntityRegistry;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class MagicStoneEntity
extends PathfinderMob {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 34;
    private boolean clientSideAttackStarted;
    private LivingEntity caster;
    private UUID casterUuid;
    private static final EntityDataAccessor<Boolean> ACTIVATE = SynchedEntityData.m_135353_(MagicStoneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float activateProgress;
    public float prevActivateProgress;
    public final AnimationState stillAnimationState = new AnimationState();

    public MagicStoneEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.m_20331_(true);
        this.m_21557_(true);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22276_, 0.0);
        builder = builder.m_22268_(Attributes.f_22279_, 200.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22284_, 4.0);
        builder = builder.m_22268_(Attributes.f_22278_, 16.0);
        return builder;
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public MagicStoneEntity(Level worldIn, double x, double y, double z, float yaw, int warmupDelayTicks, LivingEntity casterIn) {
        this((EntityType<? extends PathfinderMob>)((EntityType)EntityRegistry.MAGIC_STONE.get()), worldIn);
        this.warmupDelayTicks = warmupDelayTicks;
        this.setCaster(casterIn);
        this.m_146922_(yaw * 57.295776f);
        this.m_6034_(x, y, z);
        this.m_20331_(true);
        this.m_21557_(true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ACTIVATE, (Object)false);
    }

    public void setCaster(@Nullable LivingEntity caster) {
        this.caster = caster;
        this.casterUuid = caster == null ? null : caster.m_20148_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public void m_7380_(@Nonnull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.casterUuid != null) {
            tag.m_128362_("Owner", this.casterUuid);
        }
    }

    public void m_7378_(@Nonnull CompoundTag tag) {
        super.m_7378_(tag);
        this.warmupDelayTicks = tag.m_128451_("Warmup");
        if (tag.m_128403_("Owner")) {
            this.casterUuid = tag.m_128342_("Owner");
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevActivateProgress = this.activateProgress;
        if (this.isActivated() && this.activateProgress > 0.0f) {
            this.activateProgress -= 1.0f;
        }
        if (this.m_9236_().f_46443_) {
            if (this.clientSideAttackStarted) {
                int i;
                --this.lifeTicks;
                if (!this.isActivated() && this.activateProgress < 10.0f) {
                    this.activateProgress += 1.0f;
                }
                if (this.lifeTicks == 33) {
                    for (i = 0; i < 80; ++i) {
                        BlockState block = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
                        double d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        double d1 = this.m_20186_() + 0.03;
                        double d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        double d3 = this.f_19796_.m_188500_() * 0.07;
                        double d4 = this.f_19796_.m_188500_() * 0.07;
                        double d5 = this.f_19796_.m_188500_() * 0.07;
                        this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), d0, d1, d2, d3, d4, d5);
                    }
                }
                if (this.lifeTicks == 14) {
                    this.setActivated(true);
                    for (i = 0; i < 12; ++i) {
                        double d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        double d1 = this.m_20186_() + 0.05 + this.f_19796_.m_188500_();
                        double d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        double d3 = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3;
                        double d4 = 0.3 + this.f_19796_.m_188500_() * 0.3;
                        double d5 = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3;
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, d0, d1, d2, d3, d4, d5);
                    }
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -10 && this.isActivated()) {
                this.setActivated(false);
            }
            if (this.warmupDelayTicks < -10 && this.warmupDelayTicks > -30) {
                for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 0.0, 0.2))) {
                    this.damage(livingentity);
                }
            }
            if (!this.sentSpikeEvent) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.m_146870_();
            }
        }
    }

    public boolean isActivated() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVATE);
    }

    public void setActivated(boolean activated) {
        this.f_19804_.m_135381_(ACTIVATE, (Object)activated);
    }

    private void damage(LivingEntity hitEntity) {
        LivingEntity caster = this.getCaster();
        if (hitEntity.m_6084_() && !hitEntity.m_20147_() && hitEntity != caster && this.f_19797_ % 5 == 0) {
            if (caster == null) {
                hitEntity.m_6469_(this.m_269291_().m_269425_(), 4.0f);
            } else {
                if (caster.m_7307_((Entity)hitEntity)) {
                    return;
                }
                hitEntity.m_6469_(this.m_269291_().m_269425_(), 4.0f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 4) {
            this.clientSideAttackStarted = true;
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

