/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import it.mralxart.arcaneabilities.skills.Skill;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="arcane_abilities")
public class SkillsReloader
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setPrettyPrinting().create();
    private static final Map<ResourceLocation, Skill> SKILLS = new HashMap<ResourceLocation, Skill>();

    public SkillsReloader() {
        super(GSON, "skills");
    }

    @SubscribeEvent
    public static void reloadSkills(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SkillsReloader());
    }

    public static Map<ResourceLocation, Skill> getSkills() {
        return SKILLS;
    }

    @Nullable
    public static Skill getSkillById(ResourceLocation id) {
        return SKILLS.get(id);
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        SKILLS.clear();
        map.forEach(this::readSkill);
    }

    protected void readSkill(ResourceLocation id, JsonElement json) {
        try {
            Skill skill = (Skill)GSON.fromJson(json, Skill.class);
            SKILLS.put(ResourceLocation.m_135820_((String)skill.getId()), skill);
        }
        catch (Exception var4) {
            Exception exception = var4;
            exception.printStackTrace();
        }
    }
}

