/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.data;

import it.mralxart.arcaneabilities.data.SkillManager;
import it.mralxart.arcaneabilities.skills.Skill;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SkillsBuilder {
    private final String id;
    private final int maxLevel;
    private final int cost;
    private final int upcost;
    private final int reqLvl;
    private final String category;
    private List<String> connections;

    public Skill toSkill() {
        Skill skill = new Skill();
        skill.setId(this.id);
        skill.setLevel(0);
        skill.setPurchased(false);
        skill.setActive(false);
        skill.setCategory(this.category);
        if (this.connections != null) {
            for (String connectedSkillId : this.connections) {
                Optional<SkillsBuilder> var10000 = SkillManager.getSkillById(connectedSkillId);
                Objects.requireNonNull(skill);
                var10000.ifPresent(skill::connect);
            }
        }
        return skill;
    }

    SkillsBuilder(String id, int maxLevel, int cost, int upcost, int reqLvl, String category, List<String> connections) {
        this.id = id;
        this.maxLevel = maxLevel;
        this.cost = cost;
        this.upcost = upcost;
        this.reqLvl = reqLvl;
        this.category = category;
        this.connections = connections;
    }

    public static SkillsBuilderBuilder builder() {
        return new SkillsBuilderBuilder();
    }

    public String getId() {
        return this.id;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getCost() {
        return this.cost;
    }

    public int getUpcost() {
        return this.upcost;
    }

    public int getReqLvl() {
        return this.reqLvl;
    }

    public String getCategory() {
        return this.category;
    }

    public List<String> getConnections() {
        return this.connections;
    }

    public void setConnections(List<String> connections) {
        this.connections = connections;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SkillsBuilder)) {
            return false;
        }
        SkillsBuilder other = (SkillsBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxLevel() != other.getMaxLevel()) {
            return false;
        }
        if (this.getCost() != other.getCost()) {
            return false;
        }
        if (this.getUpcost() != other.getUpcost()) {
            return false;
        }
        if (this.getReqLvl() != other.getReqLvl()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        List<String> this$connections = this.getConnections();
        List<String> other$connections = other.getConnections();
        return !(this$connections == null ? other$connections != null : !((Object)this$connections).equals(other$connections));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SkillsBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxLevel();
        result = result * 59 + this.getCost();
        result = result * 59 + this.getUpcost();
        result = result * 59 + this.getReqLvl();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        List<String> $connections = this.getConnections();
        result = result * 59 + ($connections == null ? 43 : ((Object)$connections).hashCode());
        return result;
    }

    public String toString() {
        return "SkillsBuilder(id=" + this.getId() + ", maxLevel=" + this.getMaxLevel() + ", cost=" + this.getCost() + ", upcost=" + this.getUpcost() + ", reqLvl=" + this.getReqLvl() + ", category=" + this.getCategory() + ", connections=" + String.valueOf(this.getConnections()) + ")";
    }

    public static class SkillsBuilderBuilder {
        private String id;
        private int maxLevel;
        private int cost;
        private int upcost;
        private int reqLvl;
        private String category;
        private List<String> connections;

        SkillsBuilderBuilder() {
        }

        public SkillsBuilderBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SkillsBuilderBuilder maxLevel(int maxLevel) {
            this.maxLevel = maxLevel;
            return this;
        }

        public SkillsBuilderBuilder cost(int cost) {
            this.cost = cost;
            return this;
        }

        public SkillsBuilderBuilder upcost(int upcost) {
            this.upcost = upcost;
            return this;
        }

        public SkillsBuilderBuilder reqLvl(int reqLvl) {
            this.reqLvl = reqLvl;
            return this;
        }

        public SkillsBuilderBuilder category(String category) {
            this.category = category;
            return this;
        }

        public SkillsBuilderBuilder connections(List<String> connections) {
            this.connections = connections;
            return this;
        }

        public SkillsBuilder build() {
            return new SkillsBuilder(this.id, this.maxLevel, this.cost, this.upcost, this.reqLvl, this.category, this.connections);
        }

        public String toString() {
            return "SkillsBuilder.SkillsBuilderBuilder(id=" + this.id + ", maxLevel=" + this.maxLevel + ", cost=" + this.cost + ", upcost=" + this.upcost + ", reqLvl=" + this.reqLvl + ", category=" + this.category + ", connections=" + String.valueOf(this.connections) + ")";
        }
    }
}

