/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.data;

import it.mralxart.arcaneabilities.data.SkillsBuilder;
import it.mralxart.arcaneabilities.skills.Skill;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class SkillManager {
    private String id;
    private int maxLevel;
    private int cost;
    private static final List<SkillsBuilder> defaultSkills = new ArrayList<SkillsBuilder>();

    public static List<SkillsBuilder> getDefaultSkills() {
        return new ArrayList<SkillsBuilder>(defaultSkills);
    }

    public static Optional<SkillsBuilder> getSkillById(String skillId) {
        return defaultSkills.stream().filter(skill -> skill.getId().equals(skillId)).findFirst();
    }

    public static int getMaxLevelById(String skillId) {
        return SkillManager.getSkillById(skillId).map(SkillsBuilder::getMaxLevel).orElse(0);
    }

    public static int getCostById(String skillId) {
        return SkillManager.getSkillById(skillId).map(SkillsBuilder::getCost).orElse(0);
    }

    public static int getUpCostById(String skillId) {
        return SkillManager.getSkillById(skillId).map(SkillsBuilder::getUpcost).orElse(0);
    }

    public static int getRequiredLevelById(String skillId) {
        return SkillManager.getSkillById(skillId).map(SkillsBuilder::getReqLvl).orElse(0);
    }

    public static Optional<List<String>> getConnectionsById(String skillId) {
        return SkillManager.getSkillById(skillId).map(SkillsBuilder::getConnections);
    }

    public static Optional<String> getCategoryById(String skillId) {
        return SkillManager.getSkillById(skillId).map(SkillsBuilder::getCategory);
    }

    public static Optional<Skill> getOldSkillById(String skillId) {
        return defaultSkills.stream().filter(skill -> skill.getId().equals(skillId)).findFirst().map(SkillsBuilder::toSkill);
    }

    static {
        defaultSkills.add(SkillsBuilder.builder().id("m_skill_1").maxLevel(1).cost(1).upcost(0).reqLvl(0).connections(new ArrayList<String>(Arrays.asList("m_skill_2", "m_skill_3", "m_skill_4", "m_skill_5"))).category("mining").build());
        defaultSkills.add(SkillsBuilder.builder().id("m_skill_2").maxLevel(1).cost(3).upcost(0).reqLvl(4).connections(new ArrayList<String>(Arrays.asList("m_skill_6", "m_skill_7"))).category("mining").build());
        defaultSkills.add(SkillsBuilder.builder().id("m_skill_3").maxLevel(1).cost(5).upcost(0).reqLvl(3).connections(new ArrayList<String>(Arrays.asList("m_skill_7", "m_skill_8"))).category("mining").build());
        defaultSkills.add(SkillsBuilder.builder().id("m_skill_4").maxLevel(1).cost(5).upcost(0).reqLvl(7).connections(new ArrayList<String>(Arrays.asList("m_skill_9", "m_skill_10"))).category("mining").build());
        defaultSkills.add(SkillsBuilder.builder().id("m_skill_5").maxLevel(1).cost(3).upcost(0).reqLvl(11).connections(new ArrayList<String>(Arrays.asList("m_skill_10", "m_skill_11"))).category("mining").build());
        defaultSkills.add(SkillsBuilder.builder().id("m_skill_6").maxLevel(4).cost(3).upcost(1).reqLvl(5).category("mining").build());
        defaultSkills.add(SkillsBuilder.builder().id("m_skill_7").maxLevel(1).cost(6).upcost(0).reqLvl(18).category("mining").build());
        defaultSkills.add(SkillsBuilder.builder().id("m_skill_8").maxLevel(2).cost(5).upcost(1).reqLvl(8).category("mining").build());
        defaultSkills.add(SkillsBuilder.builder().id("m_skill_9").maxLevel(1).cost(5).upcost(0).reqLvl(14).category("mining").build());
        defaultSkills.add(SkillsBuilder.builder().id("m_skill_10").maxLevel(1).cost(5).upcost(0).reqLvl(20).category("mining").build());
        defaultSkills.add(SkillsBuilder.builder().id("m_skill_11").maxLevel(1).cost(7).upcost(0).reqLvl(24).category("mining").build());
        defaultSkills.add(SkillsBuilder.builder().id("f_skill_1").maxLevel(1).cost(3).upcost(0).reqLvl(0).connections(new ArrayList<String>(Arrays.asList("f_skill_2", "f_skill_3", "f_skill_4", "f_skill_5"))).category("fight").build());
        defaultSkills.add(SkillsBuilder.builder().id("f_skill_2").maxLevel(1).cost(4).upcost(0).reqLvl(7).connections(new ArrayList<String>(Arrays.asList("f_skill_6", "f_skill_7"))).category("fight").build());
        defaultSkills.add(SkillsBuilder.builder().id("f_skill_3").maxLevel(1).cost(5).upcost(3).reqLvl(5).connections(new ArrayList<String>(Arrays.asList("f_skill_7", "f_skill_8"))).category("fight").build());
        defaultSkills.add(SkillsBuilder.builder().id("f_skill_4").maxLevel(6).cost(5).upcost(3).reqLvl(8).connections(new ArrayList<String>(Arrays.asList("f_skill_9", "f_skill_10"))).category("fight").build());
        defaultSkills.add(SkillsBuilder.builder().id("f_skill_5").maxLevel(4).cost(5).upcost(3).reqLvl(5).connections(new ArrayList<String>(Arrays.asList("f_skill_10", "f_skill_11"))).category("fight").build());
        defaultSkills.add(SkillsBuilder.builder().id("f_skill_6").maxLevel(1).cost(10).upcost(0).reqLvl(15).category("fight").build());
        defaultSkills.add(SkillsBuilder.builder().id("f_skill_7").maxLevel(5).cost(4).upcost(3).reqLvl(12).category("fight").build());
        defaultSkills.add(SkillsBuilder.builder().id("f_skill_8").maxLevel(4).cost(5).upcost(2).reqLvl(8).category("fight").build());
        defaultSkills.add(SkillsBuilder.builder().id("f_skill_9").maxLevel(1).cost(6).upcost(0).reqLvl(6).category("fight").build());
        defaultSkills.add(SkillsBuilder.builder().id("f_skill_10").maxLevel(1).cost(5).upcost(0).reqLvl(17).category("fight").build());
        defaultSkills.add(SkillsBuilder.builder().id("f_skill_11").maxLevel(1).cost(5).upcost(3).reqLvl(0).category("fight").build());
        defaultSkills.add(SkillsBuilder.builder().id("g_skill_1").maxLevel(5).cost(3).upcost(0).reqLvl(0).connections(new ArrayList<String>(Arrays.asList("g_skill_2", "g_skill_3", "g_skill_4", "g_skill_5"))).category("magic").build());
        defaultSkills.add(SkillsBuilder.builder().id("g_skill_2").maxLevel(10).cost(5).upcost(3).reqLvl(0).connections(new ArrayList<String>(Arrays.asList("g_skill_6", "g_skill_7"))).category("magic").build());
        defaultSkills.add(SkillsBuilder.builder().id("g_skill_3").maxLevel(10).cost(5).upcost(3).reqLvl(5).connections(new ArrayList<String>(Arrays.asList("g_skill_7", "g_skill_8"))).category("magic").build());
        defaultSkills.add(SkillsBuilder.builder().id("g_skill_4").maxLevel(10).cost(5).upcost(3).reqLvl(0).connections(new ArrayList<String>(Arrays.asList("g_skill_9", "g_skill_10"))).category("magic").build());
        defaultSkills.add(SkillsBuilder.builder().id("g_skill_5").maxLevel(10).cost(5).upcost(3).reqLvl(0).connections(new ArrayList<String>(Arrays.asList("g_skill_10", "g_skill_11"))).category("magic").build());
        defaultSkills.add(SkillsBuilder.builder().id("g_skill_6").maxLevel(10).cost(5).upcost(3).reqLvl(5).category("magic").build());
        defaultSkills.add(SkillsBuilder.builder().id("g_skill_7").maxLevel(10).cost(5).upcost(3).reqLvl(0).category("magic").build());
        defaultSkills.add(SkillsBuilder.builder().id("g_skill_8").maxLevel(10).cost(5).upcost(3).reqLvl(0).category("magic").build());
        defaultSkills.add(SkillsBuilder.builder().id("g_skill_9").maxLevel(10).cost(5).upcost(3).reqLvl(0).category("magic").build());
        defaultSkills.add(SkillsBuilder.builder().id("g_skill_10").maxLevel(10).cost(5).upcost(3).reqLvl(0).category("magic").build());
        defaultSkills.add(SkillsBuilder.builder().id("g_skill_11").maxLevel(10).cost(5).upcost(3).reqLvl(0).category("magic").build());
        defaultSkills.add(SkillsBuilder.builder().id("p_skill_1").maxLevel(5).cost(3).upcost(0).reqLvl(0).connections(new ArrayList<String>(Arrays.asList("p_skill_2", "p_skill_3", "p_skill_4", "p_skill_5"))).category("player").build());
        defaultSkills.add(SkillsBuilder.builder().id("p_skill_2").maxLevel(10).cost(5).upcost(3).reqLvl(0).connections(new ArrayList<String>(Arrays.asList("p_skill_6", "p_skill_7"))).category("player").build());
        defaultSkills.add(SkillsBuilder.builder().id("p_skill_3").maxLevel(10).cost(5).upcost(3).reqLvl(5).connections(new ArrayList<String>(Arrays.asList("p_skill_7", "p_skill_8"))).category("player").build());
        defaultSkills.add(SkillsBuilder.builder().id("p_skill_4").maxLevel(10).cost(5).upcost(3).reqLvl(0).connections(new ArrayList<String>(Arrays.asList("p_skill_9", "p_skill_10"))).category("player").build());
        defaultSkills.add(SkillsBuilder.builder().id("p_skill_5").maxLevel(10).cost(5).upcost(3).reqLvl(0).connections(new ArrayList<String>(Arrays.asList("p_skill_10", "p_skill_11"))).category("player").build());
        defaultSkills.add(SkillsBuilder.builder().id("p_skill_6").maxLevel(10).cost(5).upcost(3).reqLvl(5).category("player").build());
        defaultSkills.add(SkillsBuilder.builder().id("p_skill_7").maxLevel(10).cost(5).upcost(3).reqLvl(0).category("player").build());
        defaultSkills.add(SkillsBuilder.builder().id("p_skill_8").maxLevel(10).cost(5).upcost(3).reqLvl(0).category("player").build());
        defaultSkills.add(SkillsBuilder.builder().id("p_skill_9").maxLevel(10).cost(5).upcost(3).reqLvl(0).category("player").build());
        defaultSkills.add(SkillsBuilder.builder().id("p_skill_10").maxLevel(10).cost(5).upcost(3).reqLvl(0).category("player").build());
        defaultSkills.add(SkillsBuilder.builder().id("p_skill_11").maxLevel(10).cost(5).upcost(3).reqLvl(0).category("player").build());
    }
}

