/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.data;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.util.Function3;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;

public class RelicDataSerializer {
    private static final ExclusionStrategy STRATEGY = new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes f) {
            Class type = f.getDeclaredClass();
            return type.equals(Function3.class) || type.equals(BiFunction.class) || type.equals(Function.class) || type.equals(Predicate.class) || f.getName().contains("Predicate");
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    };
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().addSerializationExclusionStrategy(STRATEGY).addDeserializationExclusionStrategy(STRATEGY).create();

    public static CompoundTag serialize2(RelicData data) {
        String json = new GsonBuilder().setPrettyPrinting().create().toJson((Object)data);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("relicDataJson", json);
        return nbt;
    }

    public static CompoundTag serialize(RelicData data) {
        String json = GSON.toJson((Object)data);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("relicDataJson", json);
        return nbt;
    }

    public static RelicData deserialize(CompoundTag nbt) {
        if (nbt.m_128441_("relicDataJson")) {
            String json = nbt.m_128461_("relicDataJson");
            return (RelicData)GSON.fromJson(json, RelicData.class);
        }
        return null;
    }
}

