/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.data;

import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.mralxart.arcaneabilities.data.RelicDataSerializer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class CombinedRelicManager
extends SavedData {
    private final Map<UUID, RelicData> relicDataMap = new HashMap<UUID, RelicData>();
    private static final String DATA_NAME = "combined_relics";

    public UUID registerNewRelic(RelicData data) {
        UUID newId = UUID.randomUUID();
        this.relicDataMap.put(newId, data);
        this.m_77762_();
        return newId;
    }

    public RelicData getData(UUID id) {
        return this.relicDataMap.get(id);
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        CompoundTag relicsNbt = new CompoundTag();
        this.relicDataMap.forEach((uuid, relicData) -> {
            String json = RelicDataSerializer.GSON.toJson(relicData);
            relicsNbt.m_128359_(uuid.toString(), json);
        });
        nbt.m_128365_("relics", (Tag)relicsNbt);
        return nbt;
    }

    public static CombinedRelicManager load(CompoundTag nbt) {
        CombinedRelicManager manager = new CombinedRelicManager();
        CompoundTag relicsNbt = nbt.m_128469_("relics");
        for (String key : relicsNbt.m_128431_()) {
            UUID uuid = UUID.fromString(key);
            String json = relicsNbt.m_128461_(key);
            RelicData data = (RelicData)RelicDataSerializer.GSON.fromJson(json, RelicData.class);
            manager.relicDataMap.put(uuid, data);
        }
        return manager;
    }

    public static CombinedRelicManager setup(MinecraftServer server) {
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        DimensionDataStorage storage = overworld.m_8895_();
        return (CombinedRelicManager)storage.m_164861_(CombinedRelicManager::load, CombinedRelicManager::new, DATA_NAME);
    }
}

