/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.data;

import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStorage;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class AbilityRelicsData {
    private static final Map<String, AbilityData> ABILITY_TEMPLATES = new HashMap<String, AbilityData>();
    private static final Map<ResourceLocation, RelicItem> INSTANCE_CACHE = new HashMap<ResourceLocation, RelicItem>();

    public static void buildRegistry() {
        if (INSTANCE_CACHE.isEmpty()) {
            ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof RelicItem).forEach(item -> INSTANCE_CACHE.put(ForgeRegistries.ITEMS.getKey(item), (RelicItem)item));
        }
        if (!ABILITY_TEMPLATES.isEmpty()) {
            return;
        }
        for (Item item2 : ForgeRegistries.ITEMS) {
            IRelicItem relic;
            RelicData templateData;
            if (!(item2 instanceof IRelicItem) || (templateData = (RelicData)RelicStorage.RELICS.get(relic = (IRelicItem)item2)) == null || templateData.getAbilities() == null) continue;
            for (AbilityData abilityTemplate : templateData.getAbilities().getAbilities().values()) {
                ABILITY_TEMPLATES.putIfAbsent(abilityTemplate.getId(), abilityTemplate);
            }
        }
        System.out.println("Relic Template Registry built with " + ABILITY_TEMPLATES.size() + " ability templates.");
    }

    @Nullable
    public static RelicItem getInstance(ResourceLocation item) {
        return INSTANCE_CACHE.get(item);
    }

    public static Optional<AbilityData> get(String id) {
        return Optional.ofNullable(ABILITY_TEMPLATES.get(id));
    }
}

