/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.client.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.screen.description.data.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.description.data.base.ParticleData;
import it.hurts.sskirillss.relics.client.screen.description.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import it.mralxart.arcaneabilities.capability.PlayerUtils;
import it.mralxart.arcaneabilities.capability.skills.PlayerSkillsUtils;
import it.mralxart.arcaneabilities.client.screen.SkillsScreen;
import it.mralxart.arcaneabilities.client.screen.base.ICustomRenderWidget;
import it.mralxart.arcaneabilities.client.screen.base.IHoverableWidget;
import it.mralxart.arcaneabilities.client.screen.base.ITickingWidget;
import it.mralxart.arcaneabilities.data.SkillManager;
import it.mralxart.arcaneabilities.network.Network;
import it.mralxart.arcaneabilities.network.messages.SkillsButtonMessage;
import it.mralxart.arcaneabilities.skills.Skill;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;

public class SkillWidget
extends AbstractDescriptionWidget
implements IHoverableWidget,
ITickingWidget,
ICustomRenderWidget {
    private final SkillsScreen screen;
    private float scale = 1.0f;
    private int iconShakeDelta = 0;
    private final Skill skill;
    public boolean highlighted;
    public boolean animated;

    public SkillWidget(int x, int y, SkillsScreen screen, Skill skill) {
        super(x, y, 22, 22);
        this.screen = screen;
        this.skill = skill;
    }

    public void m_5691_() {
        boolean isPurchased = PlayerSkillsUtils.isSkillPurchasedById(this.screen.player, this.skill.getId());
        boolean isConnectedSkillPurchased = PlayerSkillsUtils.isConnectedSkillUnlocked(this.screen.player, this.skill.getId());
        boolean isEnabled = PlayerSkillsUtils.isSkillActiveById(this.screen.player, this.skill.getId());
        boolean canPurchase = PlayerSkillsUtils.mayPlayerPurchase(this.screen.player, this.skill.getId());
        boolean mayPlayerUpgrade = PlayerSkillsUtils.mayPlayerUpgrade(this.screen.player, this.skill.getId());
        String swipeMode = PlayerSkillsUtils.getSwipe(this.screen.player);
        if ("buy".equals(swipeMode)) {
            if (canPurchase && !isPurchased && isConnectedSkillPurchased && PlayerUtils.getSkillValue(this.screen.player, this.screen.category + "Lvl") >= SkillManager.getRequiredLevelById(this.skill.getId())) {
                Network.PACKET_HANDLER.sendToServer((Object)new SkillsButtonMessage(this.skill.getId()));
                SkillsButtonMessage.handleButtonAction((Player)Minecraft.m_91087_().f_91074_, this.skill.getId());
            } else {
                this.iconShakeDelta = Math.min(15, this.iconShakeDelta + (this.iconShakeDelta > 0 ? 5 : 10));
            }
        } else if ("swipe".equals(swipeMode)) {
            if (isPurchased) {
                Network.PACKET_HANDLER.sendToServer((Object)new SkillsButtonMessage(this.skill.getId()));
                SkillsButtonMessage.handleButtonAction((Player)Minecraft.m_91087_().f_91074_, this.skill.getId());
            } else {
                this.iconShakeDelta = Math.min(15, this.iconShakeDelta + (this.iconShakeDelta > 0 ? 5 : 10));
            }
        } else if ("upgrade".equals(swipeMode)) {
            if (isPurchased && mayPlayerUpgrade && isConnectedSkillPurchased) {
                Network.PACKET_HANDLER.sendToServer((Object)new SkillsButtonMessage(this.skill.getId()));
                SkillsButtonMessage.handleButtonAction((Player)Minecraft.m_91087_().f_91074_, this.skill.getId());
            } else {
                this.iconShakeDelta = Math.min(15, this.iconShakeDelta + (this.iconShakeDelta > 0 ? 5 : 10));
            }
        }
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public void customRenderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean active;
        boolean learned;
        float color1 = 1.0f;
        float color2 = 1.0f;
        if (this.MC.f_91074_ != null) {
            color1 = (float)(0.85 + Math.sin((double)this.MC.f_91074_.f_19797_ * 2.0 * 0.075) * 0.3);
            color2 = (float)(0.85 + Math.sin((double)this.MC.f_91074_.f_19797_ * 2.5 * 0.055) * 0.2);
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        TextureManager manager = this.MC.m_91097_();
        String category = PlayerSkillsUtils.getCategory((Player)this.MC.f_91074_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float[] shaderColor = RenderSystem.getShaderColor();
        ResourceLocation skillIcon = new ResourceLocation("arcane_abilities:textures/skills/icons/" + category + "/" + this.skill.getId() + ".png");
        ResourceLocation skillTemplate = new ResourceLocation("arcane_abilities:textures/gui/widget/new_perk_button.png");
        ResourceLocation skillBackground = new ResourceLocation("arcane_abilities:textures/gui/widget/perk_background.png");
        boolean isConnectedSkillPurchased = PlayerSkillsUtils.isConnectedSkillUnlocked(this.screen.player, this.skill.getId());
        boolean canPurchase = PlayerSkillsUtils.mayPlayerPurchase(this.screen.player, this.skill.getId());
        boolean isPurchased = PlayerSkillsUtils.isSkillPurchasedById(this.screen.player, this.skill.getId());
        boolean mayPlayerUpgrade = PlayerSkillsUtils.mayPlayerUpgrade(this.screen.player, this.skill.getId());
        poseStack.m_85836_();
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / this.scale, ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / this.scale, 0.0f);
        if (this.iconShakeDelta != 0) {
            float color = (float)this.iconShakeDelta * 0.05f;
            RenderSystem.setShaderColor((float)shaderColor[0], (float)(shaderColor[1] - color), (float)(shaderColor[2] - color), (float)shaderColor[3]);
            poseStack.m_252781_(Axis.f_252403_.m_252961_((float)Math.sin(((float)this.MC.f_91074_.f_19797_ + partialTick) * 0.5f) * 0.05f));
            if ((double)this.scale <= 1.1) {
                this.scale += ((float)this.iconShakeDelta - partialTick) * 2.5E-4f;
            }
        }
        guiGraphics.m_280163_(skillTemplate, -11, -11, 0.0f, 0.0f, 22, 22, 22, 22);
        if (isPurchased) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)1);
        }
        if (isPurchased && mayPlayerUpgrade) {
            RenderSystem.setShaderColor((float)color1, (float)color1, (float)color1, (float)1.0f);
        }
        if (canPurchase && !isPurchased && isConnectedSkillPurchased && PlayerUtils.getSkillValue(this.screen.player, this.screen.category + "Lvl") >= SkillManager.getRequiredLevelById(this.skill.getId())) {
            RenderSystem.setShaderColor((float)color2, (float)color2, (float)color2, (float)1.0f);
        }
        guiGraphics.m_280163_(skillBackground, -11, -11, 0.0f, 0.0f, 22, 22, 22, 22);
        guiGraphics.m_280163_(skillIcon, -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        if (this.m_198029_()) {
            guiGraphics.m_280163_(new ResourceLocation("arcane_abilities:textures/gui/widget/perk_selected.png"), -12, -12, 0.0f, 0.0f, 24, 24, 24, 24);
        }
        if (!(learned = PlayerSkillsUtils.isSkillPurchasedById((Player)this.MC.f_91074_, this.skill.getId()))) {
            guiGraphics.m_280163_(new ResourceLocation("arcane_abilities:textures/gui/widget/perk_locked.png"), 4, 4, 0.0f, 0.0f, 6, 8, 6, 8);
        }
        if (active = PlayerSkillsUtils.isSkillActiveById((Player)this.MC.f_91074_, this.skill.getId())) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("arcane_abilities:textures/gui/widget/new_perk_button_enabled.png"));
            RenderSystem.enableBlend();
            RenderUtils.renderAnimatedTextureFromCenter((PoseStack)guiGraphics.m_280168_(), (float)0.0f, (float)0.0f, (float)22.0f, (float)176.0f, (float)22.0f, (float)22.0f, (float)1.0f, (AnimationData)AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2));
            RenderSystem.disableBlend();
        }
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    @Override
    public void onTick() {
        float maxScale = 1.1f;
        float minScale = 1.0f;
        RandomSource random = this.MC.f_91074_.m_217043_();
        if (this.m_274382_()) {
            if (this.screen.ticksExisted % 3 == 0) {
                ParticleStorage.addParticle((Screen)this.screen, (ParticleData[])new ParticleData[]{new ExperienceParticleData(PlayerSkillsUtils.isSkillPurchasedById((Player)this.MC.f_91074_, this.skill.getId()) ? new Color(150 + random.m_188503_(50), 50 + random.m_188503_(150), 200 + random.m_188503_(50)) : new Color(100 + random.m_188503_(100), 100 + random.m_188503_(100), 100 + random.m_188503_(100)), (float)(this.m_252754_() + random.m_188503_(this.f_93618_)), (float)(this.m_252907_() - 1), 0.15f + random.m_188501_() * 0.25f, 100 + random.m_188503_(50))});
            }
            if (this.scale < maxScale) {
                this.scale = Math.min(maxScale, this.scale + (maxScale - this.scale) * 0.25f);
            }
        } else if (this.scale != minScale) {
            this.scale = Math.max(minScale, this.scale - 0.025f);
        }
        if (this.iconShakeDelta > 0) {
            --this.iconShakeDelta;
        }
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<MutableComponent> description = new ArrayList<MutableComponent>(List.of(Component.m_237115_((String)("tooltip.arcane_abilities.skill." + this.skill.getId())).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.UNDERLINE)));
        Style style = Style.f_131099_.m_178520_(14928378);
        String id = this.skill.getId();
        String cost = String.valueOf(SkillManager.getCostById(id));
        String upCost = String.valueOf(SkillManager.getUpCostById(id));
        int branchLevel = PlayerUtils.getSkillValue((Player)this.MC.f_91074_, PlayerSkillsUtils.getCategory((Player)this.MC.f_91074_) + "Lvl");
        int skillLevel = PlayerSkillsUtils.getSkillLevelById((Player)this.MC.f_91074_, this.skill.getId());
        int requiredLevel = SkillManager.getRequiredLevelById(id);
        int maxLevel = SkillManager.getMaxLevelById(id);
        boolean isPurchased = PlayerSkillsUtils.isSkillPurchasedById((Player)this.MC.f_91074_, id);
        String currencySymbol = "SkillsPoint";
        MutableComponent costComponent = Component.m_237110_((String)"tooltip.arcane_abilities.skills.tooltip.cost", (Object[])new Object[]{currencySymbol, cost});
        MutableComponent upCostComponent = Component.m_237110_((String)"tooltip.arcane_abilities.skills.tooltip.upcost", (Object[])new Object[]{currencySymbol, upCost});
        MutableComponent air = Component.m_237113_((String)" ");
        String tooltipKey = "tooltip.arcane_abilities.skill." + this.skill.getId() + ".tooltip";
        MutableComponent coloredLine = Component.m_237115_((String)tooltipKey);
        String separator = "\u300b-\u2505-< \u272f\u25e6\u272f >-\u2505-\u300a";
        description.add(Component.m_237113_((String)separator));
        description.add(Component.m_237113_((String)" "));
        description.add(coloredLine);
        description.add(Component.m_237113_((String)" "));
        description.add(Component.m_237113_((String)separator));
        description.add(Component.m_237113_((String)" "));
        if (skillLevel >= maxLevel) {
            description.add(Component.m_237113_((String)"\u272f ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237110_((String)"tooltip.arcane_abilities.skills.ability.tooltip.level", (Object[])new Object[]{skillLevel, maxLevel == -1 ? "\u221e" : Integer.valueOf(maxLevel)}).m_130948_(style)).m_7220_((Component)Component.m_237113_((String)" \u272f").m_130940_(ChatFormatting.GOLD)));
        } else {
            description.add(Component.m_237113_((String)"").m_7220_((Component)Component.m_237110_((String)"tooltip.arcane_abilities.skills.ability.tooltip.level", (Object[])new Object[]{skillLevel, maxLevel == -1 ? "\u221e" : Integer.valueOf(maxLevel)})));
        }
        description.add(air);
        if (!isPurchased) {
            description.add(Component.m_237113_((String)"  \u272f ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237115_((String)"tooltip.arcane_abilities.skills.tooltip.buy").m_130948_(style)));
            description.add(Component.m_237113_((String)"  \u272f ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)costComponent.m_130948_(style)));
        } else if (SkillManager.getUpCostById(this.skill.getId()) > 0 && skillLevel < maxLevel) {
            description.add(Component.m_237113_((String)"  \u272f ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237115_((String)"tooltip.arcane_abilities.skills.tooltip.upgrade").m_130948_(style)));
            description.add(Component.m_237113_((String)"  \u272f ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)upCostComponent.m_130948_(style)));
        }
        if (branchLevel < requiredLevel) {
            description.add(Component.m_237113_((String)"  \u272f ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237110_((String)"tooltip.arcane_abilities.skills.tooltip.low_level", (Object[])new Object[]{requiredLevel, Component.m_237115_((String)"tooltip.arcane_abilities.skills.status.negative").m_130940_(ChatFormatting.DARK_PURPLE)}).m_130948_(style)));
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        int maxWidthInPixels = 400;
        int renderWidth = 0;
        ArrayList tooltipLines = new ArrayList();
        for (MutableComponent entry : description) {
            tooltipLines.addAll(this.MC.f_91062_.m_92923_((FormattedText)entry, maxWidthInPixels));
        }
        for (FormattedCharSequence line : tooltipLines) {
            renderWidth = Math.max(renderWidth, this.MC.f_91062_.m_92724_(line));
        }
        Objects.requireNonNull(this.MC.f_91062_);
        int fontLineHeight = 9 + 1;
        int totalTextHeight = tooltipLines.size() * fontLineHeight;
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.m_5711_() / 2.0f) / this.scale, ((float)this.m_252907_() + (float)this.m_93694_() / 2.0f) / this.scale, 0.0f);
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        int paddingX = 10;
        int paddingY = 8;
        int bgWidth = renderWidth + paddingX;
        int bgHeight = totalTextHeight + paddingY;
        int bgX = -bgWidth / 2;
        int bgY = this.f_93619_ + 3;
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)bgX, (int)bgY, (int)bgWidth, (int)bgHeight, (int)1300, (int)-267386864, (int)-267386864, (int)-395521, (int)-2320649);
        poseStack.m_252880_(0.0f, 0.0f, 1400.0f);
        int yOff = bgY + paddingY / 2;
        for (FormattedCharSequence line : tooltipLines) {
            int xOff = bgX + (bgWidth - this.MC.f_91062_.m_92724_(line)) / 2;
            guiGraphics.m_280649_(this.MC.f_91062_, line, xOff, yOff, 14928378, false);
            yOff += fontLineHeight;
        }
        poseStack.m_85849_();
    }

    public SkillsScreen getScreen() {
        return this.screen;
    }

    public float getScale() {
        return this.scale;
    }

    public int getIconShakeDelta() {
        return this.iconShakeDelta;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setIconShakeDelta(int iconShakeDelta) {
        this.iconShakeDelta = iconShakeDelta;
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public Skill getSkill() {
        return this.skill;
    }
}

