/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.client.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.base.AbstractDescriptionWidget;
import it.mralxart.arcaneabilities.capability.skills.PlayerSkillsUtils;
import it.mralxart.arcaneabilities.client.screen.SkillsScreen;
import it.mralxart.arcaneabilities.client.screen.base.ICustomRenderWidget;
import it.mralxart.arcaneabilities.client.screen.base.IHoverableWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;

public class CategoryWidget
extends AbstractDescriptionWidget
implements IHoverableWidget,
ITickingWidget,
ICustomRenderWidget {
    private final SkillsScreen screen;
    private final String category;
    private float scale = 1.0f;
    protected int iconShakeDelta = 0;

    public CategoryWidget(int x, int y, SkillsScreen screen, String category) {
        super(x, y, 16, 17);
        this.screen = screen;
        this.category = category;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void m_5691_() {
        if (!this.category.equals("magic") && !this.category.equals("player")) {
            PlayerSkillsUtils.setCategory((Player)this.MC.f_91074_, this.category);
            this.screen.category = this.category;
            this.screen.resetScreen();
        } else {
            this.iconShakeDelta = Math.min(15, this.iconShakeDelta + (this.iconShakeDelta > 0 ? 5 : 10));
        }
    }

    private int getCategoryStartIndex(String category) {
        switch (category) {
            case "mining": {
                return 1;
            }
            case "fight": {
                return 2;
            }
            case "magic": {
                return 3;
            }
            case "player": {
                return 4;
            }
        }
        return 1;
    }

    @Override
    public void customRenderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float color;
        PoseStack poseStack = guiGraphics.m_280168_();
        float[] shaderColor = RenderSystem.getShaderColor();
        String playerCategory = PlayerSkillsUtils.getCategory((Player)this.MC.f_91074_);
        poseStack.m_85836_();
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / this.scale, ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / this.scale, 0.0f);
        if (this.iconShakeDelta != 0) {
            color = (float)this.iconShakeDelta * 0.05f;
            RenderSystem.setShaderColor((float)shaderColor[0], (float)(shaderColor[1] - color), (float)(shaderColor[2] - color), (float)shaderColor[3]);
            poseStack.m_252781_(Axis.f_252403_.m_252961_((float)Math.sin(((float)this.MC.f_91074_.f_19797_ + partialTick) * 0.5f) * 0.05f));
            if ((double)this.scale <= 1.1) {
                this.scale += ((float)this.iconShakeDelta - partialTick) * 2.5E-4f;
            }
        }
        color = 1.0f;
        if (this.MC.f_91074_ != null) {
            color = (float)(0.85 + Math.sin((double)this.MC.f_91074_.f_19797_ * Math.ceil((float)this.getCategoryStartIndex(this.category) / 2.0f) * 0.055) * 0.2);
        }
        if (playerCategory.equals(this.category)) {
            guiGraphics.m_280163_(new ResourceLocation("arcane_abilities:textures/gui/widget/category.png"), -7, -11, 0.0f, 0.0f, 22, 22, 22, 22);
        } else {
            guiGraphics.m_280163_(new ResourceLocation("arcane_abilities:textures/gui/widget/category.png"), -11, -11, 0.0f, 0.0f, 22, 22, 22, 22);
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
        if (playerCategory.equals(this.category)) {
            guiGraphics.m_280163_(new ResourceLocation("arcane_abilities:textures/gui/widget/category_background.png"), -7, -11, 0.0f, 0.0f, 22, 22, 22, 22);
            guiGraphics.m_280163_(new ResourceLocation("arcane_abilities:textures/gui/widget/category_" + this.category + ".png"), -4, -8, 0.0f, 0.0f, 16, 17, 16, 17);
        } else {
            guiGraphics.m_280163_(new ResourceLocation("arcane_abilities:textures/gui/widget/category_background.png"), -11, -11, 0.0f, 0.0f, 22, 22, 22, 22);
            guiGraphics.m_280163_(new ResourceLocation("arcane_abilities:textures/gui/widget/category_" + this.category + ".png"), -8, -8, 0.0f, 0.0f, 16, 17, 16, 17);
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.m_198029_()) {
            if (playerCategory.equals(this.category)) {
                guiGraphics.m_280163_(new ResourceLocation("arcane_abilities:textures/gui/widget/category_selected.png"), -8, -12, 0.0f, 0.0f, 24, 24, 24, 24);
            } else {
                guiGraphics.m_280163_(new ResourceLocation("arcane_abilities:textures/gui/widget/category_selected.png"), -12, -12, 0.0f, 0.0f, 24, 24, 24, 24);
            }
        }
        poseStack.m_85849_();
    }

    public void onTick() {
        float maxScale = 1.1f;
        float minScale = 1.0f;
        if (this.m_274382_()) {
            if (this.scale < maxScale) {
                this.scale = Math.min(maxScale, this.scale + (maxScale - this.scale) * 0.25f);
            }
        } else if (this.scale != minScale) {
            this.scale = Math.max(minScale, this.scale - 0.025f);
        }
        if (this.iconShakeDelta > 0) {
            --this.iconShakeDelta;
        }
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        PoseStack poseStack = guiGraphics.m_280168_();
        ArrayList<MutableComponent> entries = new ArrayList<MutableComponent>(Arrays.asList(Component.m_237115_((String)("tooltip.arcane_abilities.gui.category." + this.category)).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.UNDERLINE)));
        entries.add(Component.m_237113_((String)"\u300b-\u2505-< \u272f\u25e6\u272f >-\u2505-\u300a"));
        int maxWidthInPixels = 300;
        int renderWidth = 0;
        ArrayList tooltipLines = new ArrayList();
        for (MutableComponent entry : entries) {
            tooltipLines.addAll(this.MC.f_91062_.m_92923_((FormattedText)entry, maxWidthInPixels));
        }
        for (FormattedCharSequence line : tooltipLines) {
            renderWidth = Math.max(renderWidth, this.MC.f_91062_.m_92724_(line));
        }
        Objects.requireNonNull(this.MC.f_91062_);
        int fontLineHeight = 9 + 1;
        int totalTextHeight = tooltipLines.size() * fontLineHeight;
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.m_5711_() / 2.0f) / this.scale, ((float)this.m_252907_() + (float)this.m_93694_() / 2.0f) / this.scale, 0.0f);
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        int paddingX = 10;
        int paddingY = 8;
        int bgWidth = renderWidth + paddingX;
        int bgHeight = totalTextHeight + paddingY;
        int bgX = -bgWidth / 2;
        int bgY = this.f_93619_ + 3;
        String playerCategory = PlayerSkillsUtils.getCategory((Player)this.MC.f_91074_);
        if (playerCategory.equals(this.category)) {
            bgX += 8;
        }
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)bgX, (int)bgY, (int)bgWidth, (int)bgHeight, (int)1300, (int)-267386864, (int)-267386864, (int)-395521, (int)-2320649);
        poseStack.m_252880_(0.0f, 0.0f, 1400.0f);
        int yOff = bgY + paddingY / 2;
        for (FormattedCharSequence line : tooltipLines) {
            int xOff = bgX + (bgWidth - this.MC.f_91062_.m_92724_(line)) / 2;
            guiGraphics.m_280649_(this.MC.f_91062_, line, xOff, yOff, 14928378, false);
            yOff += fontLineHeight;
        }
        poseStack.m_85849_();
    }
}

