/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.screen.base.IAutoScaledScreen;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.mralxart.arcaneabilities.capability.PlayerUtils;
import it.mralxart.arcaneabilities.capability.skills.PlayerSkillsUtils;
import it.mralxart.arcaneabilities.client.screen.base.ICustomRenderWidget;
import it.mralxart.arcaneabilities.client.screen.base.IHoverableWidget;
import it.mralxart.arcaneabilities.client.screen.base.ITickingWidget;
import it.mralxart.arcaneabilities.client.screen.widget.CategoryWidget;
import it.mralxart.arcaneabilities.client.screen.widget.ExitWidget;
import it.mralxart.arcaneabilities.client.screen.widget.HelpWidget;
import it.mralxart.arcaneabilities.client.screen.widget.LevelUpWidget;
import it.mralxart.arcaneabilities.client.screen.widget.SkillConnection;
import it.mralxart.arcaneabilities.client.screen.widget.SkillWidget;
import it.mralxart.arcaneabilities.client.screen.widget.SwipeWidget;
import it.mralxart.arcaneabilities.skills.Skill;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SkillsScreen
extends Screen
implements IAutoScaledScreen {
    private final Minecraft MC = Minecraft.m_91087_();
    private Map<String, SkillWidget> skillWidgets = new HashMap<String, SkillWidget>();
    private final List<SkillConnection> skillConnections;
    public final Player player;
    public int backgroundHeight = 316;
    public int backgroundWidth = 195;
    public float renderAnimation;
    protected double scrollSpeedX;
    protected double scrollSpeedY;
    protected double scrollX;
    protected double scrollY;
    protected int maxScrollX;
    protected int maxScrollY;
    public float zoom = 1.0f;
    public int ticksExisted;
    public final BlockPos pos;
    public String category;

    public SkillsScreen(BlockPos pos) {
        super((Component)Component.m_237119_());
        this.player = this.MC.f_91074_;
        this.pos = pos;
        this.skillConnections = new ArrayList<SkillConnection>();
        if (this.category == null) {
            this.category = "mining";
        }
    }

    public void m_7856_() {
        List<Skill> skillsList = PlayerSkillsUtils.getSkills((Player)this.MC.f_91074_);
        if (skillsList != null && !skillsList.isEmpty()) {
            String playerCategory = PlayerSkillsUtils.getCategory((Player)this.MC.f_91074_);
            int categoryStartIndex = this.getCategoryStartIndex(playerCategory);
            HashMap<String, SkillWidget> skillWidgets = new HashMap<String, SkillWidget>();
            int centerX = this.f_96543_ / 2 - 7;
            int centerY = this.f_96544_ / 2 - 7;
            int yOffset = 10;
            int xOffset = 24;
            int[][] positions = new int[][]{{0, 0}, {-2 * xOffset, -yOffset - 3}, {-2 * xOffset, yOffset + 16}, {2 * xOffset, -yOffset - 3 - 15}, {xOffset + 14, yOffset + 3 + 10}, {-xOffset, -7 * yOffset}, {-5 * xOffset, -2 * yOffset}, {-3 * xOffset - 21, 4 * yOffset - 8}, {4 * xOffset, -4 * yOffset}, {4 * xOffset + 24, 9}, {3 * xOffset + 11, 2 * yOffset + 13}};
            for (int i = 0; i < positions.length; ++i) {
                int[] pos = positions[i];
                int index = categoryStartIndex + i;
                SkillWidget widget = new SkillWidget(centerX + pos[0], centerY + pos[1], this, skillsList.get(index));
                this.m_142416_((GuiEventListener)widget);
                skillWidgets.put(skillsList.get(index).getId(), widget);
            }
            this.m_142416_((GuiEventListener)new LevelUpWidget(centerX - this.backgroundHeight / 2 + 32, centerY - 90, this));
            this.m_142416_((GuiEventListener)new ExitWidget(centerX + 150, centerY - 90, this));
            this.m_142416_((GuiEventListener)new HelpWidget(centerX + 125, centerY - 90, this));
            this.m_142416_((GuiEventListener)new SwipeWidget(centerX + 150, centerY, this));
            this.m_142416_((GuiEventListener)new CategoryWidget(centerX + 150, centerY - 25, this, "mining"));
            this.m_142416_((GuiEventListener)new CategoryWidget(centerX + 150, centerY - 55, this, "fight"));
            this.skillWidgets = skillWidgets;
            this.addGatewayConnections();
        }
    }

    public void m_86600_() {
        super.m_86600_();
        for (GuiEventListener listener : this.m_6702_()) {
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !((button = (AbstractButton)listener) instanceof ITickingWidget)) continue;
            ITickingWidget widget = (ITickingWidget)button;
            widget.onTick();
        }
    }

    private int getCategoryStartIndex(String category) {
        switch (category) {
            case "mining": {
                return 0;
            }
            case "fight": {
                return 11;
            }
            case "magic": {
                return 22;
            }
            case "player": {
                return 33;
            }
        }
        return 0;
    }

    public void addGatewayConnections() {
        this.skillConnections.clear();
        PlayerSkillsUtils.getSkills((Player)this.MC.f_91074_).forEach(this::addGatewayConnections);
    }

    private void addGatewayConnections(Skill skill) {
        skill.getConnectedSkills().forEach(connectedSkillId -> this.connectSkills(this.skillConnections, skill.getId(), (String)connectedSkillId));
    }

    protected void connectSkills(List<SkillConnection> connections, String skillId1, String skillId2) {
        SkillWidget button1 = this.skillWidgets.get(skillId1);
        SkillWidget button2 = this.skillWidgets.get(skillId2);
        if (button1 != null && button2 != null) {
            connections.add(new SkillConnection(button1, button2));
        }
    }

    private SkillWidget getSkillButton(String skillId) {
        return this.skillWidgets.get(skillId);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        this.m_280273_(guiGraphics);
        this.renderSpace(guiGraphics);
        this.renderAnimation += partialTick;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280163_(new ResourceLocation("arcane_abilities:textures/gui/new_leveling_gui.png"), centerX - this.backgroundHeight / 2, centerY - this.backgroundWidth / 2, 0.0f, 0.0f, this.backgroundHeight, this.backgroundWidth, this.backgroundHeight, this.backgroundWidth);
        RenderSystem.disableBlend();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.player != null) {
            Object widget;
            AbstractButton button;
            poseStack.m_85836_();
            int skillXp = PlayerUtils.getSkillValue(this.player, "skillXp");
            float percentage = skillXp != 0 ? (float)skillXp / 250.0f * 100.0f : 0.0f;
            guiGraphics.m_280163_(new ResourceLocation("arcane_abilities:textures/gui/widget/skill_xp_line.png"), centerX - 103, centerY + 75 + 6, 0.0f, 0.0f, (int)Math.ceil(percentage / 100.0f * 206.0f), 4, 206, 4);
            boolean xpHovered = ScreenUtils.isHovered((int)(centerX - 103), (int)(centerY + 75 + 6), (int)206, (int)4, (int)mouseX, (int)mouseY);
            float color = 1.0f;
            if (this.MC.f_91074_ != null) {
                color = (float)(0.85 + Math.sin((double)this.MC.f_91074_.f_19797_ * 2.0 * 0.075) * 0.3);
            }
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)1);
            RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
            if (xpHovered) {
                guiGraphics.m_280163_(new ResourceLocation("arcane_abilities:textures/gui/widget/skill_xp_highlight.png"), centerX - 105, centerY + 75 + 4, 0.0f, 0.0f, 210, 8, 210, 8);
            }
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
            poseStack.m_85836_();
            this.skillConnections.forEach(connection -> this.renderGatewayConnection(guiGraphics, (SkillConnection)connection, mouseX, mouseY));
            poseStack.m_85849_();
            poseStack.m_85836_();
            for (GuiEventListener listener : this.m_6702_()) {
                if (!(listener instanceof AbstractButton) || !((button = (AbstractButton)listener) instanceof ICustomRenderWidget)) continue;
                widget = (ICustomRenderWidget)button;
                widget.customRenderWidget(guiGraphics, mouseX, mouseY, partialTick);
            }
            poseStack.m_85849_();
            poseStack.m_85836_();
            for (GuiEventListener listener : this.m_6702_()) {
                if (!(listener instanceof AbstractButton) || !(button = (AbstractButton)listener).m_274382_() || !(button instanceof IHoverableWidget)) continue;
                widget = (IHoverableWidget)button;
                widget.onHovered(guiGraphics, mouseX, mouseY);
            }
            poseStack.m_85849_();
        }
    }

    public Optional<GuiEventListener> getWidgetAt(double mouseX, double mouseY) {
        return super.m_94729_(mouseX, mouseY).filter(listener -> !(listener instanceof SkillWidget));
    }

    private void renderGatewayConnection(GuiGraphics guiGraphics, SkillConnection connection, int mouseX, int mouseY) {
        SkillWidget button1 = connection.getSkillId1();
        SkillWidget button2 = connection.getSkillId2();
        this.renderConnection(guiGraphics, button1, button2);
    }

    private void renderConnection(GuiGraphics guiGraphics, SkillWidget button1, SkillWidget button2) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        double connectionX = (float)button1.m_252754_() + (float)button1.m_5711_() / 2.0f;
        double connectionY = (float)button1.m_252907_() + (float)button1.m_93694_() / 2.0f;
        poseStack.m_85837_(connectionX + this.scrollX, connectionY + this.scrollY, 0.0);
        float rotation = it.mralxart.arcaneabilities.utils.ScreenUtils.getAngleBetweenButtons(button1, button2);
        poseStack.m_252781_(Axis.f_252403_.m_252961_(rotation));
        int length = (int)(it.mralxart.arcaneabilities.utils.ScreenUtils.getDistanceBetweenButtons(button1, button2) / this.zoom);
        boolean highlighted = this.isSkillLearned(button1.getSkill());
        poseStack.m_85841_(this.zoom, this.zoom, 1.0f);
        guiGraphics.m_280411_(new ResourceLocation("arcane_abilities:textures/gui/widget/conection_line.png"), 0, -3, length, 6, -this.renderAnimation, highlighted ? 0.0f : 6.0f, length, 6, 30, 12);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    private void renderSpace(GuiGraphics guiGraphics) {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.m_252880_((float)(centerX - this.backgroundHeight / 2), (float)(centerY - this.backgroundWidth / 2), 0.0f);
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        guiGraphics.m_280411_(new ResourceLocation("arcane_abilities:textures/gui/gui_space.png"), 9, 9, 298, 177, -this.renderAnimation, 0.0f, 298, 177, 596, 177);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    protected boolean isSkillLearned(Skill skill) {
        return PlayerSkillsUtils.isSkillPurchasedById((Player)this.MC.f_91074_, skill.getId());
    }

    public boolean m_7043_() {
        return false;
    }

    public void resetScreen() {
        this.m_169413_();
        this.m_7856_();
    }

    public int getAutoScale() {
        return 0;
    }

    public Minecraft getMC() {
        return this.MC;
    }

    public Map<String, SkillWidget> getSkillWidgets() {
        return this.skillWidgets;
    }

    public List<SkillConnection> getSkillConnections() {
        return this.skillConnections;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getBackgroundHeight() {
        return this.backgroundHeight;
    }

    public int getBackgroundWidth() {
        return this.backgroundWidth;
    }

    public float getRenderAnimation() {
        return this.renderAnimation;
    }

    public double getScrollSpeedX() {
        return this.scrollSpeedX;
    }

    public double getScrollSpeedY() {
        return this.scrollSpeedY;
    }

    public double getScrollX() {
        return this.scrollX;
    }

    public double getScrollY() {
        return this.scrollY;
    }

    public int getMaxScrollX() {
        return this.maxScrollX;
    }

    public int getMaxScrollY() {
        return this.maxScrollY;
    }

    public float getZoom() {
        return this.zoom;
    }

    public int getTicksExisted() {
        return this.ticksExisted;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public String getCategory() {
        return this.category;
    }

    public void setSkillWidgets(Map<String, SkillWidget> skillWidgets) {
        this.skillWidgets = skillWidgets;
    }

    public void setBackgroundHeight(int backgroundHeight) {
        this.backgroundHeight = backgroundHeight;
    }

    public void setBackgroundWidth(int backgroundWidth) {
        this.backgroundWidth = backgroundWidth;
    }

    public void setRenderAnimation(float renderAnimation) {
        this.renderAnimation = renderAnimation;
    }

    public void setScrollSpeedX(double scrollSpeedX) {
        this.scrollSpeedX = scrollSpeedX;
    }

    public void setScrollSpeedY(double scrollSpeedY) {
        this.scrollSpeedY = scrollSpeedY;
    }

    public void setScrollX(double scrollX) {
        this.scrollX = scrollX;
    }

    public void setScrollY(double scrollY) {
        this.scrollY = scrollY;
    }

    public void setMaxScrollX(int maxScrollX) {
        this.maxScrollX = maxScrollX;
    }

    public void setMaxScrollY(int maxScrollY) {
        this.maxScrollY = maxScrollY;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public void setTicksExisted(int ticksExisted) {
        this.ticksExisted = ticksExisted;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}

