/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.client.renderer.item;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class CombinedRelicRenderer
extends BlockEntityWithoutLevelRenderer {
    private final Map<ResourceLocation, ItemStack> parentCache = new HashMap<ResourceLocation, ItemStack>();

    public CombinedRelicRenderer() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        ItemStack parent1 = this.getParentStack(tag, "Parent1");
        ItemStack parent2 = this.getParentStack(tag, "Parent2");
        if (parent1.m_41619_() || parent2.m_41619_()) {
            super.m_108829_(stack, transformType, poseStack, buffer, packedLight, packedOverlay);
            return;
        }
        long cycleDuration = 2000L;
        long time = System.currentTimeMillis();
        boolean showFirst = time % cycleDuration < cycleDuration / 2L;
        ItemStack itemToRender = showFirst ? parent1 : parent2;
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BakedModel model = itemRenderer.m_174264_(itemToRender, (Level)Minecraft.m_91087_().f_91073_, (LivingEntity)Minecraft.m_91087_().f_91074_, 0);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        if (transformType == ItemDisplayContext.GUI) {
            boolean flatLight;
            RenderSystem.applyModelViewMatrix();
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            boolean bl = flatLight = !model.m_7547_();
            if (flatLight) {
                Lighting.m_84930_();
            }
            itemRenderer.m_115143_(stack, ItemDisplayContext.NONE, false, poseStack, (MultiBufferSource)bufferSource, packedLight, packedOverlay, model);
            bufferSource.m_109911_();
            RenderSystem.enableDepthTest();
            if (flatLight) {
                Lighting.m_84931_();
            }
        } else if (!itemToRender.m_41619_()) {
            itemRenderer.m_115143_(itemToRender, transformType, false, poseStack, buffer, packedLight, packedOverlay, model);
        }
        poseStack.m_85849_();
    }

    private ItemStack getParentStack(CompoundTag tag, String key) {
        if (!tag.m_128441_(key)) {
            return ItemStack.f_41583_;
        }
        ResourceLocation id = new ResourceLocation(tag.m_128461_(key));
        return this.parentCache.computeIfAbsent(id, loc -> new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(loc)));
    }
}

