/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.capability.skills;

import it.mralxart.arcaneabilities.capability.skills.PlayerSkills;
import it.mralxart.arcaneabilities.data.SkillManager;
import it.mralxart.arcaneabilities.network.NetworkHandler;
import it.mralxart.arcaneabilities.network.messages.CapabilitySyncPacket;
import it.mralxart.arcaneabilities.skills.Skill;
import it.mralxart.arcaneabilities.utils.CapabilityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerSkillsUtils {
    public static String getSwipe(Player player) {
        Optional capability = CapabilityUtils.getRelicsCapability(player).resolve();
        return ((PlayerSkills)capability.get()).getSwipe();
    }

    public static void setSwipe(Player player, String category) {
        Optional capability = CapabilityUtils.getRelicsCapability(player).resolve();
        if (!capability.isEmpty()) {
            ((PlayerSkills)capability.get()).setSwipe(category);
            PlayerSkillsUtils.sync(player);
        }
    }

    public static String getCategory(Player player) {
        Optional capability = CapabilityUtils.getRelicsCapability(player).resolve();
        return ((PlayerSkills)capability.get()).getCategory();
    }

    public static void setCategory(Player player, String category) {
        Optional capability = CapabilityUtils.getRelicsCapability(player).resolve();
        if (!capability.isEmpty()) {
            ((PlayerSkills)capability.get()).setCategory(category);
            PlayerSkillsUtils.sync(player);
        }
    }

    public static int getSkillPoints(Player player) {
        Optional capability = CapabilityUtils.getRelicsCapability(player).resolve();
        return capability.map(PlayerSkills::getSkillPoints).orElse(0);
    }

    public static void setSkillPoints(Player player, int num) {
        Optional capability = CapabilityUtils.getRelicsCapability(player).resolve();
        if (capability.isPresent()) {
            ((PlayerSkills)capability.get()).setSkillPoints(num);
            PlayerSkillsUtils.sync(player);
        }
    }

    public static List<Skill> getSkills(Player player) {
        Optional capability = CapabilityUtils.getRelicsCapability(player).resolve();
        return capability.isEmpty() ? new ArrayList() : ((PlayerSkills)capability.get()).getSkills();
    }

    public static void setSkills(Player player, List<Skill> data) {
        Optional capability = CapabilityUtils.getRelicsCapability(player).resolve();
        if (capability.isPresent()) {
            ((PlayerSkills)capability.get()).setSkills(data);
            PlayerSkillsUtils.sync(player);
        }
    }

    public static void setSkillLevelById(Player player, String skillId, int level) {
        Optional capability = CapabilityUtils.getRelicsCapability(player).resolve();
        List<Skill> skills = PlayerSkillsUtils.getSkills(player);
        Optional<Skill> skillOptional = skills.stream().filter(skill -> skill.getId().equals(skillId)).findFirst();
        skillOptional.ifPresent(skill -> {
            skill.setLevel(level);
            PlayerSkillsUtils.sync(player);
        });
    }

    public static void addSkillLevelById(Player player, String skillId, int levels) {
        List<Skill> skills = PlayerSkillsUtils.getSkills(player);
        Optional<Skill> skillOptional = skills.stream().filter(skill -> skill.getId().equals(skillId)).findFirst();
        skillOptional.ifPresent(skill -> {
            skill.setLevel(skill.getLevel() + levels);
            PlayerSkillsUtils.sync(player);
        });
    }

    public static int getSkillLevelById(Player player, String skillId) {
        Optional capability = CapabilityUtils.getRelicsCapability(player).resolve();
        List<Skill> skillss = PlayerSkillsUtils.getSkills(player);
        return capability.map(skills -> skillss.stream().filter(skill -> skill.getId().equals(skillId)).findFirst().map(Skill::getLevel).orElse(0)).orElse(0);
    }

    public static void setSkillPurchasedById(Player player, String skillId, boolean purchased) {
        Optional capability = CapabilityUtils.getRelicsCapability(player).resolve();
        List<Skill> skills = PlayerSkillsUtils.getSkills(player);
        Optional<Skill> skillOptional = skills.stream().filter(skill -> skill.getId().equals(skillId)).findFirst();
        skillOptional.ifPresent(skill -> {
            skill.setPurchased(purchased);
            PlayerSkillsUtils.sync(player);
        });
    }

    public static void setSkillActiveById(Player player, String skillId, boolean active) {
        List<Skill> skills = PlayerSkillsUtils.getSkills(player);
        Optional<Skill> skillOptional = skills.stream().filter(skill -> skill.getId().equals(skillId)).findFirst();
        skillOptional.ifPresent(skill -> {
            skill.setActive(active);
            PlayerSkillsUtils.sync(player);
        });
    }

    public static boolean isConnectedSkillUnlocked(Player player, String skillId) {
        Optional capability = CapabilityUtils.getRelicsCapability(player).resolve();
        if (capability.isPresent()) {
            List<Skill> skills = ((PlayerSkills)capability.get()).getSkills();
            Optional<Skill> connectedSkill = skills.stream().filter(skill -> skill.getConnectedSkills().contains(skillId)).findFirst();
            return connectedSkill.map(Skill::isPurchased).orElse(false);
        }
        return false;
    }

    public static boolean isSkillPurchasedById(Player player, String skillId) {
        Optional capability = CapabilityUtils.getRelicsCapability(player).resolve();
        List<Skill> skillss = PlayerSkillsUtils.getSkills(player);
        return capability.map(skills -> skillss.stream().filter(skill -> skill.getId().equals(skillId)).findFirst().map(Skill::isPurchased).orElse(false)).orElse(false);
    }

    public static boolean isSkillActiveById(Player player, String skillId) {
        Optional capability = CapabilityUtils.getRelicsCapability(player).resolve();
        List<Skill> skillss = PlayerSkillsUtils.getSkills(player);
        return capability.map(skills -> skillss.stream().filter(skill -> skill.getId().equals(skillId)).findFirst().map(Skill::isActive).orElse(false)).orElse(false);
    }

    public static Optional<Skill> getSkillById(Player player, String skillId) {
        Optional capability = CapabilityUtils.getRelicsCapability(player).resolve();
        List<Skill> skillss = PlayerSkillsUtils.getSkills(player);
        return capability.map(skills -> skillss.stream().filter(skill -> skill.getId().equals(skillId)).findFirst()).orElse(Optional.empty());
    }

    public static boolean mayPlayerPurchase(Player player, String skillId) {
        return PlayerSkillsUtils.getSkillPoints(player) >= SkillManager.getCostById(skillId);
    }

    public static boolean mayPlayerUpgrade(Player player, String skillId) {
        return PlayerSkillsUtils.getSkillPoints(player) >= SkillManager.getCostById(skillId) && PlayerSkillsUtils.getSkillLevelById(player, skillId) < SkillManager.getMaxLevelById(skillId);
    }

    public static void sync(Player player) {
        Optional capability = CapabilityUtils.getRelicsCapability(player).resolve();
        if (capability.isPresent()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHandler.sendToClient((Object)new CapabilitySyncPacket((CompoundTag)((PlayerSkills)capability.get()).serializeNBT()), serverPlayer);
            } else if (player instanceof LocalPlayer) {
                NetworkHandler.sendToServer(new CapabilitySyncPacket((CompoundTag)((PlayerSkills)capability.get()).serializeNBT()));
            }
        }
    }
}

