/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.capability.skills;

import it.mralxart.arcaneabilities.data.SkillManager;
import it.mralxart.arcaneabilities.data.SkillsBuilder;
import it.mralxart.arcaneabilities.init.CapabilityRegistry;
import it.mralxart.arcaneabilities.skills.Skill;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public interface PlayerSkills
extends INBTSerializable<CompoundTag> {
    public List<Skill> getSkills();

    public void setSkills(List<Skill> var1);

    public int getSkillPoints();

    public void setSkillPoints(int var1);

    public int getMiningXp();

    public void setMiningXp(int var1);

    public int getFightXp();

    public void setFightXp(int var1);

    public int getMagicXp();

    public void setMagicXp(int var1);

    public int getPlayerXp();

    public void setPlayerXp(int var1);

    public int getSkillXp();

    public void setSkillXp(int var1);

    public int getMiningLvl();

    public void setMiningLvl(int var1);

    public int getFightLvl();

    public void setFightLvl(int var1);

    public int getMagicLvl();

    public void setMagicLvl(int var1);

    public int getPlayerLvl();

    public void setPlayerLvl(int var1);

    public String getCategory();

    public void setCategory(String var1);

    public String getSwipe();

    public void setSwipe(String var1);

    public boolean isFSkill3Enabled();

    public void setFSkill3Enabled(boolean var1);

    public double getPlayerDamage();

    public void setPlayerDamage(double var1);

    public void resetSkills();

    public static class PlayerCapability
    implements PlayerSkills {
        private String category = "mining";
        private String swipe = "buy";
        private List<Skill> skills = new ArrayList<Skill>();
        private List<Object> attributes = new ArrayList<Object>();
        private int skillPoints = 0;
        private int skillXp = 0;
        private int miningXp = 0;
        private int miningLvl = 0;
        private int fightXp = 0;
        private int fightLvl = 0;
        private int magicXp = 0;
        private int magicLvl = 0;
        private int playerXp = 0;
        private int playerLvl = 0;
        private boolean fSkill3Enabled = false;
        private double playerDamage = 0.0;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("skillXp", this.skillXp);
            tag.m_128405_("miningXp", this.miningXp);
            tag.m_128405_("miningLvl", this.miningLvl);
            tag.m_128405_("fightXp", this.fightXp);
            tag.m_128405_("fightLvl", this.fightLvl);
            tag.m_128405_("magicXp", this.magicXp);
            tag.m_128405_("magicLvl", this.magicLvl);
            tag.m_128405_("playerXp", this.playerXp);
            tag.m_128405_("playerLvl", this.playerLvl);
            tag.m_128405_("skillPoints", this.skillPoints);
            tag.m_128359_("category", this.category);
            tag.m_128347_("playerDamage", this.playerDamage);
            tag.m_128379_("fSkill3Enabled", this.fSkill3Enabled);
            tag.m_128365_("skills", (Tag)this.serializeSkillsList());
            return tag;
        }

        private ListTag serializeSkillsList() {
            ListTag skillsTag = new ListTag();
            Iterator<Skill> var2 = this.skills.iterator();
            while (var2.hasNext()) {
                Skill skill = var2.next();
                if (skill == null) continue;
                CompoundTag skillTag = new CompoundTag();
                skillTag.m_128359_("id", skill.getId());
                skillTag.m_128405_("level", skill.getLevel());
                skillTag.m_128379_("purchased", skill.isPurchased());
                skillTag.m_128379_("active", skill.isActive());
                List<String> connections = skill.getConnectedSkills();
                ListTag connectionsTag = new ListTag();
                for (String connectedSkillId : connections) {
                    connectionsTag.add((Object)StringTag.m_129297_((String)connectedSkillId));
                }
                skillTag.m_128365_("connections", (Tag)connectionsTag);
                skillsTag.add((Object)skillTag);
            }
            return skillsTag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.skillXp = nbt.m_128451_("skillXp");
            this.miningXp = nbt.m_128451_("miningXp");
            this.miningLvl = nbt.m_128451_("miningLvl");
            this.fightXp = nbt.m_128451_("fightXp");
            this.fightLvl = nbt.m_128451_("fightLvl");
            this.magicXp = nbt.m_128451_("magicXp");
            this.magicLvl = nbt.m_128451_("magicLvl");
            this.playerXp = nbt.m_128451_("playerXp");
            this.playerLvl = nbt.m_128451_("playerLvl");
            this.skillPoints = nbt.m_128451_("skillPoints");
            this.category = nbt.m_128461_("category");
            this.playerDamage = nbt.m_128459_("playerDamage");
            this.fSkill3Enabled = nbt.m_128471_("fSkill3Enabled");
            if (nbt.m_128425_("skills", 9)) {
                ListTag skillsTag = nbt.m_128437_("skills", 10);
                ArrayList newSkills = new ArrayList();
                for (Tag tag : skillsTag) {
                    CompoundTag skillTag = (CompoundTag)tag;
                    String skillId = skillTag.m_128461_("id");
                    int skillLevel = skillTag.m_128451_("level");
                    boolean purchased = skillTag.m_128471_("purchased");
                    boolean active = skillTag.m_128471_("active");
                    ListTag connectionsTag = skillTag.m_128437_("connections", 10);
                    Optional<SkillsBuilder> optionalSkillsBuilder = SkillManager.getDefaultSkills().stream().filter(sb -> sb.getId().equals(skillId)).findFirst();
                    optionalSkillsBuilder.ifPresent(skillsBuilderx -> {
                        Skill skill = skillsBuilderx.toSkill();
                        skill.setLevel(skillLevel);
                        skill.setPurchased(purchased);
                        skill.setActive(active);
                        for (Tag connectionTag : connectionsTag) {
                            String connectedSkillId = connectionTag.m_7916_();
                            Optional<SkillsBuilder> var10000 = SkillManager.getSkillById(connectedSkillId);
                            Objects.requireNonNull(skill);
                            var10000.ifPresent(skill::connect);
                        }
                        newSkills.add(skill);
                    });
                }
                this.skills.clear();
                this.skills.addAll(newSkills);
            }
            List<SkillsBuilder> defaultSkills = SkillManager.getDefaultSkills();
            for (SkillsBuilder skillsBuilder : defaultSkills) {
                String skillId = skillsBuilder.getId();
                if (!this.skills.stream().noneMatch(skillx -> skillx.getId().equals(skillId))) continue;
                Skill skill = skillsBuilder.toSkill();
                this.skills.add(skill);
            }
            this.skills.removeIf(skillx -> defaultSkills.stream().noneMatch(sb -> sb.getId().equals(skillx.getId())));
        }

        @Override
        public void resetSkills() {
            this.skills.clear();
            List<SkillsBuilder> defaultSkills = SkillManager.getDefaultSkills();
            for (SkillsBuilder skillsBuilder : defaultSkills) {
                Skill skill = skillsBuilder.toSkill();
                this.skills.add(skill);
            }
        }

        @Override
        public boolean isFSkill3Enabled() {
            return this.fSkill3Enabled;
        }

        @Override
        public void setFSkill3Enabled(boolean fSkill3Enabled) {
            this.fSkill3Enabled = fSkill3Enabled;
        }

        @Override
        public String getCategory() {
            return this.category;
        }

        @Override
        public String getSwipe() {
            return this.swipe;
        }

        @Override
        public List<Skill> getSkills() {
            return this.skills;
        }

        public List<Object> getAttributes() {
            return this.attributes;
        }

        @Override
        public int getSkillPoints() {
            return this.skillPoints;
        }

        @Override
        public int getSkillXp() {
            return this.skillXp;
        }

        @Override
        public int getMiningXp() {
            return this.miningXp;
        }

        @Override
        public int getMiningLvl() {
            return this.miningLvl;
        }

        @Override
        public int getFightXp() {
            return this.fightXp;
        }

        @Override
        public int getFightLvl() {
            return this.fightLvl;
        }

        @Override
        public int getMagicXp() {
            return this.magicXp;
        }

        @Override
        public int getMagicLvl() {
            return this.magicLvl;
        }

        @Override
        public int getPlayerXp() {
            return this.playerXp;
        }

        @Override
        public int getPlayerLvl() {
            return this.playerLvl;
        }

        @Override
        public double getPlayerDamage() {
            return this.playerDamage;
        }

        @Override
        public void setCategory(String category) {
            this.category = category;
        }

        @Override
        public void setSwipe(String swipe) {
            this.swipe = swipe;
        }

        @Override
        public void setSkills(List<Skill> skills) {
            this.skills = skills;
        }

        public void setAttributes(List<Object> attributes) {
            this.attributes = attributes;
        }

        @Override
        public void setSkillPoints(int skillPoints) {
            this.skillPoints = skillPoints;
        }

        @Override
        public void setSkillXp(int skillXp) {
            this.skillXp = skillXp;
        }

        @Override
        public void setMiningXp(int miningXp) {
            this.miningXp = miningXp;
        }

        @Override
        public void setMiningLvl(int miningLvl) {
            this.miningLvl = miningLvl;
        }

        @Override
        public void setFightXp(int fightXp) {
            this.fightXp = fightXp;
        }

        @Override
        public void setFightLvl(int fightLvl) {
            this.fightLvl = fightLvl;
        }

        @Override
        public void setMagicXp(int magicXp) {
            this.magicXp = magicXp;
        }

        @Override
        public void setMagicLvl(int magicLvl) {
            this.magicLvl = magicLvl;
        }

        @Override
        public void setPlayerXp(int playerXp) {
            this.playerXp = playerXp;
        }

        @Override
        public void setPlayerLvl(int playerLvl) {
            this.playerLvl = playerLvl;
        }

        @Override
        public void setPlayerDamage(double playerDamage) {
            this.playerDamage = playerDamage;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlayerCapability)) {
                return false;
            }
            PlayerCapability other = (PlayerCapability)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSkillPoints() != other.getSkillPoints()) {
                return false;
            }
            if (this.getSkillXp() != other.getSkillXp()) {
                return false;
            }
            if (this.getMiningXp() != other.getMiningXp()) {
                return false;
            }
            if (this.getMiningLvl() != other.getMiningLvl()) {
                return false;
            }
            if (this.getFightXp() != other.getFightXp()) {
                return false;
            }
            if (this.getFightLvl() != other.getFightLvl()) {
                return false;
            }
            if (this.getMagicXp() != other.getMagicXp()) {
                return false;
            }
            if (this.getMagicLvl() != other.getMagicLvl()) {
                return false;
            }
            if (this.getPlayerXp() != other.getPlayerXp()) {
                return false;
            }
            if (this.getPlayerLvl() != other.getPlayerLvl()) {
                return false;
            }
            if (this.isFSkill3Enabled() != other.isFSkill3Enabled()) {
                return false;
            }
            if (Double.compare(this.getPlayerDamage(), other.getPlayerDamage()) != 0) {
                return false;
            }
            String this$category = this.getCategory();
            String other$category = other.getCategory();
            if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
                return false;
            }
            String this$swipe = this.getSwipe();
            String other$swipe = other.getSwipe();
            if (this$swipe == null ? other$swipe != null : !this$swipe.equals(other$swipe)) {
                return false;
            }
            List<Skill> this$skills = this.getSkills();
            List<Skill> other$skills = other.getSkills();
            if (this$skills == null ? other$skills != null : !((Object)this$skills).equals(other$skills)) {
                return false;
            }
            List<Object> this$attributes = this.getAttributes();
            List<Object> other$attributes = other.getAttributes();
            return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlayerCapability;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSkillPoints();
            result = result * 59 + this.getSkillXp();
            result = result * 59 + this.getMiningXp();
            result = result * 59 + this.getMiningLvl();
            result = result * 59 + this.getFightXp();
            result = result * 59 + this.getFightLvl();
            result = result * 59 + this.getMagicXp();
            result = result * 59 + this.getMagicLvl();
            result = result * 59 + this.getPlayerXp();
            result = result * 59 + this.getPlayerLvl();
            result = result * 59 + (this.isFSkill3Enabled() ? 79 : 97);
            long $playerDamage = Double.doubleToLongBits(this.getPlayerDamage());
            result = result * 59 + (int)($playerDamage >>> 32 ^ $playerDamage);
            String $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : $category.hashCode());
            String $swipe = this.getSwipe();
            result = result * 59 + ($swipe == null ? 43 : $swipe.hashCode());
            List<Skill> $skills = this.getSkills();
            result = result * 59 + ($skills == null ? 43 : ((Object)$skills).hashCode());
            List<Object> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            return result;
        }

        public String toString() {
            return "PlayerSkills.PlayerCapability(category=" + this.getCategory() + ", swipe=" + this.getSwipe() + ", skills=" + String.valueOf(this.getSkills()) + ", attributes=" + String.valueOf(this.getAttributes()) + ", skillPoints=" + this.getSkillPoints() + ", skillXp=" + this.getSkillXp() + ", miningXp=" + this.getMiningXp() + ", miningLvl=" + this.getMiningLvl() + ", fightXp=" + this.getFightXp() + ", fightLvl=" + this.getFightLvl() + ", magicXp=" + this.getMagicXp() + ", magicLvl=" + this.getMagicLvl() + ", playerXp=" + this.getPlayerXp() + ", playerLvl=" + this.getPlayerLvl() + ", fSkill3Enabled=" + this.isFSkill3Enabled() + ", playerDamage=" + this.getPlayerDamage() + ")";
        }
    }

    public static class RelicsCapabilityProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final PlayerSkills backend = new PlayerCapability();

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
            return CapabilityRegistry.DATA.orEmpty(cap, LazyOptional.of(() -> this.backend));
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.backend.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.backend.deserializeNBT((Tag)nbt);
        }
    }
}

