/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.capability;

import it.mralxart.arcaneabilities.capability.skills.PlayerSkills;
import it.mralxart.arcaneabilities.capability.skills.PlayerSkillsUtils;
import it.mralxart.arcaneabilities.utils.CapabilityUtils;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;

public class PlayerUtils {
    public static int getSkillValue(Player player, String skillName) {
        return CapabilityUtils.getRelicsCapability(player).resolve().map(playerSkills -> switch (skillName) {
            case "skillXp" -> playerSkills.getSkillXp();
            case "miningXp" -> playerSkills.getMiningXp();
            case "miningLvl" -> playerSkills.getMiningLvl();
            case "fightXp" -> playerSkills.getFightXp();
            case "fightLvl" -> playerSkills.getFightLvl();
            case "magicXp" -> playerSkills.getMagicXp();
            case "magicLvl" -> playerSkills.getMagicLvl();
            case "playerXp" -> playerSkills.getPlayerXp();
            case "playerLvl" -> playerSkills.getPlayerLvl();
            default -> 0;
        }).orElse(0);
    }

    public static void setSkillValue(Player player, String skillName, int num) {
        Optional capability = CapabilityUtils.getRelicsCapability(player).resolve();
        if (capability.isPresent()) {
            switch (skillName) {
                case "skillXp": {
                    ((PlayerSkills)capability.get()).setSkillXp(num);
                    break;
                }
                case "miningXp": {
                    ((PlayerSkills)capability.get()).setMiningXp(num);
                    break;
                }
                case "miningLvl": {
                    ((PlayerSkills)capability.get()).setMiningLvl(num);
                    break;
                }
                case "fightXp": {
                    ((PlayerSkills)capability.get()).setFightXp(num);
                    break;
                }
                case "fightLvl": {
                    ((PlayerSkills)capability.get()).setFightLvl(num);
                    break;
                }
                case "magicXp": {
                    ((PlayerSkills)capability.get()).setMagicXp(num);
                    break;
                }
                case "magicLvl": {
                    ((PlayerSkills)capability.get()).setMagicLvl(num);
                    break;
                }
                case "playerXp": {
                    ((PlayerSkills)capability.get()).setPlayerXp(num);
                    break;
                }
                case "playerLvl": {
                    ((PlayerSkills)capability.get()).setPlayerLvl(num);
                }
            }
            PlayerSkillsUtils.sync(player);
        }
    }
}

