/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network;

import com.google.common.base.Preconditions;
import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.klikli_dev.occultism.integration.emi.impl.EmiHelper;
import com.klikli_dev.occultism.network.MessageBase;
import com.klikli_dev.occultism.network.OccultismPackets;
import com.klikli_dev.occultism.util.StorageUtil;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.network.NetworkEvent;

public class MessageSetRecipeByTemplate
extends MessageBase {
    private ResourceLocation id;
    private NonNullList<ItemStack> ingredientTemplates;

    public MessageSetRecipeByTemplate(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageSetRecipeByTemplate(ResourceLocation id, NonNullList<ItemStack> ingredientTemplates) {
        this.id = id;
        this.ingredientTemplates = ingredientTemplates;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player, NetworkEvent.Context context) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (!(abstractContainerMenu instanceof IStorageControllerContainer)) {
            return;
        }
        IStorageControllerContainer container = (IStorageControllerContainer)abstractContainerMenu;
        IStorageController storageController = container.getStorageController();
        if (storageController == null) {
            return;
        }
        StorageUtil.clearOpenCraftingMatrix(player, false);
        CraftingContainer craftMatrix = container.getCraftMatrix();
        NonNullList<Ingredient> ingredients = this.getDesiredIngredients((Player)player);
        for (int slot = 0; slot < 9; ++slot) {
            Ingredient ingredient = (Ingredient)ingredients.get(slot);
            if (ingredient.m_43947_()) continue;
            ItemStack extractedStack = StorageUtil.extractItem((IItemHandler)new PlayerMainInvWrapper(player.m_150109_()), (Predicate<ItemStack>)ingredient, 1, true);
            if (!extractedStack.m_41619_() && craftMatrix.m_8020_(slot).m_41619_()) {
                StorageUtil.extractItem((IItemHandler)new PlayerMainInvWrapper(player.m_150109_()), (Predicate<ItemStack>)ingredient, 1, false);
                craftMatrix.m_6836_(slot, extractedStack);
                continue;
            }
            ItemStack stack = storageController.getOneOfMostCommonItem((Predicate<ItemStack>)ingredient, false);
            if (stack.m_41619_() || !craftMatrix.m_8020_(slot).m_41619_()) continue;
            craftMatrix.m_6836_(slot, stack);
        }
        container.updateCraftingSlots(true);
        OccultismPackets.sendTo(player, storageController.getMessageUpdateStacks());
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.id);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.id = buf.m_130281_();
    }

    private NonNullList<Ingredient> getDesiredIngredients(Player player) {
        Recipe recipe;
        if (this.id != null && (recipe = (Recipe)player.m_9236_().m_7465_().m_44043_(this.id).orElse(null)) != null) {
            return EmiHelper.ensure3by3CraftingMatrix(recipe);
        }
        NonNullList ingredients = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
        Preconditions.checkArgument((ingredients.size() == this.ingredientTemplates.size() ? 1 : 0) != 0, (String)"Got %d ingredient templates from client, expected %d", (int)this.ingredientTemplates.size(), (int)ingredients.size());
        for (int i = 0; i < ingredients.size(); ++i) {
            ItemStack template = (ItemStack)this.ingredientTemplates.get(i);
            if (template.m_41619_()) continue;
            ingredients.set(i, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{template}));
        }
        return ingredients;
    }
}

