/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.emi.impl;

import com.google.common.collect.Lists;
import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.container.storage.StorageControllerContainerBase;
import com.klikli_dev.occultism.integration.emi.impl.EmiHelper;
import com.klikli_dev.occultism.network.MessageSetRecipeByTemplate;
import com.klikli_dev.occultism.network.OccultismPackets;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class StorageControllerEMIRecipeHandler<T extends StorageControllerContainerBase>
implements StandardRecipeHandler<T> {
    public static final int BLUE_SLOT_HIGHLIGHT_COLOR = 0x400000FF;
    public static final int RED_SLOT_HIGHLIGHT_COLOR = 0x66FF0000;
    public static final int BLUE_PLUS_BUTTON_COLOR = -2142943745;
    public static final int ORANGE_PLUS_BUTTON_COLOR = -2130729728;
    protected static final int CRAFTING_GRID_WIDTH = 3;
    protected static final int CRAFTING_GRID_HEIGHT = 3;
    private static final Comparator<ItemStack> ENTRY_COMPARATOR = Comparator.comparing(ItemStack::m_41613_);
    protected final Class<T> containerClass;

    public StorageControllerEMIRecipeHandler(Class<T> containerClass) {
        this.containerClass = containerClass;
    }

    public static Map<Integer, Ingredient> getGuiSlotToIngredientMap(Recipe<?> recipe) {
        int width;
        NonNullList ingredients = recipe.m_7527_();
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            width = shapedRecipe.m_44220_();
        } else {
            width = 3;
        }
        HashMap<Integer, Ingredient> result = new HashMap<Integer, Ingredient>(ingredients.size());
        for (int i = 0; i < ingredients.size(); ++i) {
            int guiSlot = i / width * 3 + i % width;
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (ingredient.m_43947_()) continue;
            result.put(guiSlot, ingredient);
        }
        return result;
    }

    public static void performTransfer(StorageControllerContainerBase menu, @Nullable ResourceLocation recipeId, Recipe<?> recipe) {
        NonNullList<ItemStack> templateItems = StorageControllerEMIRecipeHandler.findGoodTemplateItems(recipe, menu);
        if (recipeId != null && menu.player.m_9236_().m_7465_().m_44043_(recipeId).isEmpty()) {
            Occultism.LOGGER.debug("Cannot send recipe id %s to server because it's transient", (Object)recipeId);
            recipeId = null;
        }
        OccultismPackets.sendToServer(new MessageSetRecipeByTemplate(recipeId, templateItems));
    }

    private static NonNullList<ItemStack> findGoodTemplateItems(Recipe<?> recipe, StorageControllerContainerBase menu) {
        Map<ItemStack, Integer> ingredientPriorities = StorageControllerEMIRecipeHandler.getIngredientPriorities(menu, ENTRY_COMPARATOR);
        NonNullList templateItems = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        NonNullList<Ingredient> ingredients = EmiHelper.ensure3by3CraftingMatrix(recipe);
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (ingredient.m_43947_()) continue;
            ItemStack stack = ingredientPriorities.entrySet().stream().filter(e -> ingredient.test((ItemStack)e.getKey())).max(Comparator.comparingInt(Map.Entry::getValue)).map(e -> (ItemStack)e.getKey()).orElse(ingredient.m_43908_()[0]);
            templateItems.set(i, (Object)stack);
        }
        return templateItems;
    }

    public static Map<ItemStack, Integer> getIngredientPriorities(StorageControllerContainerBase menu, Comparator<ItemStack> comparator) {
        List<ItemStack> orderedEntries = menu.getClientStorageCache().stacks().stream().sorted(comparator).toList();
        HashMap<ItemStack, Integer> result = new HashMap<ItemStack, Integer>(orderedEntries.size());
        for (int i = 0; i < orderedEntries.size(); ++i) {
            result.put(orderedEntries.get(i), i);
        }
        for (ItemStack item : menu.playerInventory.f_35974_) {
            result.putIfAbsent(item, -1);
        }
        return result;
    }

    private static void renderMissingAndCraftableSlotOverlays(Map<Integer, SlotWidget> inputSlots, GuiGraphics guiGraphics, Set<Integer> missingSlots, Set<Integer> craftableSlots) {
        for (Map.Entry<Integer, SlotWidget> entry : inputSlots.entrySet()) {
            boolean missing = missingSlots.contains(entry.getKey());
            boolean craftable = craftableSlots.contains(entry.getKey());
            if (!missing && !craftable) continue;
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 400.0f);
            Bounds innerBounds = StorageControllerEMIRecipeHandler.getInnerBounds(entry.getValue());
            guiGraphics.m_280509_(innerBounds.x(), innerBounds.y(), innerBounds.right(), innerBounds.bottom(), missing ? 0x66FF0000 : 0x400000FF);
            poseStack.m_85849_();
        }
    }

    private static boolean isInputSlot(SlotWidget slot) {
        return slot.getRecipe() == null;
    }

    private static Bounds getInnerBounds(SlotWidget slot) {
        Bounds bounds = slot.getBounds();
        return new Bounds(bounds.x() + 1, bounds.y() + 1, bounds.width() - 2, bounds.height() - 2);
    }

    private static Map<Integer, SlotWidget> getRecipeInputSlots(EmiRecipe recipe, List<Widget> widgets) {
        HashMap<Integer, SlotWidget> inputSlots = new HashMap<Integer, SlotWidget>(recipe.getInputs().size());
        for (int i = 0; i < recipe.getInputs().size(); ++i) {
            for (Widget widget : widgets) {
                SlotWidget slot;
                if (!(widget instanceof SlotWidget) || !StorageControllerEMIRecipeHandler.isInputSlot(slot = (SlotWidget)widget) || slot.getStack() != recipe.getInputs().get(i)) continue;
                inputSlots.put(i, slot);
            }
        }
        return inputSlots;
    }

    public static List<Component> createCraftingTooltip(StorageControllerContainerBase.MissingIngredientSlots missingSlots, boolean withTitle) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (withTitle) {
            tooltip.add((Component)Component.m_237115_((String)"jei.occultism.error.recipe_move_items"));
        }
        if (missingSlots.anyMissing()) {
            tooltip.add((Component)Component.m_237115_((String)"jei.occultism.error.recipe_items_missing").m_130940_(ChatFormatting.RED));
        }
        return tooltip;
    }

    public List<Slot> getInputSources(T handler) {
        int invStart;
        ArrayList list = Lists.newArrayList();
        for (int i = 1; i < 10; ++i) {
            list.add(handler.m_38853_(i));
        }
        for (int i = invStart = 11; i < invStart + 36; ++i) {
            list.add(handler.m_38853_(i));
        }
        return list;
    }

    public List<Slot> getCraftingSlots(T handler) {
        ArrayList list = Lists.newArrayList();
        for (int i = 1; i < 10; ++i) {
            list.add(handler.m_38853_(i));
        }
        return list;
    }

    @Nullable
    public Slot getOutputSlot(T handler) {
        return (Slot)((StorageControllerContainerBase)handler).f_38839_.get(0);
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<T> context) {
        if (context.getType() == EmiCraftContext.Type.FILL_BUTTON) {
            return this.transferRecipe(recipe, context, false).canCraft();
        }
        return super.canCraft(recipe, context);
    }

    protected Result transferRecipe(T menu, Recipe<?> recipe, EmiRecipe emiRecipe, boolean doTransfer) {
        Map<Integer, Ingredient> slotToIngredientMap;
        StorageControllerContainerBase.MissingIngredientSlots missingSlots;
        ResourceLocation recipeId = recipe != null ? recipe.m_6423_() : null;
        boolean craftingRecipe = this.isCraftingRecipe(recipe, emiRecipe);
        if (!craftingRecipe) {
            return Result.createNotApplicable();
        }
        if (!this.fitsIn3x3Grid(recipe, emiRecipe)) {
            return Result.createFailed((Component)Component.m_237115_((String)"jei.occultism.error.recipe_too_large"));
        }
        if (recipe == null) {
            recipe = this.createFakeRecipe(emiRecipe);
        }
        if ((missingSlots = ((StorageControllerContainerBase)menu).findMissingIngredients(slotToIngredientMap = StorageControllerEMIRecipeHandler.getGuiSlotToIngredientMap(recipe))).missingSlots().size() == slotToIngredientMap.size()) {
            return Result.createFailed((Component)Component.m_237115_((String)"jei.occultism.error.recipe_no_items"), missingSlots.missingSlots());
        }
        if (!doTransfer) {
            if (missingSlots.anyMissingOrCraftable()) {
                return new Result.PartiallyCraftable(missingSlots);
            }
        } else {
            StorageControllerEMIRecipeHandler.performTransfer(menu, recipeId, recipe);
        }
        return Result.createSuccessful();
    }

    private Recipe<?> createFakeRecipe(EmiRecipe display) {
        NonNullList ingredients = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
        for (int i = 0; i < Math.min(display.getInputs().size(), ingredients.size()); ++i) {
            Ingredient ingredient = Ingredient.m_43921_(((EmiIngredient)display.getInputs().get(i)).getEmiStacks().stream().map(EmiStack::getItemStack).filter(is -> !is.m_41619_()));
            ingredients.set(i, (Object)ingredient);
        }
        return new ShapedRecipe(display.getId(), "", CraftingBookCategory.MISC, 3, 3, ingredients, ItemStack.f_41583_);
    }

    protected final Result transferRecipe(EmiRecipe emiRecipe, EmiCraftContext<T> context, boolean doTransfer) {
        Recipe<?> recipe;
        if (!this.containerClass.isInstance(context.getScreenHandler())) {
            return Result.createNotApplicable();
        }
        StorageControllerContainerBase menu = (StorageControllerContainerBase)this.containerClass.cast(context.getScreenHandler());
        Result result = this.transferRecipe(menu, recipe = this.getRecipeHolder(((StorageControllerContainerBase)context.getScreenHandler()).player.m_9236_(), emiRecipe), emiRecipe, doTransfer);
        if (result instanceof Result.Success && doTransfer) {
            Minecraft.m_91087_().m_91152_((Screen)context.getScreen());
        }
        return result;
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return true;
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
        return this.transferRecipe(recipe, context, true).canCraft();
    }

    public List<ClientTooltipComponent> getTooltip(EmiRecipe recipe, EmiCraftContext<T> context) {
        List<Component> tooltip = this.transferRecipe(recipe, context, false).getTooltip(recipe, context);
        if (tooltip != null) {
            return tooltip.stream().map(Component::m_7532_).map(ClientTooltipComponent::m_169948_).toList();
        }
        return super.getTooltip(recipe, context);
    }

    public void render(EmiRecipe recipe, EmiCraftContext<T> context, List<Widget> widgets, GuiGraphics draw) {
        this.transferRecipe(recipe, context, false).render(recipe, context, widgets, draw);
    }

    @Nullable
    private Recipe<?> getRecipeHolder(Level level, EmiRecipe recipe) {
        if (recipe.getBackingRecipe() != null) {
            return recipe.getBackingRecipe();
        }
        if (recipe.getId() != null) {
            return level.m_7465_().m_44043_(recipe.getId()).orElse(null);
        }
        return null;
    }

    protected final boolean isCraftingRecipe(Recipe<?> recipe, EmiRecipe emiRecipe) {
        return recipe != null && recipe.m_6671_() == RecipeType.f_44107_ || emiRecipe.getCategory().equals(VanillaEmiRecipeCategories.CRAFTING);
    }

    protected final boolean fitsIn3x3Grid(Recipe<?> recipe, EmiRecipe emiRecipe) {
        if (recipe != null) {
            return recipe.m_8004_(3, 3);
        }
        return true;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    protected static abstract class Result {
        protected Result() {
        }

        static NotApplicable createNotApplicable() {
            return new NotApplicable();
        }

        static Success createSuccessful() {
            return new Success();
        }

        static Error createFailed(Component text) {
            return new Error(text, Set.of());
        }

        static Error createFailed(Component text, Set<Integer> missingSlots) {
            return new Error(text, missingSlots);
        }

        @Nullable
        List<Component> getTooltip(EmiRecipe recipe, EmiCraftContext<?> context) {
            return null;
        }

        abstract boolean canCraft();

        void render(EmiRecipe recipe, EmiCraftContext<? extends StorageControllerContainerBase> context, List<Widget> widgets, GuiGraphics draw) {
        }

        static final class NotApplicable
        extends Result {
            NotApplicable() {
            }

            @Override
            boolean canCraft() {
                return false;
            }
        }

        static final class Success
        extends Result {
            Success() {
            }

            @Override
            boolean canCraft() {
                return true;
            }
        }

        static final class Error
        extends Result {
            private final Component message;
            private final Set<Integer> missingSlots;

            public Error(Component message, Set<Integer> missingSlots) {
                this.message = message;
                this.missingSlots = missingSlots;
            }

            public Component getMessage() {
                return this.message;
            }

            @Override
            boolean canCraft() {
                return false;
            }

            @Override
            void render(EmiRecipe recipe, EmiCraftContext<? extends StorageControllerContainerBase> context, List<Widget> widgets, GuiGraphics guiGraphics) {
                StorageControllerEMIRecipeHandler.renderMissingAndCraftableSlotOverlays(StorageControllerEMIRecipeHandler.getRecipeInputSlots(recipe, widgets), guiGraphics, this.missingSlots, Set.of());
            }
        }

        static final class PartiallyCraftable
        extends Result {
            private final StorageControllerContainerBase.MissingIngredientSlots missingSlots;

            public PartiallyCraftable(StorageControllerContainerBase.MissingIngredientSlots missingSlots) {
                this.missingSlots = missingSlots;
            }

            @Override
            boolean canCraft() {
                return true;
            }

            @Override
            List<Component> getTooltip(EmiRecipe recipe, EmiCraftContext<?> context) {
                return StorageControllerEMIRecipeHandler.createCraftingTooltip(this.missingSlots, false);
            }

            @Override
            void render(EmiRecipe recipe, EmiCraftContext<? extends StorageControllerContainerBase> context, List<Widget> widgets, GuiGraphics guiGraphics) {
                StorageControllerEMIRecipeHandler.renderMissingAndCraftableSlotOverlays(StorageControllerEMIRecipeHandler.getRecipeInputSlots(recipe, widgets), guiGraphics, this.missingSlots.missingSlots(), this.missingSlots.craftableSlots());
            }
        }
    }
}

