/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.occultism.crafting.recipe.CrushingRecipe;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;

public class CrushingRecipeBuilder
implements RecipeBuilder {
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;
    private final RecipeSerializer<CrushingRecipe> serializer = (RecipeSerializer)OccultismRecipes.CRUSHING.get();
    private final Ingredient ingredient;
    private final Ingredient output;
    private int outputAmount;
    private final int crushingTime;
    private boolean ignoreCrushingMultiplier;
    private int minTier;
    private boolean allowEmpty;

    public CrushingRecipeBuilder(Ingredient ingredient, Ingredient output, int crushingTime) {
        this.ingredient = ingredient;
        this.allowEmpty = false;
        this.crushingTime = crushingTime;
        this.outputAmount = 1;
        this.output = output;
        this.minTier = -1;
    }

    public static CrushingRecipeBuilder crushingRecipe(Ingredient ingredient, Ingredient output, int crushingTime) {
        return new CrushingRecipeBuilder(ingredient, output, crushingTime);
    }

    public static CrushingRecipeBuilder crushingRecipe(TagKey<Item> ingredient, TagKey<Item> output, int crushingTime) {
        return new CrushingRecipeBuilder(Ingredient.m_204132_(ingredient), Ingredient.m_204132_(output), crushingTime);
    }

    public CrushingRecipeBuilder unlockedBy(String s, CriterionTriggerInstance criterionTriggerInstance) {
        this.advancement.m_138386_(s, criterionTriggerInstance);
        return this;
    }

    public CrushingRecipeBuilder group(@Nullable String s) {
        this.group = s;
        return this;
    }

    public Item m_142372_() {
        if (this.output.m_43908_().length == 1) {
            return this.output.m_43908_()[0].m_41720_();
        }
        return null;
    }

    public CrushingRecipeBuilder allowEmpty() {
        this.allowEmpty = true;
        return this;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public CrushingRecipeBuilder setOutputAmount(int outputAmount) {
        this.outputAmount = outputAmount;
        return this;
    }

    public CrushingRecipeBuilder setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
        return this;
    }

    public int getCrushingTime() {
        return this.crushingTime;
    }

    public int getMinTier() {
        return this.minTier;
    }

    public CrushingRecipeBuilder setMinTier(int minTier) {
        this.minTier = minTier;
        return this;
    }

    public boolean getIgnoreCrushingMultiplier() {
        return this.ignoreCrushingMultiplier;
    }

    public CrushingRecipeBuilder setIgnoreCrushingMultiplier(boolean ignoreCrushingMultiplier) {
        this.ignoreCrushingMultiplier = ignoreCrushingMultiplier;
        return this;
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation resourceLocation) {
        this.ensureValid(resourceLocation);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)resourceLocation)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)resourceLocation)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(resourceLocation, this.group == null ? "" : this.group, this.serializer, this.advancement, new ResourceLocation(resourceLocation.m_135827_(), "recipes/crushing/" + resourceLocation.m_135815_()), this.ingredient, this.output, this.crushingTime, this.ignoreCrushingMultiplier, this.minTier, this.allowEmpty, this.outputAmount));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
        }
    }

    public class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final RecipeSerializer<CrushingRecipe> serializer;
        private final Advancement.Builder advancement;
        private final Ingredient ingredient;
        private final Ingredient output;
        private final int crushingTime;
        private final boolean ignoreCrushingMultiplier;
        private final int minTier;
        private final boolean allowEmpty;
        private final ResourceLocation advancementId;
        @Nullable
        private final int outputAmount;

        public Result(ResourceLocation id, String group, RecipeSerializer<CrushingRecipe> serializer, Advancement.Builder advancement, ResourceLocation advancementId, Ingredient ingredient, Ingredient output, int crushingTime, boolean ignoreCrushingMultiplier, int minTier, boolean allowEmpty, int outputAmount) {
            this.id = id;
            this.group = group;
            this.serializer = serializer;
            this.advancement = advancement;
            this.ingredient = ingredient;
            this.output = output;
            this.crushingTime = crushingTime;
            this.ignoreCrushingMultiplier = ignoreCrushingMultiplier;
            this.minTier = minTier;
            this.allowEmpty = allowEmpty;
            this.advancementId = advancementId;
            this.outputAmount = outputAmount;
        }

        public void m_7917_(JsonObject jsonObject) {
            if (!this.group.isEmpty()) {
                jsonObject.addProperty("group", this.group);
            }
            jsonObject.add("ingredient", this.ingredient.m_43942_());
            JsonObject output = new JsonObject();
            if (this.output.f_43902_.length == 1 && this.output.f_43902_[0] instanceof Ingredient.TagValue) {
                output.addProperty("tag", ((Ingredient.TagValue)this.output.f_43902_[0]).f_43959_.f_203868_().toString());
                output.addProperty("count", (Number)this.outputAmount);
                jsonObject.add("result", (JsonElement)output);
            } else {
                jsonObject.add("result", (JsonElement)((Ingredient.ItemValue)this.output.f_43902_[0]).m_6544_());
            }
            if (!this.allowEmpty) {
                JsonArray conditions = new JsonArray();
                if (this.output.f_43902_.length == 1 && this.output.f_43902_[0] instanceof Ingredient.TagValue) {
                    conditions.add((JsonElement)this.makeTagNotEmptyCondition(((Ingredient.TagValue)this.output.f_43902_[0]).f_43959_.f_203868_().toString()));
                }
                if (this.ingredient.f_43902_.length == 1 && this.ingredient.f_43902_[0] instanceof Ingredient.TagValue) {
                    conditions.add((JsonElement)this.makeTagNotEmptyCondition(((Ingredient.TagValue)this.ingredient.f_43902_[0]).f_43959_.f_203868_().toString()));
                }
                jsonObject.add("conditions", (JsonElement)conditions);
            }
            jsonObject.addProperty("crushing_time", (Number)this.crushingTime);
            jsonObject.addProperty("ignore_crushing_multiplier", Boolean.valueOf(this.ignoreCrushingMultiplier));
            if (this.minTier != -1) {
                jsonObject.addProperty("min_tier", (Number)this.minTier);
            }
        }

        public JsonObject makeTagNotEmptyCondition(String tag) {
            JsonObject condition = new JsonObject();
            condition.addProperty("type", "forge:not");
            JsonObject value = new JsonObject();
            value.addProperty("type", "forge:tag_empty");
            value.addProperty("tag", tag);
            condition.add("value", (JsonElement)value);
            return condition;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

