/*
 * Decompiled with CFR 0.152.
 */
package portb.biggerstacks.util;

import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import portb.biggerstacks.config.StackSizeRules;

public class SlotLimitHelper {
    public static void scaleSlotLimit(CallbackInfoReturnable<Integer> callbackInfoReturnable) {
        callbackInfoReturnable.cancel();
        callbackInfoReturnable.setReturnValue((Object)SlotLimitHelper.scaleSlotLimit((Integer)callbackInfoReturnable.getReturnValue()));
    }

    public static int scaleSlotLimit(int original) {
        int newStackSize = StackSizeRules.getMaxStackSize();
        if (original == 1) {
            return 1;
        }
        if (newStackSize < 64) {
            return 64;
        }
        return Math.max(original, original * newStackSize / 64);
    }

    public static void scaleTransferRate(CallbackInfoReturnable<Integer> callbackInfoReturnable, boolean respectSingle) {
        callbackInfoReturnable.cancel();
        callbackInfoReturnable.setReturnValue((Object)SlotLimitHelper.scaleTransferRate((Integer)callbackInfoReturnable.getReturnValue(), respectSingle));
    }

    public static int scaleTransferRate(int originalRate, boolean respectSingle) {
        if (originalRate == 1 && respectSingle) {
            return 1;
        }
        return Math.max(1, originalRate * StackSizeRules.getMaxStackSize() / 64);
    }

    public static int increaseTransferRate(int originalRate) {
        if (originalRate == 1) {
            return 1;
        }
        return Math.max(1, StackSizeRules.getMaxStackSize());
    }

    public static int getNewStackSize() {
        return Math.max(StackSizeRules.getMaxStackSize(), 64);
    }
}

