/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.mixin;

import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.ArrayList;
import net.liopyu.entityjs.builders.modification.ModifyLivingEntityBuilder;
import net.liopyu.entityjs.entities.nonliving.entityjs.PartEntityJS;
import net.liopyu.entityjs.events.EntityModificationEventJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.EventHandlers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={PathfinderMob.class})
public abstract class EntityPartMixin
extends LivingEntity {
    @Unique
    private Object entityJs$builder;
    @Unique
    private Object entityJs$entityObject = this;
    @Unique
    public PartEntityJS<?>[] partEntities;

    @Unique
    private Entity entityJs$getLivingEntity() {
        return (Entity)this.entityJs$entityObject;
    }

    @Unique
    private String entityJs$entityName() {
        return this.entityJs$getLivingEntity().m_6095_().toString();
    }

    protected EntityPartMixin(EntityType<? extends LivingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        EntityType entityType = this.entityJs$getLivingEntity().m_6095_();
        if (EventHandlers.modifyEntity.hasListeners()) {
            EntityModificationEventJS eventJS = EntityModificationEventJS.getOrCreate(entityType, this.entityJs$getLivingEntity());
            EventHandlers.modifyEntity.post((EventJS)eventJS);
            this.entityJs$builder = eventJS.getBuilder();
        }
        ArrayList tempPartEntities = new ArrayList();
        for (ContextUtils.PartEntityParams<?> params : ((ModifyLivingEntityBuilder)((Object)this.entityJs$builder)).partEntityParamsList) {
            PartEntityJS partEntity = new PartEntityJS(this.entityJs$getLivingEntity(), params.name, params.width, params.height, params.builder);
            tempPartEntities.add(partEntity);
        }
        ConsoleJS.STARTUP.log(new Object[]{this.partEntities.length});
        this.partEntities = tempPartEntities.toArray(new PartEntityJS[0]);
    }

    public void m_20234_(int entityId) {
        super.m_20234_(entityId);
        for (int i = 0; i < this.partEntities.length; ++i) {
            PartEntityJS<?> partEntity = this.partEntities[i];
            if (partEntity == null) continue;
            partEntity.m_20234_(entityId + i + 1);
        }
    }

    public void tickPart(String partName, double offsetX, double offsetY, double offsetZ) {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        for (PartEntityJS<?> partEntity : this.partEntities) {
            if (!partEntity.name.equals(partName)) continue;
            partEntity.movePart(x + offsetX, y + offsetY, z + offsetZ, partEntity.m_146908_(), partEntity.m_146909_());
            return;
        }
        EntityJSHelperClass.logWarningMessageOnce("Part with name " + partName + " not found for entity: " + this.entityJs$entityName());
    }

    public boolean isMultipartEntity() {
        return this.partEntities != null;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.partEntities;
    }
}

