/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.client.living.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.liopyu.entityjs.builders.living.BaseLivingEntityBuilder;
import net.liopyu.entityjs.client.living.KubeJSEntityRenderer;
import net.liopyu.entityjs.client.living.model.GeoLayerJSBuilder;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;

public class GlowingGeoLayerJS<T extends LivingEntity>
extends AutoGlowingGeoLayer<T> {
    public T entity;
    public final GeoLayerJSBuilder<T> geoBuilder;
    public final KubeJSEntityRenderer<T> renderer;
    public final BaseLivingEntityBuilder<T> builder;

    public GlowingGeoLayerJS(KubeJSEntityRenderer<T> entityRendererIn, GeoLayerJSBuilder<T> geoBuilder, BaseLivingEntityBuilder<T> builder) {
        super(entityRendererIn);
        this.geoBuilder = geoBuilder;
        this.renderer = entityRendererIn;
        this.builder = builder;
    }

    public String entityName() {
        return ((EntityType)this.builder.get()).toString();
    }

    protected ResourceLocation getTextureResource(T animatable) {
        if (this.geoBuilder.textureResource != null) {
            Object obj = this.geoBuilder.textureResource.apply(animatable);
            if (obj instanceof ResourceLocation) {
                ResourceLocation r = (ResourceLocation)obj;
                return r;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for textureResource in newGeoLayer builder. Value: " + obj + ". Must be a ResourceLocation. Defaulting to " + super.getTextureResource(animatable));
        }
        return super.getTextureResource(animatable);
    }

    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        if (this.geoBuilder.preRender != null && animatable != null) {
            try {
                if (this.geoBuilder.renderTypeFunction != null) {
                    renderType = this.geoBuilder.renderTypeFunction.apply(animatable);
                }
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in " + this.entityName() + "builder for field: renderType.", e);
            }
            if (this.geoBuilder.setRenderType != null) {
                renderType = this.geoBuilder.setRenderType;
            }
            if (this.geoBuilder.setRenderType == null && this.geoBuilder.renderTypeFunction == null) {
                renderType = RenderType.m_110458_((ResourceLocation)this.getTextureResource(animatable));
            }
            ContextUtils.PreRenderContext<T> context = new ContextUtils.PreRenderContext<T>(poseStack, animatable, bakedModel, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
            EntityJSHelperClass.consumerCallback(this.geoBuilder.preRender, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: preRender");
            super.preRender(poseStack, animatable, bakedModel, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        } else {
            super.preRender(poseStack, animatable, bakedModel, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
    }

    protected RenderType getRenderType(T animatable) {
        if (animatable != null) {
            try {
                if (this.geoBuilder.renderTypeFunction != null) {
                    return this.geoBuilder.renderTypeFunction.apply(animatable);
                }
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in " + this.entityName() + "builder for field: renderType.", e);
                return super.getRenderType(animatable);
            }
            if (this.geoBuilder.setRenderType != null) {
                return this.geoBuilder.setRenderType;
            }
        }
        return super.getRenderType(animatable);
    }

    public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTicks, int packedLightIn, int packedOverlay) {
        try {
            if (this.geoBuilder.renderTypeFunction != null) {
                renderType = this.geoBuilder.renderTypeFunction.apply(animatable);
            }
        }
        catch (Exception e) {
            EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in " + this.entityName() + "builder for field: renderType.", e);
        }
        if (this.geoBuilder.setRenderType != null) {
            renderType = this.geoBuilder.setRenderType;
        }
        if (this.geoBuilder.setRenderType == null && this.geoBuilder.renderTypeFunction == null) {
            renderType = RenderType.m_110458_((ResourceLocation)this.getTextureResource(animatable));
        }
        if (this.geoBuilder.render != null && animatable != null) {
            ContextUtils.PreRenderContext<T> context = new ContextUtils.PreRenderContext<T>(poseStack, animatable, bakedModel, renderType, bufferSource, buffer, partialTicks, packedLightIn, packedOverlay);
            EntityJSHelperClass.consumerCallback(this.geoBuilder.render, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: render");
            this.getRenderer().reRender(this.getDefaultBakedModel((GeoAnimatable)animatable), poseStack, bufferSource, animatable, renderType, bufferSource.m_6299_(renderType), partialTicks, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.getRenderer().reRender(this.getDefaultBakedModel((GeoAnimatable)animatable), poseStack, bufferSource, animatable, renderType, bufferSource.m_6299_(renderType), partialTicks, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

