/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import lykrast.meetyourfight.MeetYourFight;
import lykrast.meetyourfight.entity.RoseSpiritEntity;
import lykrast.meetyourfight.renderer.RoseSpiritGlowLayer;
import lykrast.meetyourfight.renderer.RoseSpiritModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RoseSpiritRenderer
extends MobRenderer<RoseSpiritEntity, RoseSpiritModel> {
    private static final ResourceLocation TEXTURE = MeetYourFight.rl("textures/entity/rose_spirit.png");
    private static final ResourceLocation BEAM_TEXTURE = new ResourceLocation("textures/entity/end_crystal/end_crystal_beam.png");
    private static final RenderType BEAM = RenderType.m_110476_((ResourceLocation)BEAM_TEXTURE);

    public RoseSpiritRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new RoseSpiritModel(context.m_174023_(RoseSpiritModel.MODEL)), 0.5f);
        this.m_115326_(new RoseSpiritGlowLayer((RenderLayerParent<RoseSpiritEntity, RoseSpiritModel>)this));
    }

    public void render(RoseSpiritEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        Mob owner = entityIn.getOwner();
        if (owner != null) {
            float f3 = (float)owner.m_20185_();
            float f4 = (float)owner.m_20186_();
            float f5 = (float)owner.m_20189_();
            float f6 = (float)((double)f3 - entityIn.m_20185_());
            float f7 = (float)((double)f4 - entityIn.m_20186_());
            float f8 = (float)((double)f5 - entityIn.m_20189_());
            RoseSpiritRenderer.renderCrystalBeams(f6, f7, f8, partialTicks, entityIn.f_19797_, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    public static void renderCrystalBeams(float x, float y, float z, float partialTicks, int ticks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float dist2D = Mth.m_14116_((float)(x * x + z * z));
        float dist = Mth.m_14116_((float)(x * x + y * y + z * z));
        matrixStackIn.m_85836_();
        matrixStackIn.m_252880_(0.0f, 1.0f, 0.0f);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252961_((float)(-Math.atan2(z, x) - 1.5707963267948966)));
        matrixStackIn.m_252781_(Axis.f_252529_.m_252961_((float)(-Math.atan2(dist2D, y) - 1.5707963267948966)));
        VertexConsumer vertexconsumer = bufferIn.m_6299_(BEAM);
        float f2 = 0.0f - ((float)ticks + partialTicks) * 0.01f;
        float f3 = Mth.m_14116_((float)(x * x + y * y + z * z)) / 32.0f - ((float)ticks + partialTicks) * 0.01f;
        float f4 = 0.0f;
        float f5 = 0.75f;
        float f6 = 0.0f;
        PoseStack.Pose posestack$pose = matrixStackIn.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        float endScale = 0.3f;
        float startScale = 0.2f;
        for (int j = 1; j <= 8; ++j) {
            float f7 = Mth.m_14031_((float)((float)((double)j * (Math.PI * 2) / 8.0))) * 0.75f;
            float f8 = Mth.m_14089_((float)((float)((double)j * (Math.PI * 2) / 8.0))) * 0.75f;
            float f9 = (float)j / 8.0f;
            vertexconsumer.m_252986_(matrix4f, f4 * startScale, f5 * startScale, 0.0f).m_6122_(205, 112, 255, 255).m_7421_(f6, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f4 * endScale, f5 * endScale, dist).m_6122_(0, 0, 0, 255).m_7421_(f6, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f7 * endScale, f8 * endScale, dist).m_6122_(0, 0, 0, 255).m_7421_(f9, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f7 * startScale, f8 * startScale, 0.0f).m_6122_(205, 112, 255, 255).m_7421_(f9, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        matrixStackIn.m_85849_();
    }

    public ResourceLocation getTextureLocation(RoseSpiritEntity entity) {
        return TEXTURE;
    }

    public boolean shouldRender(RoseSpiritEntity entity, Frustum frustrum, double p_114171_, double p_114172_, double p_114173_) {
        return super.m_5523_((Mob)entity, frustrum, p_114171_, p_114172_, p_114173_) || entity.getOwner() != null;
    }
}

