/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import lykrast.meetyourfight.MeetYourFight;
import lykrast.meetyourfight.entity.FortunaCardEntity;
import lykrast.meetyourfight.renderer.FortunaCardModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class FortunaCardRenderer
extends EntityRenderer<FortunaCardEntity> {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{MeetYourFight.rl("textures/entity/fortuna_card_club.png"), MeetYourFight.rl("textures/entity/fortuna_card_heart.png"), MeetYourFight.rl("textures/entity/fortuna_card_diamond.png"), MeetYourFight.rl("textures/entity/fortuna_card_spade.png"), MeetYourFight.rl("textures/entity/fortuna_card_amogus.png")};
    private static final RenderType[] TEXTURES_OVERLAY = new RenderType[]{RenderType.m_234335_((ResourceLocation)MeetYourFight.rl("textures/entity/fortuna_card_ask_club.png"), (boolean)false), RenderType.m_234335_((ResourceLocation)MeetYourFight.rl("textures/entity/fortuna_card_ask_heart.png"), (boolean)false), RenderType.m_234335_((ResourceLocation)MeetYourFight.rl("textures/entity/fortuna_card_ask_diamond.png"), (boolean)false), RenderType.m_234335_((ResourceLocation)MeetYourFight.rl("textures/entity/fortuna_card_ask_spade.png"), (boolean)false), RenderType.m_234335_((ResourceLocation)MeetYourFight.rl("textures/entity/fortuna_card_ask_amogus.png"), (boolean)false)};
    private static final ResourceLocation TEXTURE_HIDDEN = MeetYourFight.rl("textures/entity/fortuna_card_hidden.png");
    private final FortunaCardModel model;
    private static final int HIDE_HALF = 5;
    private static final int REVEAL_HALF = 10;

    public FortunaCardRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new FortunaCardModel(context.m_174023_(FortunaCardModel.MODEL));
    }

    protected int getBlockLightLevel(FortunaCardEntity entityIn, BlockPos partialTicks) {
        return 15;
    }

    public void render(FortunaCardEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        int anim = entityIn.clientAnim;
        if (anim == 0) {
            return;
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        float yaw = Mth.m_14189_((float)partialTicks, (float)entityIn.f_19859_, (float)entityIn.m_146908_());
        if (anim == 3) {
            progress = ((float)(10 - entityIn.animTimer) + partialTicks) / 10.0f;
            yaw = Mth.m_14177_((float)(yaw + progress * 360.0f));
        } else if (anim == 6) {
            progress = ((float)(20 - entityIn.animTimer) + partialTicks) / 20.0f;
            yaw = Mth.m_14177_((float)(yaw + progress * 360.0f));
        } else if (anim == 7) {
            progress = ((float)(30 - entityIn.animTimer) + partialTicks) / 30.0f;
            yaw = Mth.m_14177_((float)(yaw + Mth.m_14031_((float)(progress * 3.0f * (float)Math.PI)) * 30.0f));
        }
        float pitch = Mth.m_14179_((float)partialTicks, (float)entityIn.f_19860_, (float)entityIn.m_146909_());
        matrixStackIn.m_85837_(0.0, -1.5, 0.0);
        this.model.setupAnim(entityIn, 0.0f, 0.0f, 0.0f, yaw, pitch);
        if (anim == 1) {
            float scale = ((float)(10 - entityIn.animTimer) + partialTicks) / 10.0f;
            if (scale > 1.0f) {
                scale = 1.0f;
            }
            scale *= scale;
            scale *= scale;
            matrixStackIn.m_85841_(scale, 1.0f, scale);
        }
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(this.model.m_103119_(this.getTextureLocation(entityIn)));
        this.model.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (entityIn.clientAnim == 5) {
            ivertexbuilder = bufferIn.m_6299_(TEXTURES_OVERLAY[Mth.m_14045_((int)entityIn.getVariantQuestion(), (int)0, (int)(TEXTURES_OVERLAY.length - 1))]);
            this.model.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrixStackIn.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(FortunaCardEntity entity) {
        int anim = entity.clientAnim;
        if (anim == 4 || anim == 5 || anim == 3 && entity.animTimer <= 5 || anim == 6 && entity.animTimer >= 10) {
            return TEXTURE_HIDDEN;
        }
        return TEXTURES[Mth.m_14045_((int)entity.getVariant(), (int)0, (int)(TEXTURES.length - 1))];
    }
}

