/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import lykrast.meetyourfight.MeetYourFight;
import lykrast.meetyourfight.config.MYFConfigValues;
import lykrast.meetyourfight.entity.BossFlyingEntity;
import lykrast.meetyourfight.entity.SwampMineEntity;
import lykrast.meetyourfight.entity.ai.PhantomAttackPlayer;
import lykrast.meetyourfight.registry.MYFEntities;
import lykrast.meetyourfight.registry.MYFSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class SwampjawEntity
extends BossFlyingEntity {
    private static final EntityDataAccessor<Byte> ANIMATION = SynchedEntityData.m_135353_(SwampjawEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final int ANIM_NEUTRAL = 0;
    public static final int ANIM_SWOOP = 1;
    public static final int ANIM_STUN = 2;
    public static final int ANIM_SWIPE = 3;
    public static final int HP = 100;
    public static final int DMG_CHARGE = 12;
    private int behavior;
    private int attackDelay;
    private static final int CIRCLE = 0;
    private static final int BOMB = 1;
    private static final int SWOOP = 2;
    private static final int STUNNED = 3;
    private static final int SWIPING = 4;
    private Vec3 orbitOffset = Vec3.f_82478_;
    private BlockPos orbitPosition = BlockPos.f_121853_;
    public float tailYaw;
    public float tailPitch;
    public int clientAnim;
    public int prevAnim;
    public int animProg;
    public int animDur;

    public SwampjawEntity(EntityType<? extends SwampjawEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 30;
        this.f_21342_ = new MoveHelperController(this);
        this.tailYaw = this.m_146908_();
        this.tailPitch = this.m_146909_();
        this.clientAnim = 0;
        this.prevAnim = 0;
        this.animProg = 1;
        this.animDur = 1;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22278_, 0.8);
    }

    public static void spawn(Player player, Level world) {
        RandomSource rand = player.m_217043_();
        SwampjawEntity fish = (SwampjawEntity)((EntityType)MYFEntities.SWAMPJAW.get()).m_20615_(world);
        fish.m_7678_(player.m_20185_() + (double)rand.m_188503_(5) - 2.0, player.m_20186_() + (double)rand.m_188503_(10) + 5.0, player.m_20189_() + (double)rand.m_188503_(5) - 2.0, rand.m_188501_() * 360.0f - 180.0f, 0.0f);
        if (!player.m_150110_().f_35937_) {
            fish.m_6710_((LivingEntity)player);
        }
        fish.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 2));
        fish.m_6518_((ServerLevelAccessor)((ServerLevel)world), world.m_6436_(fish.m_20183_()), MobSpawnType.EVENT, null, null);
        world.m_7967_((Entity)fish);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PickAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SweepAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BombMovementGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new OrbitPointGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new LookWhenNotStunned(this, Player.class, 16.0f));
        this.f_21346_.m_25352_(1, (Goal)new PhantomAttackPlayer((Mob)this));
    }

    public void m_8119_() {
        this.f_19794_ = true;
        super.m_8119_();
        this.f_19794_ = false;
        if (this.m_9236_().m_5776_()) {
            int newanim = this.getAnimation();
            if (this.clientAnim != newanim) {
                this.prevAnim = this.clientAnim;
                this.clientAnim = newanim;
                this.animProg = 0;
                this.animDur = 10;
                if (this.clientAnim == 0 && this.prevAnim == 1) {
                    this.animDur = 5;
                }
            } else if (this.animProg < this.animDur) {
                ++this.animProg;
            }
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.orbitPosition = this.m_20183_().m_6630_(5);
        this.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("Config Health", MYFConfigValues.SWAMPJAW_HEALTH_MOD, AttributeModifier.Operation.ADDITION));
        this.m_21153_(this.m_21233_());
        this.m_21051_(Attributes.f_22281_).m_22125_(new AttributeModifier("Config Damage", MYFConfigValues.SWAMPJAW_DMG_MOD, AttributeModifier.Operation.ADDITION));
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_6549_(EntityType<?> typeIn) {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION, (Object)0);
    }

    public int getAnimation() {
        return ((Byte)this.f_19804_.m_135370_(ANIMATION)).byteValue();
    }

    public void setAnimation(int anim) {
        this.f_19804_.m_135381_(ANIMATION, (Object)((byte)anim));
    }

    public float getAnimProgress(float partial) {
        return Mth.m_14036_((float)(((float)this.animProg + partial) / (float)this.animDur), (float)0.0f, (float)1.0f);
    }

    public float getTailYaw(float partialTick) {
        return Mth.m_14148_((float)this.tailYaw, (float)this.m_146908_(), (float)(6.0f * partialTick));
    }

    public float getTailPitch(float partialTick) {
        return Mth.m_14148_((float)this.tailPitch, (float)this.m_146909_(), (float)(2.0f * partialTick));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            this.tailYaw = Mth.m_14148_((float)this.tailYaw, (float)this.m_146908_(), (float)6.0f);
            this.tailPitch = Mth.m_14148_((float)this.tailPitch, (float)this.m_146909_(), (float)2.0f);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("AX")) {
            this.orbitPosition = new BlockPos(compound.m_128451_("AX"), compound.m_128451_("AY"), compound.m_128451_("AZ"));
        }
        if (compound.m_128441_("Delay")) {
            this.attackDelay = compound.m_128451_("Delay");
        }
        if (compound.m_128441_("Behavior")) {
            this.behavior = compound.m_128451_("Behavior");
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("AX", this.orbitPosition.m_123341_());
        compound.m_128405_("AY", this.orbitPosition.m_123342_());
        compound.m_128405_("AZ", this.orbitPosition.m_123343_());
        compound.m_128405_("Delay", this.attackDelay);
        compound.m_128405_("Behavior", this.behavior);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MYFSounds.swampjawIdle.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)MYFSounds.swampjawHurt.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MYFSounds.swampjawDeath.get();
    }

    @Override
    protected SoundEvent getMusic() {
        return (SoundEvent)MYFSounds.musicSwampjaw.get();
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected ResourceLocation m_7582_() {
        return MeetYourFight.rl("entities/swampjaw");
    }

    private void swipeAttack() {
        this.m_5496_(SoundEvents.f_12317_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
        for (LivingEntity target : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(1.75, 1.0, 1.75))) {
            if (!target.m_6084_() || target.m_20147_() || target == this || !this.m_7327_((Entity)target)) continue;
            double mult = Math.max(0.0, 1.0 - target.m_21133_(Attributes.f_22278_));
            Vec3 knockback = new Vec3(target.m_20185_() - this.m_20185_(), 0.0, target.m_20189_() - this.m_20189_()).m_82541_().m_82520_(0.0, 0.2, 0.0).m_82490_(2.0 * mult);
            target.m_20256_(target.m_20184_().m_82549_(knockback));
        }
    }

    private static class MoveHelperController
    extends MoveControl {
        private float speedFactor = 0.1f;
        private SwampjawEntity swampjaw;

        public MoveHelperController(SwampjawEntity entityIn) {
            super((Mob)entityIn);
            this.swampjaw = entityIn;
        }

        public void m_8126_() {
            if (this.swampjaw.behavior == 3 || this.swampjaw.behavior == 4) {
                this.swampjaw.m_20256_(this.swampjaw.m_20184_().m_82490_(0.9));
                return;
            }
            float targetX = (float)(this.swampjaw.orbitOffset.f_82479_ - this.swampjaw.m_20185_());
            float targetY = (float)(this.swampjaw.orbitOffset.f_82480_ - this.swampjaw.m_20186_());
            float targetZ = (float)(this.swampjaw.orbitOffset.f_82481_ - this.swampjaw.m_20189_());
            double horizontalDist = Mth.m_14116_((float)(targetX * targetX + targetZ * targetZ));
            double verticalAdjust = 1.0 - (double)Mth.m_14154_((float)(targetY * 0.7f)) / horizontalDist;
            targetX = (float)((double)targetX * verticalAdjust);
            targetZ = (float)((double)targetZ * verticalAdjust);
            horizontalDist = Mth.m_14116_((float)(targetX * targetX + targetZ * targetZ));
            double totalDist = Mth.m_14116_((float)(targetX * targetX + targetZ * targetZ + targetY * targetY));
            float prevYaw = this.swampjaw.m_146908_();
            float targetYaw = (float)Mth.m_14136_((double)targetZ, (double)targetX);
            float startYaw = Mth.m_14177_((float)(this.swampjaw.m_146908_() + 90.0f));
            targetYaw = Mth.m_14177_((float)(targetYaw * 57.295776f));
            boolean isFastBomb = this.swampjaw.behavior == 1 && this.swampjaw.attackDelay <= 10;
            this.swampjaw.m_146922_(Mth.m_14148_((float)startYaw, (float)targetYaw, (float)(isFastBomb ? 20.0f : 10.0f)) - 90.0f);
            this.swampjaw.f_20883_ = this.swampjaw.m_146908_();
            if (isFastBomb || Mth.m_14145_((float)prevYaw, (float)this.swampjaw.m_146908_()) < 3.0f) {
                float maxSpeed = this.swampjaw.behavior != 0 ? 3.0f : 1.2f;
                float multiplier = this.speedFactor > maxSpeed ? 10.0f : maxSpeed / this.speedFactor;
                this.speedFactor = Mth.m_14121_((float)this.speedFactor, (float)maxSpeed, (float)(0.005f * multiplier));
            } else {
                this.speedFactor = Mth.m_14121_((float)this.speedFactor, (float)(this.swampjaw.behavior == 1 ? 0.7f : 0.4f), (float)0.05f);
            }
            float finalPitch = (float)(-(Mth.m_14136_((double)(-targetY), (double)horizontalDist) * 57.2957763671875));
            this.swampjaw.m_146926_(finalPitch);
            float adjustedYaw = this.swampjaw.m_146908_() + 90.0f;
            double finalX = (double)(this.speedFactor * Mth.m_14089_((float)(adjustedYaw * ((float)Math.PI / 180)))) * Math.abs((double)targetX / totalDist);
            double finalZ = (double)(this.speedFactor * Mth.m_14031_((float)(adjustedYaw * ((float)Math.PI / 180)))) * Math.abs((double)targetZ / totalDist);
            double finalY = (double)(this.speedFactor * Mth.m_14031_((float)(finalPitch * ((float)Math.PI / 180)))) * Math.abs((double)targetY / totalDist);
            Vec3 vector3d = this.swampjaw.m_20184_();
            this.swampjaw.m_20256_(vector3d.m_82549_(new Vec3(finalX, finalY, finalZ).m_82546_(vector3d).m_82490_(0.2)));
        }
    }

    private static class PickAttackGoal
    extends Goal {
        private int bombLeft;
        private SwampjawEntity swampjaw;

        public PickAttackGoal(SwampjawEntity swampjaw) {
            this.swampjaw = swampjaw;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.swampjaw.m_5448_();
            return this.swampjaw.behavior == 3 || this.swampjaw.behavior == 4 || livingentity != null && this.swampjaw.m_21040_(this.swampjaw.m_5448_(), PhantomAttackPlayer.DEFAULT_BUT_THROUGH_WALLS);
        }

        public void m_8056_() {
            this.swampjaw.attackDelay = 100;
            this.bombLeft = 3;
            this.swampjaw.behavior = 0;
            this.updateOrbit();
        }

        public void m_8041_() {
        }

        public void m_8037_() {
            if (this.swampjaw.behavior == 0 || this.swampjaw.behavior == 1 || this.swampjaw.behavior == 3 || this.swampjaw.behavior == 4) {
                --this.swampjaw.attackDelay;
                if (this.swampjaw.attackDelay <= 0) {
                    if (this.swampjaw.behavior == 3) {
                        this.swampjaw.behavior = 4;
                        this.swampjaw.setAnimation(3);
                        this.swampjaw.attackDelay = 10;
                    } else if (this.swampjaw.behavior == 4) {
                        this.swampjaw.behavior = 0;
                        this.swampjaw.setAnimation(0);
                        this.swampjaw.attackDelay = (2 + this.swampjaw.f_19796_.m_188503_(3)) * 20;
                    } else if (this.bombLeft <= 0) {
                        this.bombLeft = 3;
                        this.swampjaw.behavior = 2;
                        this.swampjaw.setAnimation(1);
                        this.updateOrbit();
                        this.swampjaw.attackDelay = (4 + this.swampjaw.f_19796_.m_188503_(4)) * 20;
                        this.swampjaw.m_5496_((SoundEvent)MYFSounds.swampjawCharge.get(), 10.0f, 0.95f + this.swampjaw.f_19796_.m_188501_() * 0.1f);
                    } else if (this.swampjaw.behavior == 0) {
                        this.swampjaw.behavior = 1;
                        this.swampjaw.attackDelay = 20;
                    } else if (this.swampjaw.attackDelay <= -120 || this.isTargetClose()) {
                        --this.bombLeft;
                        this.swampjaw.attackDelay = this.bombLeft <= 0 ? 30 + this.swampjaw.f_19796_.m_188503_(30) : 30;
                        this.updateOrbit();
                        this.swampjaw.m_5496_((SoundEvent)MYFSounds.swampjawBomb.get(), 10.0f, 0.95f + this.swampjaw.f_19796_.m_188501_() * 0.1f);
                        SwampMineEntity tntentity = new SwampMineEntity(this.swampjaw.m_9236_(), this.swampjaw.m_20185_() + 0.5, this.swampjaw.m_20186_(), this.swampjaw.m_20189_() + 0.5, (LivingEntity)this.swampjaw);
                        Vec3 motion = this.swampjaw.m_20184_();
                        tntentity.m_20256_(tntentity.m_20184_().m_82520_(motion.f_82479_ * 0.5, 0.0, motion.f_82481_ * 0.5));
                        this.swampjaw.m_9236_().m_7967_((Entity)tntentity);
                    }
                } else if (this.swampjaw.behavior == 3 && this.swampjaw.attackDelay == 10) {
                    this.swampjaw.setAnimation(0);
                } else if (this.swampjaw.behavior == 4 && this.swampjaw.attackDelay == 5) {
                    this.swampjaw.swipeAttack();
                }
            }
        }

        private boolean isTargetClose() {
            double dz;
            LivingEntity target = this.swampjaw.m_5448_();
            if (target == null) {
                return false;
            }
            double dx = target.m_20185_() - (this.swampjaw.m_20185_() + this.swampjaw.m_20184_().f_82479_);
            return dx * dx + (dz = target.m_20189_() - (this.swampjaw.m_20189_() + this.swampjaw.m_20184_().f_82481_)) * dz < 12.0;
        }

        private void updateOrbit() {
            this.swampjaw.orbitPosition = this.swampjaw.m_5448_().m_20183_().m_6630_(14 + this.swampjaw.f_19796_.m_188503_(6));
        }
    }

    private static class SweepAttackGoal
    extends BaseMoveGoal {
        public SweepAttackGoal(SwampjawEntity swampjaw) {
            super(swampjaw);
        }

        public boolean m_8036_() {
            return this.swampjaw.m_5448_() != null && this.swampjaw.behavior == 2;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.swampjaw.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (!(livingentity instanceof Player) || !((Player)livingentity).m_5833_() && !((Player)livingentity).m_7500_()) {
                return this.m_8036_();
            }
            return false;
        }

        public void m_8041_() {
            if (this.swampjaw.behavior == 2) {
                this.swampjaw.behavior = 0;
                this.swampjaw.setAnimation(0);
            }
        }

        public void m_8037_() {
            LivingEntity livingentity = this.swampjaw.m_5448_();
            this.swampjaw.orbitOffset = new Vec3(livingentity.m_20185_(), livingentity.m_20227_(0.5), livingentity.m_20189_());
            if (this.swampjaw.f_20916_ > 0) {
                this.swampjaw.m_5496_((SoundEvent)MYFSounds.swampjawStun.get(), 10.0f, 0.95f + this.swampjaw.f_19796_.m_188501_() * 0.1f);
                this.swampjaw.attackDelay = 50;
                this.swampjaw.behavior = 3;
                this.swampjaw.setAnimation(2);
            } else if (this.swampjaw.m_20191_().m_82381_(livingentity.m_20191_()) && this.swampjaw.m_20275_(livingentity.m_20185_(), this.swampjaw.m_20186_(), livingentity.m_20189_()) <= 4.0) {
                this.swampjaw.m_7327_((Entity)livingentity);
                this.swampjaw.behavior = 0;
                this.swampjaw.setAnimation(0);
            }
        }
    }

    private static class BombMovementGoal
    extends BaseMoveGoal {
        public BombMovementGoal(SwampjawEntity swampjaw) {
            super(swampjaw);
        }

        public boolean m_8036_() {
            return this.swampjaw.m_5448_() != null && this.swampjaw.behavior == 1;
        }

        public void m_8056_() {
            this.updateOffset();
        }

        public void m_8037_() {
            if (this.isCloseToOffset()) {
                this.updateOffset();
            } else if (this.swampjaw.attackDelay <= 10) {
                Vec3 swamp = this.swampjaw.m_20182_();
                Vec3 destination = this.swampjaw.orbitOffset;
                Vec3 target = this.swampjaw.m_5448_().m_20182_();
                double distance = (destination.f_82481_ - swamp.f_82481_) * target.f_82479_ - (destination.f_82479_ - swamp.f_82479_) * target.f_82481_ + destination.f_82479_ * swamp.f_82481_ - destination.f_82481_ * swamp.f_82479_;
                if ((distance = distance * distance / ((destination.f_82481_ - swamp.f_82481_) * (destination.f_82481_ - swamp.f_82481_) + (destination.f_82479_ - swamp.f_82479_) * (destination.f_82479_ - swamp.f_82479_))) > 10.0) {
                    this.updateOffset();
                }
            }
        }

        private void updateOffset() {
            LivingEntity target;
            if (BlockPos.f_121853_.equals((Object)this.swampjaw.orbitPosition)) {
                this.swampjaw.orbitPosition = this.swampjaw.m_20183_();
            }
            if ((target = this.swampjaw.m_5448_()) != null) {
                double difX = target.m_20185_() - this.swampjaw.orbitOffset.f_82479_;
                double difZ = target.m_20189_() - this.swampjaw.orbitOffset.f_82481_;
                Vec3 overshoot = new Vec3(difX, 0.0, difZ).m_82541_();
                Vec3 vec = target.m_20182_();
                this.swampjaw.orbitOffset = new Vec3(vec.f_82479_ + overshoot.f_82479_ * 10.0, (double)(this.swampjaw.orbitPosition.m_123342_() - 4), vec.f_82481_ + overshoot.f_82481_ * 10.0);
            }
        }
    }

    private static class OrbitPointGoal
    extends BaseMoveGoal {
        private float angle;
        private float radius;
        private float height;
        private float direction;

        public OrbitPointGoal(SwampjawEntity swampjaw) {
            super(swampjaw);
        }

        public boolean m_8036_() {
            return this.swampjaw.m_5448_() == null || this.swampjaw.behavior == 0;
        }

        public void m_8056_() {
            this.radius = 6.0f + this.swampjaw.f_19796_.m_188501_() * 6.0f;
            this.height = -4.0f + this.swampjaw.f_19796_.m_188501_() * 6.0f;
            this.direction = this.swampjaw.f_19796_.m_188499_() ? 1.0f : -1.0f;
            this.updateOffset();
        }

        public void m_8037_() {
            if (this.swampjaw.f_19796_.m_188503_(350) == 0) {
                this.height = -4.0f + this.swampjaw.f_19796_.m_188501_() * 6.0f;
            }
            if (this.swampjaw.f_19796_.m_188503_(250) == 0) {
                this.radius -= 1.0f;
                if (this.radius < 6.0f) {
                    this.radius = 12.0f;
                    this.direction = -this.direction;
                }
            }
            if (this.swampjaw.f_19796_.m_188503_(450) == 0) {
                this.angle = this.swampjaw.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
                this.updateOffset();
            }
            if (this.isCloseToOffset()) {
                this.updateOffset();
            }
            if (this.swampjaw.orbitOffset.f_82480_ < this.swampjaw.m_20186_() && !this.swampjaw.m_9236_().m_46859_(this.swampjaw.m_20183_().m_6625_(1))) {
                this.height = Math.max(1.0f, this.height);
                this.updateOffset();
            }
            if (this.swampjaw.orbitOffset.f_82480_ > this.swampjaw.m_20186_() && !this.swampjaw.m_9236_().m_46859_(this.swampjaw.m_20183_().m_6630_(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.updateOffset();
            }
        }

        private void updateOffset() {
            if (BlockPos.f_121853_.equals((Object)this.swampjaw.orbitPosition)) {
                this.swampjaw.orbitPosition = this.swampjaw.m_20183_();
            }
            this.angle += this.direction * 20.0f * ((float)Math.PI / 180);
            this.swampjaw.orbitOffset = Vec3.m_82528_((Vec3i)this.swampjaw.orbitPosition).m_82520_((double)(this.radius * Mth.m_14089_((float)this.angle)), (double)(-4.0f + this.height), (double)(this.radius * Mth.m_14031_((float)this.angle)));
        }
    }

    private static class LookWhenNotStunned
    extends LookAtPlayerGoal {
        private SwampjawEntity swampjaw;

        public LookWhenNotStunned(SwampjawEntity swampjaw, Class<? extends LivingEntity> target, float range) {
            super((Mob)swampjaw, target, range);
            this.swampjaw = swampjaw;
        }

        public boolean m_8036_() {
            return this.swampjaw.behavior != 3 && this.swampjaw.behavior != 4 && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.swampjaw.behavior != 3 && this.swampjaw.behavior != 4 && super.m_8045_();
        }
    }

    private static abstract class BaseMoveGoal
    extends Goal {
        protected SwampjawEntity swampjaw;

        public BaseMoveGoal(SwampjawEntity swampjaw) {
            this.swampjaw = swampjaw;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean isCloseToOffset() {
            return this.swampjaw.orbitOffset.m_82531_(this.swampjaw.m_20185_(), this.swampjaw.m_20186_(), this.swampjaw.m_20189_()) < 4.0;
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

