/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.entity;

import java.util.List;
import lykrast.meetyourfight.entity.DameFortunaEntity;
import lykrast.meetyourfight.registry.MYFEntities;
import lykrast.meetyourfight.registry.MYFSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class FortunaCardEntity
extends Entity {
    private static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.m_135353_(FortunaCardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> VARIANT_QUESTION = SynchedEntityData.m_135353_(FortunaCardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> ANIMATION = SynchedEntityData.m_135353_(FortunaCardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private int phase;
    private int timer = 20;
    private int hideTime;
    private boolean correct;
    private static final int PHASE_START = 0;
    private static final int PHASE_SPIN = 1;
    private static final int PHASE_GOTODEST = 2;
    private static final int PHASE_ACTIVE = 3;
    private static final int PHASE_REVEAL = 4;
    public static final int START_TIME = 110;
    public static final int GOTODEST_TIME = 35;
    public static final int SPIN_TIME = 80;
    public static final int REVEAL_TIME = 60;
    private double spinX;
    private double spinY;
    private double spinZ;
    private double destX;
    private double destY;
    private double destZ;
    private int spinOffset;
    private static final Vec3 SPINVEC = new Vec3(3.0, 0.0, 0.0);
    public int clientAnim;
    public int animTimer;
    public static final int ANIM_NOTHERE = 0;
    public static final int ANIM_APPEAR = 1;
    public static final int ANIM_IDLE_SHOW = 2;
    public static final int ANIM_HIDE = 3;
    public static final int ANIM_IDLE_HIDDEN = 4;
    public static final int ANIM_IDLE_QUESTION = 5;
    public static final int ANIM_REVEAL = 6;
    public static final int ANIM_HINT = 7;
    public static final int ANIM_APPEAR_DUR = 10;
    public static final int ANIM_HIDE_DUR = 10;
    public static final int ANIM_REVEAL_DUR = 20;
    public static final int ANIM_HINT_DUR = 30;

    public FortunaCardEntity(EntityType<? extends FortunaCardEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public FortunaCardEntity(Level worldIn, double x, double y, double z) {
        this((EntityType<? extends FortunaCardEntity>)((EntityType)MYFEntities.FORTUNA_CARD.get()), worldIn);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public void setup(int variant, int correctVariant, boolean correct, int preflipTime, double spinX, double spinY, double spinZ, int spinOffset, double destX, double destY, double destZ) {
        this.setVariant(variant);
        this.setVariantQuestion(correctVariant);
        this.correct = correct;
        this.phase = 0;
        this.timer = 110;
        this.hideTime = preflipTime;
        this.spinX = spinX;
        this.spinY = spinY;
        this.spinZ = spinZ;
        this.spinOffset = spinOffset;
        this.destX = destX;
        this.destY = destY;
        this.destZ = destZ;
        this.setAnimation(0);
        this.f_19794_ = true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(VARIANT_QUESTION, (Object)0);
        this.f_19804_.m_135372_(ANIMATION, (Object)0);
    }

    public void setVariant(int value) {
        this.f_19804_.m_135381_(VARIANT, (Object)((byte)value));
    }

    public int getVariant() {
        return ((Byte)this.f_19804_.m_135370_(VARIANT)).byteValue();
    }

    public void setVariantQuestion(int value) {
        this.f_19804_.m_135381_(VARIANT_QUESTION, (Object)((byte)value));
    }

    public int getVariantQuestion() {
        return ((Byte)this.f_19804_.m_135370_(VARIANT_QUESTION)).byteValue();
    }

    public void setAnimation(int value) {
        this.f_19804_.m_135381_(ANIMATION, (Object)((byte)value));
    }

    public int getAnimation() {
        return ((Byte)this.f_19804_.m_135370_(ANIMATION)).byteValue();
    }

    public boolean isCorrect() {
        return this.m_6084_() && this.correct;
    }

    public void m_8119_() {
        block28: {
            block31: {
                block29: {
                    block34: {
                        block33: {
                            block32: {
                                block30: {
                                    if (this.m_9236_().f_46443_) break block28;
                                    --this.timer;
                                    if (this.timer <= 0) {
                                        switch (this.phase) {
                                            case 0: {
                                                this.phase = 1;
                                                this.timer = 80;
                                                break;
                                            }
                                            case 1: {
                                                this.setAnimation(4);
                                                this.phase = 2;
                                                this.timer = 35;
                                                break;
                                            }
                                            case 2: {
                                                this.phase = 3;
                                                this.setAnimation(5);
                                                this.timer = 200;
                                                break;
                                            }
                                            case 3: 
                                            case 4: {
                                                this.m_142687_(Entity.RemovalReason.KILLED);
                                            }
                                        }
                                    }
                                    if (this.phase != 0) break block29;
                                    if (this.timer != 110 - this.hideTime) break block30;
                                    this.setAnimation(1);
                                    this.m_5496_((SoundEvent)MYFSounds.dameFortunaCardStart.get(), 1.0f, 1.0f);
                                    break block31;
                                }
                                if (this.timer != 110 - this.hideTime - 10 && (this.timer != 30 || !this.isCorrect())) break block32;
                                this.setAnimation(2);
                                break block31;
                            }
                            if (this.timer != 60 || !this.isCorrect()) break block33;
                            this.setAnimation(7);
                            break block31;
                        }
                        if (this.timer != 20) break block34;
                        this.setAnimation(3);
                        break block31;
                    }
                    if (this.timer != 10) break block31;
                    this.setAnimation(4);
                    break block31;
                }
                if (this.phase == 4) {
                    if (this.timer == 55) {
                        this.setAnimation(6);
                    }
                    if (this.timer == 35) {
                        this.setAnimation(2);
                        this.m_5496_(this.correct ? (SoundEvent)MYFSounds.dameFortunaCardRight.get() : (SoundEvent)MYFSounds.dameFortunaCardWrong.get(), 1.0f, 1.0f);
                        if (this.correct) {
                            List dames = this.m_9236_().m_6443_(DameFortunaEntity.class, this.m_20191_().m_82400_(32.0), dame -> dame.m_6084_());
                            for (DameFortunaEntity d : dames) {
                                d.progressShuffle();
                            }
                        }
                    }
                }
            }
            if (this.phase == 1) {
                int spintimer = 80 - this.timer;
                float angle = 0.0f;
                if (spintimer > 50) {
                    angle = 80 - spintimer;
                } else if (spintimer > 20) {
                    angle = spintimer - 20;
                }
                angle = 0.5f * angle * angle;
                if (spintimer > 50) {
                    angle = 900.0f - angle;
                }
                Vec3 offset = SPINVEC.m_82524_((angle + (float)this.spinOffset) % 360.0f * ((float)Math.PI / 180));
                double tx = this.spinX + offset.f_82479_;
                double tz = this.spinZ + offset.f_82481_;
                if (spintimer <= 20) {
                    double maxSpeed;
                    Vec3 speed = new Vec3(tx - this.m_20185_(), this.spinY - this.m_20186_(), tz - this.m_20189_());
                    double len = speed.m_82556_();
                    if (len > (maxSpeed = (double)(80 - this.timer) * 0.05) * maxSpeed) {
                        speed = speed.m_82541_().m_82490_(maxSpeed);
                    }
                    this.m_20256_(speed);
                } else {
                    this.m_20334_(tx - this.m_20185_(), this.spinY - this.m_20186_(), tz - this.m_20189_());
                }
            } else if (this.phase == 2) {
                int timeOffset = this.spinOffset / 36 + 1;
                Vec3 speed = new Vec3(this.destX - this.m_20185_(), this.destY - this.m_20186_(), this.destZ - this.m_20189_());
                if (this.timer <= timeOffset) {
                    this.m_20256_(speed);
                } else if (this.timer <= timeOffset + 10) {
                    this.m_20256_(speed.m_82490_(1.0 / (double)(this.timer - timeOffset)));
                } else {
                    this.m_20256_(Vec3.f_82478_);
                }
            } else {
                this.m_20256_(Vec3.f_82478_);
            }
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.m_9236_().f_46443_) {
            this.updateClientAnimation();
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.phase == 3 && source.m_7639_() != null && source.m_7639_() instanceof LivingEntity) {
            this.phase = 4;
            this.timer = 60;
            List others = this.m_9236_().m_6443_(FortunaCardEntity.class, this.m_20191_().m_82400_(32.0), card -> card.phase != 4);
            for (FortunaCardEntity other : others) {
                other.m_142687_(Entity.RemovalReason.KILLED);
            }
            this.m_146922_(this.lookToward(source.m_7639_().m_20185_(), source.m_7639_().m_20189_()));
            return true;
        }
        return false;
    }

    public boolean m_6087_() {
        return true;
    }

    public float m_6143_() {
        return 1.0f;
    }

    protected float lookToward(double wantedX, double wantedZ) {
        double d0 = wantedX - this.m_20185_();
        double d1 = wantedZ - this.m_20189_();
        return (float)(Mth.m_14136_((double)d1, (double)d0) * 57.29577951308232 - 90.0);
    }

    private void updateClientAnimation() {
        if (this.clientAnim != this.getAnimation()) {
            this.clientAnim = this.getAnimation();
            switch (this.clientAnim) {
                case 1: {
                    this.animTimer = 10;
                    break;
                }
                case 3: {
                    this.animTimer = 10;
                    break;
                }
                case 6: {
                    this.animTimer = 20;
                    break;
                }
                case 7: {
                    this.animTimer = 30;
                }
            }
        } else if (this.animTimer > 0) {
            --this.animTimer;
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128344_("Variant", (byte)this.getVariant());
        compound.m_128344_("VariantAsk", (byte)this.getVariantQuestion());
        compound.m_128405_("Phase", this.phase);
        compound.m_128405_("Timer", this.timer);
        compound.m_128405_("HTime", this.hideTime);
        compound.m_128379_("Correct", this.correct);
        compound.m_128347_("spinX", this.spinX);
        compound.m_128347_("spinY", this.spinY);
        compound.m_128347_("spinZ", this.spinZ);
        compound.m_128405_("spinOff", this.spinOffset);
        compound.m_128347_("destX", this.destX);
        compound.m_128347_("destY", this.destY);
        compound.m_128347_("destZ", this.destZ);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setVariant(compound.m_128445_("Variant"));
        this.setVariantQuestion(compound.m_128445_("VariantAsk"));
        this.phase = compound.m_128451_("Phase");
        this.timer = compound.m_128451_("Timer");
        this.hideTime = compound.m_128451_("HTime");
        this.correct = compound.m_128471_("Correct");
        this.spinX = compound.m_128459_("spinX");
        this.spinY = compound.m_128459_("spinY");
        this.spinZ = compound.m_128459_("spinZ");
        this.spinOffset = compound.m_128451_("spinOff");
        this.destX = compound.m_128459_("destX");
        this.destY = compound.m_128459_("destY");
        this.destZ = compound.m_128459_("destZ");
    }

    protected float m_6380_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

