/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcneg.compositematerial.common.tier;

import io.github.rcneg.compositematerial.common.init.ItemRegistry;
import java.util.EnumMap;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public enum ArmorTier implements ArmorMaterial
{
    AMETHYST("amethyst", 15, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), armor -> {
        armor.put(ArmorItem.Type.BOOTS, 2);
        armor.put(ArmorItem.Type.LEGGINGS, 5);
        armor.put(ArmorItem.Type.CHESTPLATE, 6);
        armor.put(ArmorItem.Type.HELMET, 2);
    }), 25, SoundEvents.f_11677_, 0.0f, 0.0f, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_150998_})),
    COPPER("copper", 15, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), armor -> {
        armor.put(ArmorItem.Type.BOOTS, 1);
        armor.put(ArmorItem.Type.LEGGINGS, 4);
        armor.put(ArmorItem.Type.CHESTPLATE, 5);
        armor.put(ArmorItem.Type.HELMET, 2);
    }), 15, SoundEvents.f_11677_, 0.0f, 0.1f, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151052_})),
    OBSIDIAN_STEEL("obsidian", 35, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), armor -> {
        armor.put(ArmorItem.Type.BOOTS, 3);
        armor.put(ArmorItem.Type.LEGGINGS, 6);
        armor.put(ArmorItem.Type.CHESTPLATE, 8);
        armor.put(ArmorItem.Type.HELMET, 3);
    }), 25, SoundEvents.f_11677_, 2.0f, 0.0f, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.OBSIDIAN_STEEL_INGOT.get()})),
    ALLAY_STEEL("allay_steel", 25, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), armor -> {
        armor.put(ArmorItem.Type.BOOTS, 3);
        armor.put(ArmorItem.Type.LEGGINGS, 6);
        armor.put(ArmorItem.Type.CHESTPLATE, 8);
        armor.put(ArmorItem.Type.HELMET, 3);
    }), 25, SoundEvents.f_11677_, 1.0f, 0.0f, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.ALLAY_STEEL_INGOT.get()})),
    ECHOIUM("echoium", 60, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), armor -> {
        armor.put(ArmorItem.Type.BOOTS, 4);
        armor.put(ArmorItem.Type.LEGGINGS, 9);
        armor.put(ArmorItem.Type.CHESTPLATE, 12);
        armor.put(ArmorItem.Type.HELMET, 5);
    }), 30, SoundEvents.f_11673_, 4.0f, 0.3f, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.ECHOIUM_INGOT.get()})),
    ETHERITE("etherite", 500, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), armor -> {
        armor.put(ArmorItem.Type.BOOTS, 6);
        armor.put(ArmorItem.Type.LEGGINGS, 12);
        armor.put(ArmorItem.Type.CHESTPLATE, 15);
        armor.put(ArmorItem.Type.HELMET, 7);
    }), 40, SoundEvents.f_11679_, 6.0f, 0.5f, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.ETHERITE_INGOT.get()})),
    PRIMITIVE("primitive", 500, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), armor -> {
        armor.put(ArmorItem.Type.BOOTS, 1);
        armor.put(ArmorItem.Type.LEGGINGS, 2);
        armor.put(ArmorItem.Type.CHESTPLATE, 3);
        armor.put(ArmorItem.Type.HELMET, 2);
    }), 5, SoundEvents.f_11679_, 6.0f, 0.5f, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.PRIMITIVE_TENACITY.get()}));

    private final String name;
    private final int durabilityMultiplier;
    private final EnumMap<ArmorItem.Type, Integer> protectionFunctionForType;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final Ingredient repairIngredient;
    private static final EnumMap<ArmorItem.Type, Integer> DURABILITY_FOR_TYPE;

    private ArmorTier(String name, int durability, EnumMap<ArmorItem.Type, Integer> protection, int enchantmentValue, SoundEvent sound, float toughness, float knockbackResistance, Ingredient repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durability;
        this.protectionFunctionForType = protection;
        this.enchantmentValue = enchantmentValue;
        this.sound = sound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = repairIngredient;
    }

    public int m_266425_(ArmorItem.Type type) {
        return DURABILITY_FOR_TYPE.get(type) * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.protectionFunctionForType.get(type);
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.sound;
    }

    public Ingredient m_6230_() {
        return this.repairIngredient;
    }

    public String m_6082_() {
        return "composite_material:" + this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        DURABILITY_FOR_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), durabilityValue -> {
            durabilityValue.put(ArmorItem.Type.BOOTS, 13);
            durabilityValue.put(ArmorItem.Type.LEGGINGS, 15);
            durabilityValue.put(ArmorItem.Type.CHESTPLATE, 16);
            durabilityValue.put(ArmorItem.Type.HELMET, 11);
        });
    }
}

