/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcneg.compositematerial.common.items.dungeontools;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class DungeonPickaxeDiscard
extends PickaxeItem {
    private static final String TAG_SPAWNER = "spawner";
    private static final String TAG_SPAWN_DATA = "SpawnData";
    private static final String TAG_ID = "id";

    public DungeonPickaxeDiscard(Tier p_42961_, int p_42962_, float p_42963_, Item.Properties p_42964_) {
        super(p_42961_, p_42962_, p_42963_, p_42964_);
    }

    @Nullable
    private static ResourceLocation getEntityId(ItemStack stack) {
        CompoundTag tag = stack.m_41737_(TAG_SPAWNER);
        if (tag != null && tag.m_128441_(TAG_SPAWN_DATA)) {
            tag = tag.m_128469_(TAG_SPAWN_DATA);
            DataResult spawnData = SpawnData.f_186559_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag);
            return spawnData.result().filter(sd -> sd.m_186567_().m_128441_(TAG_ID)).map(sd -> ResourceLocation.m_135820_((String)sd.m_186567_().m_128461_(TAG_ID))).orElse(null);
        }
        return null;
    }

    public static boolean hasData(ItemStack stack) {
        return DungeonPickaxeDiscard.getEntityId(stack) != null;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        if (DungeonPickaxeDiscard.getEntityId(ctx.m_43722_()) == null) {
            return this.captureSpawner(ctx) ? InteractionResult.m_19078_((boolean)ctx.m_43725_().m_5776_()) : InteractionResult.PASS;
        }
        return this.placeSpawner(ctx);
    }

    private InteractionResult placeSpawner(UseOnContext ctx) {
        ItemStack useStack = new ItemStack((ItemLike)Blocks.f_50085_);
        Pair<InteractionResult, BlockPos> res = DungeonPickaxeDiscard.substituteUseTrackPos(ctx, useStack);
        Level world = ctx.m_43725_();
        BlockPos pos = (BlockPos)res.getRight();
        ItemStack mover = ctx.m_43722_();
        if (!world.f_46443_) {
            if (ctx.m_43723_() != null) {
                ctx.m_43723_().m_21190_(ctx.m_43724_());
            }
            mover.m_41774_(1);
            BlockEntity te = world.m_7702_(pos);
            if (te instanceof SpawnerBlockEntity) {
                CompoundTag spawnerTag = ctx.m_43722_().m_41737_(TAG_SPAWNER).m_6426_();
                spawnerTag.m_128405_("x", pos.m_123341_());
                spawnerTag.m_128405_("y", pos.m_123342_());
                spawnerTag.m_128405_("z", pos.m_123343_());
                te.m_142466_(spawnerTag);
            }
        }
        return (InteractionResult)res.getLeft();
    }

    private boolean captureSpawner(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        ItemStack stack = ctx.m_43722_();
        Player player = ctx.m_43723_();
        if (world.m_8055_(pos).m_60713_(Blocks.f_50085_)) {
            if (!world.f_46443_) {
                BlockEntity te = world.m_7702_(pos);
                stack.m_41784_().m_128365_(TAG_SPAWNER, (Tag)te.m_187480_());
                world.m_46961_(pos, false);
                if (player != null) {
                    player.m_36335_().m_41524_((Item)this, 20);
                    player.m_21190_(ctx.m_43724_());
                }
            }
            return true;
        }
        return false;
    }

    public static Pair<InteractionResult, BlockPos> substituteUseTrackPos(UseOnContext ctx, ItemStack toUse) {
        ItemUseContextWithNullPlayer newCtx;
        ItemStack save = ItemStack.f_41583_;
        BlockHitResult hit = new BlockHitResult(ctx.m_43720_(), ctx.m_43719_(), ctx.m_8083_(), ctx.m_43721_());
        if (ctx.m_43723_() != null) {
            save = ctx.m_43723_().m_21120_(ctx.m_43724_());
            ctx.m_43723_().m_21008_(ctx.m_43724_(), toUse);
            newCtx = new UseOnContext(ctx.m_43723_(), ctx.m_43724_(), hit);
        } else {
            newCtx = new ItemUseContextWithNullPlayer(ctx.m_43725_(), ctx.m_43724_(), toUse, hit);
        }
        BlockPos finalPos = new BlockPlaceContext((UseOnContext)newCtx).m_8083_();
        InteractionResult result = toUse.m_41661_((UseOnContext)newCtx);
        if (ctx.m_43723_() != null) {
            ctx.m_43723_().m_21008_(ctx.m_43724_(), save);
        }
        return Pair.of((Object)result, (Object)finalPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        ResourceLocation id = DungeonPickaxeDiscard.getEntityId(stack);
        String string = "tooltip.composite_material." + stack.m_41720_();
        tooltip.add((Component)Component.m_237115_((String)string).m_130940_(ChatFormatting.DARK_AQUA));
        if (id != null) {
            BuiltInRegistries.f_256780_.m_6612_(id).ifPresent(type -> tooltip.add(type.m_20676_()));
        }
    }

    private static class ItemUseContextWithNullPlayer
    extends UseOnContext {
        public ItemUseContextWithNullPlayer(Level world, InteractionHand hand, ItemStack stack, BlockHitResult rayTraceResult) {
            super(world, null, hand, stack, rayTraceResult);
        }
    }
}

