/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcneg.compositematerial.common.items.armors;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.rcneg.compositematerial.common.init.ItemRegistry;
import io.github.rcneg.compositematerial.common.items.armors.CMArmorItems;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;

public class PrimitiveArmors
extends CMArmorItems {
    public PrimitiveArmors(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(this.m_7167_(slot));
        if (slot == EquipmentSlot.HEAD && stack.m_150930_((Item)ItemRegistry.PRIMITIVE_HELMET.get())) {
            builder.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(UUID.fromString("12345678-8975-1244-7120-719895176262"), "primitive_armor_add_health", 14.0, AttributeModifier.Operation.ADDITION));
        } else if (slot == EquipmentSlot.CHEST && stack.m_150930_((Item)ItemRegistry.PRIMITIVE_CHESTPLATE.get())) {
            builder.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(UUID.fromString("12345678-4143-6188-5454-445682774164"), "primitive_armor_add_health", 18.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(UUID.fromString("12345678-2358-1274-2343-939481542424"), "primitive_armor_add_reach_1", 1.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)((Attribute)ForgeMod.BLOCK_REACH.get()), (Object)new AttributeModifier(UUID.fromString("12345678-2358-1274-2343-948154242493"), "primitive_armor_add_reach_2", 1.0, AttributeModifier.Operation.ADDITION));
        } else if (slot == EquipmentSlot.LEGS && stack.m_150930_((Item)ItemRegistry.PRIMITIVE_LEGGINGS.get())) {
            builder.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(UUID.fromString("12345678-8717-1264-0999-362966170523"), "primitive_armor_add_health", 16.0, AttributeModifier.Operation.ADDITION));
        } else if (slot == EquipmentSlot.FEET && stack.m_150930_((Item)ItemRegistry.PRIMITIVE_BOOTS.get())) {
            builder.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(UUID.fromString("12345678-2358-1274-2343-481542424939"), "primitive_armor_add_health", 12.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)((Attribute)ForgeMod.SWIM_SPEED.get()), (Object)new AttributeModifier(UUID.fromString("12345678-2358-1274-2343-424939481542"), "primitive_armor_add_swim", 0.2, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        return builder.build();
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return stack.m_150930_((Item)ItemRegistry.PRIMITIVE_BOOTS.get());
    }

    public void onArmorTick(ItemStack itemstack, Level level, Player player) {
        if (!level.m_5776_() && !level.m_5776_() && (player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemRegistry.PRIMITIVE_HELMET.get()) || player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ItemRegistry.PRIMITIVE_CHESTPLATE.get()) || player.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ItemRegistry.PRIMITIVE_LEGGINGS.get()) || player.m_6844_(EquipmentSlot.FEET).m_150930_((Item)ItemRegistry.PRIMITIVE_BOOTS.get()))) {
            player.m_21195_(MobEffects.f_19597_);
            player.m_21195_(MobEffects.f_19599_);
            player.m_21195_(MobEffects.f_19604_);
        }
    }

    public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(itemstack, world, entity, slot, selected);
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)itemstack);
        if (!enchantments.isEmpty()) {
            itemstack.m_41742_(1000);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag = stack.m_41783_();
        tooltip.add((Component)Component.m_237115_((String)"tooltip.composite_material.primitive_armor").m_130940_(ChatFormatting.DARK_AQUA));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.composite_material.primitive_armor_1").m_130940_(ChatFormatting.RED));
        if (tag.m_128451_("RepairCost") > 999) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.composite_material.primitive_tool_1").m_130940_(ChatFormatting.DARK_RED));
        }
    }
}

