/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcneg.compositematerial.common.items;

import io.github.rcneg.compositematerial.common.config.Config;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SonicBoomWand
extends Item
implements Vanishable {
    public SonicBoomWand(Item.Properties p_43009_) {
        super(p_43009_);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int p_40670_) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int i = this.m_8105_(stack) - p_40670_;
            float f = SonicBoomWand.getPowerForTime(i);
            if (!((double)f < 0.1)) {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if ((double)f == 1.0) {
                        level.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        for (int s = 1; s <= (Integer)Config.SONIC_LENGTH.get(); ++s) {
                            double sx = (double)s * entity.m_20154_().f_82479_ + entity.m_20185_();
                            double sy = (double)s * entity.m_20154_().f_82480_ + entity.m_20186_() + (double)entity.m_20192_();
                            double sz = (double)s * entity.m_20154_().f_82481_ + entity.m_20189_();
                            Vec3 svec3 = new Vec3(sx, sy, sz);
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_235902_, sx, sy, sz, 1, 0.0, 0.0, 0.0, 0.0);
                            AABB aabb = new AABB(svec3, svec3).m_82400_(1.5);
                            List entities = entity.m_9236_().m_45976_(Entity.class, aabb);
                            for (Entity target : entities) {
                                if (target == player || target instanceof ItemEntity && !((Boolean)Config.SONIC_DESTROY.get()).booleanValue()) continue;
                                target.m_6469_(serverLevel.m_269111_().m_269285_((Entity)player), (float)((Integer)Config.SONIC_DAMAGE.get()).intValue());
                            }
                        }
                        player.m_36335_().m_41524_(stack.m_41720_(), ((Integer)Config.SONIC_COOLDOWN.get()).intValue());
                        stack.m_41622_(1, (LivingEntity)player, p_40665_ -> p_40665_.m_21190_(player.m_7655_()));
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public static float getPowerForTime(int p_40662_) {
        float f = (float)p_40662_ / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int m_8105_(ItemStack p_40680_) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack p_40678_) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_40672_, Player p_40673_, InteractionHand p_40674_) {
        ItemStack itemstack = p_40673_.m_21120_(p_40674_);
        p_40673_.m_5496_(SoundEvents.f_215772_, 1.0f, 1.0f);
        p_40673_.m_6672_(p_40674_);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        String string = "tooltip.composite_material." + stack.m_41720_();
        tooltip.add((Component)Component.m_237115_((String)string).m_130940_(ChatFormatting.DARK_AQUA));
    }
}

