/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcneg.compositematerial.common.events;

import io.github.rcneg.compositematerial.common.config.Config;
import io.github.rcneg.compositematerial.common.helper.EntityHelper;
import io.github.rcneg.compositematerial.common.init.ItemRegistry;
import io.github.rcneg.compositematerial.common.tags.ModTags;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class AttackEvents {
    @SubscribeEvent
    public static void onPlayerLeftClickEntity(AttackEntityEvent event) {
        Entity target;
        Entity entity;
        if (event.getEntity().m_21205_().m_204117_(ModTags.RUSTED_COPPER_TOOLS) && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            entity2.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60, 0, false, true, true));
        }
        if (event.getEntity().m_21205_().m_150930_((Item)ItemRegistry.SCAPEGOAT.get())) {
            ItemStack stack = event.getEntity().m_21205_();
            Entity entity3 = event.getTarget();
            if (entity3 instanceof LivingEntity) {
                LivingEntity entity4 = (LivingEntity)entity3;
                stack.m_41784_().m_128405_("scapegoat_victim", entity4.m_19879_());
                event.getEntity().m_216990_(SoundEvents.f_11704_);
            }
        }
        if (event.getEntity().m_21205_().m_150930_((Item)ItemRegistry.DUNGEON_STEEL_TOTEM.get()) && (target = event.getTarget()) instanceof LivingEntity) {
            ItemStack egg;
            SpawnEggItem eggItem;
            LivingEntity living = (LivingEntity)target;
            if (event.getEntity().m_21223_() * (float)((Integer)Config.CONTRACT_LIMIT.get()).intValue() / 100.0f > living.m_21223_() && (eggItem = ForgeSpawnEggItem.fromEntityType((EntityType)living.m_6095_())) != null && !(egg = new ItemStack((ItemLike)eggItem)).equals(ItemStack.f_41583_) && ((Boolean)Config.CONTRACT_SEAL.get()).booleanValue()) {
                living.m_19983_(egg);
                living.m_5496_(SoundEvents.f_12513_, 1.0f, 0.3f);
                Level level = event.getEntity().m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123765_, target.m_20185_(), target.m_20186_(), target.m_20189_(), 100, 0.0, 0.0, 0.0, 0.5);
                }
                living.m_146870_();
                if (!event.getEntity().m_150110_().f_35937_) {
                    event.getEntity().m_21205_().m_41774_(1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity source;
        ItemStack weapon;
        Entity entity;
        LivingEntity entity2 = event.getEntity();
        Level level = event.getEntity().m_9236_();
        if (!level.m_5776_() && (entity = event.getSource().m_7639_()) instanceof LivingEntity && (weapon = (source = (LivingEntity)entity).m_21205_()).m_204117_(ModTags.ECHOIUM_TOOLS) && entity2.m_21230_() > 0) {
            float d0 = (float)(entity2.m_21230_() * (Integer)Config.ECHOIUM_EXTRA_DAMAGE.get()) / 100.0f;
            float d1 = (Integer)Config.ECHOIUM_EXTRA_LIMIT.get() != 0 ? Math.min(d0, (float)((Integer)Config.ECHOIUM_EXTRA_LIMIT.get()).intValue()) : d0;
            d1 = EntityHelper.getPlayerAttackStrengthAndPlaySound(source, weapon, d1, SoundEvents.f_215778_);
            event.setAmount(event.getAmount() + d1);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity;
        LivingEntity entity2 = event.getEntity();
        Level level = event.getEntity().m_9236_();
        if (!level.m_5776_() && (entity = event.getSource().m_7640_()) instanceof LivingEntity) {
            float d0;
            LivingEntity source = (LivingEntity)entity;
            ItemStack weapon = source.m_21205_();
            if (weapon.m_150930_((Item)ItemRegistry.DISC_AXE.get()) && entity2 instanceof Warden) {
                event.setAmount(event.getAmount() * (float)((Double)Config.DISC_AXE_BASE.get() / 100.0));
            }
            if (weapon.m_204117_(ModTags.ETHERITE_TOOLS)) {
                d0 = (entity2.m_21233_() - entity2.m_21223_()) * (float)((Integer)Config.ETHERITE_EXTRA_DAMAGE.get()).intValue() / 100.0f;
                float d1 = (Integer)Config.ETHERITE_EXTRA_LIMIT.get() != 0 ? Math.min(d0, (float)((Integer)Config.ETHERITE_EXTRA_LIMIT.get()).intValue()) : d0;
                d1 = EntityHelper.getPlayerAttackStrengthAndPlaySound(source, weapon, d1, SoundEvents.f_11937_);
                event.setAmount(event.getAmount() + d1);
            }
            if (weapon.m_41783_() != null && weapon.m_41783_().m_128471_("CMVanitas")) {
                boolean flag = true;
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    ItemStack item = source.m_6844_(slot);
                    if (!item.m_41793_()) continue;
                    flag = false;
                }
                if (!source.m_21220_().isEmpty()) {
                    flag = false;
                }
                if (flag) {
                    float d02 = entity2.m_21233_() * (float)((Integer)Config.VANITAS_EXTRA_DAMAGE.get()).intValue() / 100.0f;
                    float d1 = (Integer)Config.VANITAS_EXTRA_LIMIT.get() != 0 ? Math.min(d02, (float)((Integer)Config.VANITAS_EXTRA_LIMIT.get()).intValue()) : d02;
                    event.setAmount(event.getAmount() + d1);
                } else if (source instanceof Player) {
                    Player player = (Player)source;
                    player.m_5661_((Component)Component.m_237115_((String)"message.composite_material.vanitas_1"), true);
                }
            }
            if (weapon.m_204117_(ModTags.PRIMITIVE_TOOLS)) {
                d0 = source.m_21223_() * (float)((Integer)Config.PRIMITIVE_EXTRA_DAMAGE.get()).intValue() / 100.0f;
                d0 = EntityHelper.getPlayerAttackStrengthAndPlaySound(source, weapon, d0, SoundEvents.f_12313_);
                event.setAmount(event.getAmount() + d0);
            }
            if (weapon.m_150930_((Item)ItemRegistry.DUNGEON_HAMMER.get()) || weapon.m_150930_((Item)ItemRegistry.DISC_PICKAXE_TRIAL.get())) {
                float h = (float)((double)source.f_19789_ * (Double)Config.DUNGEON_HAMMER_MULTI.get());
                event.setAmount(event.getAmount() + h);
                if (source instanceof Player) {
                    Player player1 = (Player)source;
                    player1.m_5661_((Component)Component.m_237113_((String)String.valueOf((float)Math.round(h * 10.0f) / 10.0f)), true);
                }
                if (weapon.m_150930_((Item)ItemRegistry.DUNGEON_HAMMER.get())) {
                    source.m_183634_();
                }
            }
            if (weapon.m_204117_(ModTags.ALLAY_STEEL_TOOLS) && ((Boolean)Config.ALLAY_ATTACK_SPEC.get()).booleanValue()) {
                Vec3 center = EntityHelper.getVec3((Entity)entity2);
                AABB aabb = new AABB(center, center).m_82400_(((Double)Config.ALLAY_ATTACK_RANGE.get()).doubleValue());
                List entities = entity2.m_9236_().m_45976_(LivingEntity.class, aabb);
                for (LivingEntity target : entities) {
                    ServerPlayer player;
                    if (entity2.m_6095_() != target.m_6095_() || !(source instanceof ServerPlayer) || target == (player = (ServerPlayer)source)) continue;
                    target.f_19802_ = 0;
                    target.m_6469_(entity2.m_9236_().m_269111_().m_269374_((Entity)player), event.getAmount());
                    weapon.m_41622_((Boolean)Config.ALLAY_ATTACK_DAMAGE.get() != false ? 1 : 0, source, p_40665_ -> p_40665_.m_21190_(source.m_7655_()));
                }
            }
            if (weapon.m_150930_((Item)ItemRegistry.ETHERITE_SWORD_REINFORCED.get())) {
                weapon.m_41784_().m_128405_("EtheriteAddition", 0);
            }
            if (entity2.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemRegistry.AMETHYST_HELMET.get()) || entity2.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ItemRegistry.AMETHYST_CHESTPLATE.get()) || entity2.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ItemRegistry.AMETHYST_LEGGINGS.get()) || entity2.m_6844_(EquipmentSlot.FEET).m_150930_((Item)ItemRegistry.AMETHYST_BOOTS.get())) {
                int res = 0;
                if (entity2.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemRegistry.AMETHYST_HELMET.get())) {
                    ++res;
                }
                if (entity2.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ItemRegistry.AMETHYST_CHESTPLATE.get())) {
                    ++res;
                }
                if (entity2.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ItemRegistry.AMETHYST_LEGGINGS.get())) {
                    ++res;
                }
                if (entity2.m_6844_(EquipmentSlot.FEET).m_150930_((Item)ItemRegistry.AMETHYST_BOOTS.get())) {
                    ++res;
                }
                if (event.getSource().m_269533_(DamageTypeTags.f_268731_)) {
                    event.setAmount(event.getAmount() * (float)(1.0 - (double)res * 0.15));
                }
            }
            if (entity2.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemRegistry.PRIMITIVE_HELMET.get()) || entity2.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ItemRegistry.PRIMITIVE_CHESTPLATE.get()) || entity2.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ItemRegistry.PRIMITIVE_LEGGINGS.get()) || entity2.m_6844_(EquipmentSlot.FEET).m_150930_((Item)ItemRegistry.PRIMITIVE_BOOTS.get())) {
                int res = 0;
                if (entity2.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemRegistry.PRIMITIVE_HELMET.get())) {
                    ++res;
                }
                if (entity2.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ItemRegistry.PRIMITIVE_CHESTPLATE.get())) {
                    ++res;
                }
                if (entity2.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ItemRegistry.PRIMITIVE_LEGGINGS.get())) {
                    ++res;
                }
                if (entity2.m_6844_(EquipmentSlot.FEET).m_150930_((Item)ItemRegistry.PRIMITIVE_BOOTS.get())) {
                    ++res;
                }
                if (event.getSource().m_7639_() != null) {
                    event.setAmount(event.getAmount() * (float)(1.0 - (double)res * 0.2));
                }
            }
            if (source.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemRegistry.ECHOIUM_HELMET.get()) || source.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ItemRegistry.ECHOIUM_CHESTPLATE.get()) || source.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ItemRegistry.ECHOIUM_LEGGINGS.get()) || source.m_6844_(EquipmentSlot.FEET).m_150930_((Item)ItemRegistry.ECHOIUM_BOOTS.get())) {
                int res = 0;
                if (source.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemRegistry.ECHOIUM_HELMET.get())) {
                    ++res;
                }
                if (source.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ItemRegistry.ECHOIUM_CHESTPLATE.get())) {
                    ++res;
                }
                if (source.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ItemRegistry.ECHOIUM_LEGGINGS.get())) {
                    ++res;
                }
                if (source.m_6844_(EquipmentSlot.FEET).m_150930_((Item)ItemRegistry.ECHOIUM_BOOTS.get())) {
                    ++res;
                }
                event.setAmount(event.getAmount() * (float)(1.0 + (Double)Config.ECHOIUM_ADD_BOOM.get() * (double)res / 100.0));
            }
            if (weapon.m_150930_((Item)ItemRegistry.DUNGEON_SWORD.get()) || weapon.m_150930_((Item)ItemRegistry.DUNGEON_SWORD_REINFORCED.get())) {
                float d03 = (float)((double)event.getAmount() * (Double)Config.DUNGEON_SWORD_HEAL.get() / 100.0);
                EntityHelper.getPlayerAttackStrengthAndPlaySound(source, weapon, d03, SoundEvents.f_12228_);
                source.m_5634_(d03);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void primitiveTotem(LivingHurtEvent event) {
        Level level = event.getEntity().m_9236_();
        if (!level.m_5776_()) {
            boolean flag;
            LivingEntity entity = event.getEntity();
            Item item = (Item)ItemRegistry.PRIMITIVE_TOTEM.get();
            boolean bl = flag = entity.m_21120_(InteractionHand.MAIN_HAND).m_150930_(item) || entity.m_21120_(InteractionHand.OFF_HAND).m_150930_(item);
            if (flag && !event.getSource().m_276093_(DamageTypes.f_286979_) && event.getAmount() >= entity.m_21233_() * 0.4f) {
                event.setAmount(entity.m_21233_() * (float)((Integer)Config.TOTEM_PROTECT.get()).intValue() / 100.0f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void etheriteTotem(LivingHurtEvent event) {
        Level level = event.getEntity().m_9236_();
        if (!level.m_5776_()) {
            LivingEntity entity = event.getEntity();
            ItemStack itemstack = null;
            if (entity.m_21223_() <= event.getAmount()) {
                for (InteractionHand interactionhand : InteractionHand.values()) {
                    ItemStack itemstack1 = entity.m_21120_(interactionhand);
                    if (!itemstack1.m_150930_((Item)ItemRegistry.ETHERITE_TOTEM.get())) continue;
                    itemstack = itemstack1.m_41777_();
                    break;
                }
                if (itemstack != null) {
                    boolean flag = true;
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverplayer = (ServerPlayer)entity;
                        if (serverplayer.m_36335_().m_41519_((Item)ItemRegistry.ETHERITE_TOTEM.get())) {
                            flag = false;
                        }
                        int cooldown = (Integer)Config.TOTEM_COOLDOWN.get();
                        if (entity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemRegistry.ETHERITE_HELMET.get()) && entity.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ItemRegistry.ETHERITE_CHESTPLATE.get()) && entity.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ItemRegistry.ETHERITE_LEGGINGS.get()) && entity.m_6844_(EquipmentSlot.FEET).m_150930_((Item)ItemRegistry.ETHERITE_BOOTS.get())) {
                            cooldown /= 2;
                        }
                        serverplayer.m_36335_().m_41524_((Item)ItemRegistry.ETHERITE_TOTEM.get(), cooldown);
                        serverplayer.m_6278_(Stats.f_12982_.m_12902_((Object)Items.f_42747_), 1);
                        if (flag && level.m_5776_()) {
                            Minecraft.m_91087_().f_91063_.m_109113_(((Item)ItemRegistry.ETHERITE_TOTEM.get()).m_7968_());
                        }
                    }
                    if (flag) {
                        Level level2 = event.getEntity().m_9236_();
                        if (level2 instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level2;
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123767_, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), 100, 0.0, 0.0, 0.0, 1.0);
                        }
                        level.m_5594_(null, entity.m_20097_(), SoundEvents.f_12513_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        entity.m_21153_(entity.m_21233_());
                        entity.m_21219_();
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityLoot(LivingDropsEvent event) {
        Entity target;
        Entity head;
        Entity weapon;
        ItemStack drops;
        Entity drop;
        LivingEntity player;
        Entity entity;
        if (!event.getEntity().m_9236_().m_5776_() && (entity = event.getSource().m_7639_()) instanceof LivingEntity && (player = (LivingEntity)entity).m_21205_().m_150930_((Item)ItemRegistry.ABYSS_BLADE.get()) && event.getEntity().m_6336_() == MobType.f_21644_) {
            switch ((int)Math.round(Math.random() * 10.0)) {
                case 1: {
                    drop = Items.f_42715_;
                    break;
                }
                case 2: {
                    drop = Items.f_42355_;
                    break;
                }
                case 3: {
                    drop = Items.f_42696_;
                    break;
                }
                case 4: {
                    drop = Items.f_42526_;
                    break;
                }
                case 5: {
                    drop = Items.f_42527_;
                    break;
                }
                case 6: {
                    drop = Items.f_41868_;
                    break;
                }
                case 7: {
                    drop = Items.f_41867_;
                    break;
                }
                case 8: {
                    drop = Items.f_41910_;
                    break;
                }
                case 9: {
                    drop = Items.f_42279_;
                    break;
                }
                case 10: {
                    drop = Items.f_42529_;
                    break;
                }
                default: {
                    drop = Items.f_42528_;
                }
            }
            drops = drop.m_7968_();
            EntityHelper.addEntityDrops(event, drops, 0, 1.0f, 0.0f);
        }
        if (!event.getEntity().m_9236_().m_5776_() && (drop = event.getSource().m_7639_()) instanceof LivingEntity && (player = (LivingEntity)drop).m_21205_().m_150930_((Item)ItemRegistry.DISC_AXE.get()) && event.getEntity() instanceof Warden) {
            switch ((int)Math.round(Math.random() * 10.0) + 15 * EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44985_, (ItemStack)player.m_21205_())) {
                case 1: {
                    drop = Items.f_220192_;
                    break;
                }
                case 2: {
                    drop = Items.f_220195_;
                    break;
                }
                case 3: {
                    drop = Items.f_220194_;
                    break;
                }
                case 4: {
                    drop = Items.f_151042_;
                    break;
                }
                case 5: {
                    drop = Items.f_220193_;
                    break;
                }
                case 6: {
                    drop = Items.f_220218_;
                    break;
                }
                case 7: {
                    drop = Items.f_220211_;
                    break;
                }
                case 8: {
                    drop = (Item)ItemRegistry.ECHOIUM_NUGGET.get();
                    break;
                }
                case 9: {
                    drop = (Item)ItemRegistry.WARDEN_HAND.get();
                    break;
                }
                case 10: {
                    drop = Items.f_42612_;
                    break;
                }
                case 11: {
                    drop = Items.f_276539_;
                    break;
                }
                case 12: {
                    drop = Items.f_42779_;
                    break;
                }
                default: {
                    drop = Items.f_220224_;
                }
            }
            drops = drop.m_7968_();
            EntityHelper.addEntityDrops(event, drops, 0, 1.0f, 0.0f);
        }
        if (!event.getEntity().m_9236_().m_5776_() && (drop = event.getSource().m_7639_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)drop;
            if (((Boolean)Config.DUNGEON_SWORD_SPEC.get()).booleanValue() && ((weapon = living.m_21205_()).m_150930_((Item)ItemRegistry.DUNGEON_SWORD.get()) || weapon.m_150930_((Item)ItemRegistry.DUNGEON_SWORD_REINFORCED.get()))) {
                SpawnEggItem eggItem = ForgeSpawnEggItem.fromEntityType((EntityType)event.getEntity().m_6095_());
                if (((Boolean)Config.DUNGEON_REPLACE_EGG.get()).booleanValue() && event.getEntity() instanceof EnderDragon) {
                    eggItem = Items.f_42104_;
                }
                if (eggItem != null) {
                    ItemStack egg = new ItemStack((ItemLike)eggItem);
                    int ench = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44982_, (ItemStack)weapon);
                    if (Math.random() <= (double)((float)((Double)Config.DUNGEON_SWORD_BASE.get() / 100.0) + (float)ench * (float)((Double)Config.DUNGEON_SWORD_ENCH.get() / 100.0))) {
                        event.getEntity().m_19983_(egg);
                        if (weapon.m_150930_((Item)ItemRegistry.DUNGEON_SWORD_REINFORCED.get())) {
                            ListTag list = weapon.m_41784_().m_128437_("DungeonAddition", 8);
                            int size = list.size();
                            list.add((Object)StringTag.m_129297_((String)egg.m_41720_().toString()));
                            ListTag newList = new ListTag();
                            for (Tag tag : list) {
                                boolean isContains = newList.contains((Object)tag);
                                if (isContains) continue;
                                newList.add((Object)tag);
                            }
                            if (size < newList.size()) {
                                living.m_9236_().m_5594_(null, living.m_20097_(), SoundEvents.f_11739_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                            }
                            weapon.m_41784_().m_128365_("DungeonAddition", (Tag)newList);
                        }
                    }
                }
            }
        }
        if (!event.getEntity().m_9236_().m_5776_() && (weapon = event.getSource().m_7639_()) instanceof LivingEntity) {
            player = (LivingEntity)weapon;
            if (((Boolean)Config.DUNGEON_AXE_SPEC.get()).booleanValue() && player.m_21205_().m_150930_((Item)ItemRegistry.DUNGEON_AXE.get())) {
                LivingEntity ench;
                head = null;
                int ench2 = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44987_, (ItemStack)player.m_21205_());
                if (event.getEntity() instanceof Zombie) {
                    head = Items.f_42681_.m_7968_();
                }
                if (event.getEntity() instanceof Skeleton) {
                    head = Items.f_42678_.m_7968_();
                }
                if (event.getEntity() instanceof WitherSkeleton || event.getEntity() instanceof WitherBoss) {
                    head = Items.f_42679_.m_7968_();
                }
                if (event.getEntity() instanceof Creeper) {
                    head = Items.f_42682_.m_7968_();
                }
                if (event.getEntity() instanceof EnderDragon) {
                    head = Items.f_42683_.m_7968_();
                }
                if (event.getEntity() instanceof Piglin) {
                    head = Items.f_260451_.m_7968_();
                }
                if ((ench = event.getEntity()) instanceof Player) {
                    Player killedPlayer = (Player)ench;
                    head = Items.f_42680_.m_7968_();
                    head.m_41784_().m_128359_("SkullOwner", killedPlayer.m_36316_().getName());
                }
                if (head != null) {
                    EntityHelper.addEntityDrops(event, (ItemStack)head, ench2, (float)((Double)Config.DUNGEON_AXE_BASE.get() / 100.0), (float)((Double)Config.DUNGEON_AXE_ENCH.get() / 100.0));
                }
            }
        }
        if (!event.getEntity().m_9236_().m_5776_() && (head = event.getSource().m_7639_()) instanceof LivingEntity && (player = (LivingEntity)head).m_21205_().m_150930_((Item)ItemRegistry.DISC_SWORD.get())) {
            target = event.getEntity();
            int ench = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44982_, (ItemStack)player.m_21205_());
            Item drop2 = target instanceof PiglinBrute ? Items.f_42419_ : (target instanceof Piglin ? Items.f_42436_ : (target instanceof WanderingTrader ? Items.f_42437_ : (target instanceof Villager ? Items.f_42777_ : (target.m_6336_() == MobType.f_21643_ ? Items.f_42747_ : Items.f_42417_))));
            ItemStack drops2 = drop2.m_7968_();
            EntityHelper.addEntityDrops(event, drops2, ench, (float)((Double)Config.DISC_SWORD_BASE.get() / 100.0), (float)((Double)Config.DISC_SWORD_ENCH.get() / 100.0));
        }
        if (!event.getEntity().m_9236_().m_5776_() && (target = event.getSource().m_7639_()) instanceof LivingEntity && (player = (LivingEntity)target).m_21205_().m_150930_((Item)ItemRegistry.DISC_PICKAXE_TRIAL.get())) {
            float h = (float)((double)player.f_19789_ * (Double)Config.DUNGEON_HAMMER_MULTI.get());
            float result = h / 100.0f;
            while (Math.random() <= (double)result) {
                for (ItemEntity stack : event.getDrops()) {
                    int ans = stack.m_32055_().m_41613_() + 1;
                    stack.m_32055_().m_41764_(ans);
                }
                result -= 1.0f;
            }
            player.m_183634_();
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        Level level = event.getEntity().m_9236_();
        if (!level.m_5776_()) {
            LivingEntity entity = event.getEntity();
            Entity entity2 = event.getSource().m_7640_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity source = (LivingEntity)entity2;
                ItemStack weapon = source.m_21205_();
                if (weapon.m_150930_((Item)ItemRegistry.DUNGEON_AXE.get())) {
                    float d0 = (float)((double)entity.m_21233_() * (Double)Config.DUNGEON_AXE_HEAL.get() / 100.0);
                    source.m_9236_().m_6263_((Player)null, source.m_20185_(), source.m_20186_(), source.m_20189_(), SoundEvents.f_12228_, source.m_5720_(), 1.0f, source.m_6100_());
                    source.m_5634_(d0);
                }
                if (weapon.m_150930_((Item)ItemRegistry.ETHERITE_SWORD_REINFORCED.get())) {
                    weapon.m_41784_().m_128405_("EtheriteAddition", Math.round(entity.m_21233_()));
                }
            }
        }
    }
}

