/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcneg.compositematerial.common.events;

import io.github.rcneg.compositematerial.common.config.Config;
import io.github.rcneg.compositematerial.common.helper.EntityHelper;
import io.github.rcneg.compositematerial.common.init.ItemRegistry;
import io.github.rcneg.compositematerial.common.init.PotionEffectRegistry;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ActionEvents {
    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinLevelEvent event) {
        Warden warden;
        Entity entity = event.getEntity();
        if (entity instanceof Warden && (warden = (Warden)entity).m_20089_() == Pose.EMERGING && ((Boolean)Config.ECHOIUM_STOP_SPAWN.get()).booleanValue()) {
            Vec3 center = EntityHelper.getVec3((Entity)warden);
            AABB aabb = new AABB(center, center).m_82400_(((Double)Config.ALLAY_ATTACK_RANGE.get()).doubleValue());
            List entities = warden.m_9236_().m_45976_(LivingEntity.class, aabb);
            for (LivingEntity target : entities) {
                Player player;
                if (!(target instanceof Player) || !(player = (Player)target).m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemRegistry.ECHOIUM_HELMET.get()) || !player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ItemRegistry.ECHOIUM_CHESTPLATE.get()) || !player.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ItemRegistry.ECHOIUM_LEGGINGS.get()) || !player.m_6844_(EquipmentSlot.FEET).m_150930_((Item)ItemRegistry.ECHOIUM_BOOTS.get())) continue;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onAllayEffectExpired(MobEffectEvent.Expired event) {
        Allay allay;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Allay && (allay = (Allay)livingEntity).m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ItemRegistry.DUNGEON_STEEL_INGOT.get()) && event.getEffectInstance() != null && event.getEffectInstance().equals((Object)new MobEffectInstance(MobEffects.f_216964_))) {
            allay.m_216990_(SoundEvents.f_215672_);
            Level level = allay.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, allay.m_20185_(), allay.m_20186_(), allay.m_20189_(), 25, 0.0, 0.0, 0.0, 0.3);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_235902_, allay.m_20185_(), allay.m_20186_(), allay.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            allay.m_19998_((ItemLike)ItemRegistry.ALLAY_STEEL_INGOT.get());
            allay.m_19998_((ItemLike)ItemRegistry.ALLAY_STEEL_INGOT.get());
            allay.m_146870_();
        }
    }

    @SubscribeEvent
    public static void onEntityTeleport(EntityTeleportEvent event) {
        LivingEntity livingEntity;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_((MobEffect)PotionEffectRegistry.DISABLE_TELEPORT.get())) {
            int amp = livingEntity.m_21124_((MobEffect)PotionEffectRegistry.DISABLE_TELEPORT.get()).m_19564_();
            if (amp > 0) {
                livingEntity.m_6469_(livingEntity.m_9236_().m_269111_().m_269425_(), 8.0f * (float)amp);
            }
            event.setCanceled(true);
        }
    }
}

