/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcneg.compositematerial;

import com.mojang.logging.LogUtils;
import io.github.rcneg.compositematerial.common.config.Config;
import io.github.rcneg.compositematerial.common.init.BlockRegistry;
import io.github.rcneg.compositematerial.common.init.EntityTypeRegistry;
import io.github.rcneg.compositematerial.common.init.ItemRegistry;
import io.github.rcneg.compositematerial.common.init.LootModifierRegistry;
import io.github.rcneg.compositematerial.common.init.ModFilePackResources;
import io.github.rcneg.compositematerial.common.init.PotionEffectRegistry;
import io.github.rcneg.compositematerial.common.init.TabRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod(value="composite_material")
public class CompositeMaterial {
    public static final String MODID = "composite_material";
    private static final Logger LOGGER = LogUtils.getLogger();

    public CompositeMaterial() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        ItemRegistry.ITEMS.register(modEventBus);
        BlockRegistry.BLOCKS.register(modEventBus);
        PotionEffectRegistry.MOB_EFFECTS.register(modEventBus);
        PotionEffectRegistry.POTION.register(modEventBus);
        EntityTypeRegistry.ENTITY_TYPES.register(modEventBus);
        LootModifierRegistry.LOOT_MODIFIER_SERIALIZERS.register(modEventBus);
        TabRegistry.CREATIVE_MODE_TABS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        LOGGER.info("DIRT BLOCK >> {}", (Object)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50493_));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void addPackFinders(AddPackFindersEvent event) {
            if (event.getPackType() == PackType.CLIENT_RESOURCES) {
                IModFileInfo modFileInfo = ModList.get().getModFileById(CompositeMaterial.MODID);
                if (modFileInfo == null) {
                    return;
                }
                IModFile modFile = modFileInfo.getFile();
                event.addRepositorySource(consumer -> {
                    Pack pack = Pack.m_245429_((String)"composite_material:cm_legacy", (Component)Component.m_237113_((String)"CM Legacy"), (boolean)false, id -> new ModFilePackResources(id, modFile, "resourcepacks/cm_legacy"), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                    Pack pack2 = Pack.m_245429_((String)"composite_material:cm_no_larger_swords", (Component)Component.m_237113_((String)"CM No Larger Swords"), (boolean)false, id -> new ModFilePackResources(id, modFile, "resourcepacks/cm_no_larger_swords"), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                    Pack pack3 = Pack.m_245429_((String)"composite_material:cm_reinforced_legacy", (Component)Component.m_237113_((String)"CM Reinforced Legacy"), (boolean)false, id -> new ModFilePackResources(id, modFile, "resourcepacks/cm_reinforced_legacy"), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                    if (pack2 != null) {
                        consumer.accept(pack2);
                    }
                    if (pack != null) {
                        consumer.accept(pack);
                    }
                    if (pack3 != null) {
                        consumer.accept(pack3);
                    }
                });
            }
        }
    }

    @Mod.EventBusSubscriber(modid="composite_material", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
        }
    }
}

