/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.opts.worldgen.vanilla.mixin.the_end_biome_cache;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={TheEndBiomeSource.class})
public abstract class MixinTheEndBiomeSource {
    @Shadow
    @Final
    private Holder<Biome> f_48622_;
    @Shadow
    @Final
    private Holder<Biome> f_48623_;
    @Shadow
    @Final
    private Holder<Biome> f_48624_;
    @Shadow
    @Final
    private Holder<Biome> f_48625_;
    @Shadow
    @Final
    private Holder<Biome> f_48621_;
    private final ThreadLocal<Long2ObjectLinkedOpenHashMap<Holder<Biome>>> cache = ThreadLocal.withInitial(Long2ObjectLinkedOpenHashMap::new);
    private final int cacheCapacity = 1024;

    private Holder<Biome> getBiomeForNoiseGenVanilla(int x, int y, int z, Climate.Sampler noise) {
        int m;
        int i = QuartPos.m_175402_((int)x);
        int j = QuartPos.m_175402_((int)y);
        int k = QuartPos.m_175402_((int)z);
        int l = SectionPos.m_123171_((int)i);
        if ((long)l * (long)l + (long)(m = SectionPos.m_123171_((int)k)) * (long)m <= 4096L) {
            return this.f_48621_;
        }
        int n = (SectionPos.m_123171_((int)i) * 2 + 1) * 8;
        int o = (SectionPos.m_123171_((int)k) * 2 + 1) * 8;
        double d = noise.f_207848_().m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(n, j, o));
        if (d > 0.25) {
            return this.f_48622_;
        }
        if (d >= -0.0625) {
            return this.f_48623_;
        }
        return d < -0.21875 ? this.f_48624_ : this.f_48625_;
    }

    @Overwrite
    public Holder<Biome> m_203407_(int biomeX, int biomeY, int biomeZ, Climate.Sampler multiNoiseSampler) {
        long key = ChunkPos.m_45589_((int)biomeX, (int)biomeZ);
        Long2ObjectLinkedOpenHashMap<Holder<Biome>> cacheThreadLocal = this.cache.get();
        Holder biome = (Holder)cacheThreadLocal.get(key);
        if (biome != null) {
            return biome;
        }
        Holder<Biome> gennedBiome = this.getBiomeForNoiseGenVanilla(biomeX, biomeY, biomeZ, multiNoiseSampler);
        cacheThreadLocal.put(key, gennedBiome);
        if (cacheThreadLocal.size() > 1024) {
            for (int i = 0; i < 64; ++i) {
                cacheThreadLocal.removeFirst();
            }
        }
        return gennedBiome;
    }
}

