/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.spells.void_spells;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.utils.WandUtil;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.GoetySounds;
import com.github.L_Ender.cataclysm.entity.projectile.Void_Rune_Entity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VoidRuneSpell
extends Spell {
    public int defaultSoulCost() {
        return (Integer)GCSpellConfig.VoidRuneCost.get();
    }

    public int defaultCastDuration() {
        return (Integer)GCSpellConfig.VoidRuneDuration.get();
    }

    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)GoetySounds.VOID_PREPARE_SPELL.get();
    }

    public int defaultSpellCooldown() {
        return (Integer)GCSpellConfig.VoidRuneCoolDown.get();
    }

    public SpellType getSpellType() {
        return SpellType.VOID;
    }

    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        int range = spellStat.getRange();
        if (WandUtil.enchantedFocus((LivingEntity)caster)) {
            potency += WandUtil.getPotencyLevel((LivingEntity)caster);
            range += WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.RANGE.get()), (LivingEntity)caster);
        }
        if (!this.rightStaff(staff)) {
            int standingOnY = Mth.m_14107_((double)caster.m_20186_()) - 1;
            double headY = caster.m_20186_() + 1.0;
            float yawRadians = (float)Math.toRadians(90.0f + caster.m_146908_());
            if (this.isShifting(caster)) {
                float mulPosedYaw;
                for (int i = 0; i < 5; ++i) {
                    mulPosedYaw = yawRadians + (float)i * (float)Math.PI * 0.4f;
                    this.spawnFangs(caster.m_20185_() + (double)Mth.m_14089_((float)mulPosedYaw) * 1.5, headY, caster.m_20189_() + (double)Mth.m_14031_((float)mulPosedYaw) * 1.5, standingOnY, mulPosedYaw, 0, caster, potency);
                }
                for (int k = 0; k < 8; ++k) {
                    mulPosedYaw = yawRadians + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.spawnFangs(caster.m_20185_() + (double)Mth.m_14089_((float)mulPosedYaw) * 2.5, headY, caster.m_20189_() + (double)Mth.m_14031_((float)mulPosedYaw) * 2.5, standingOnY, mulPosedYaw, 3, caster, potency);
                }
            } else {
                for (int l = 0; l < 10; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    this.spawnFangs(caster.m_20185_() + (double)Mth.m_14089_((float)yawRadians) * d2, headY, caster.m_20189_() + (double)Mth.m_14031_((float)yawRadians) * d2, standingOnY, yawRadians, l, caster, potency);
                }
            }
        } else {
            int k;
            HitResult hitResult = this.rayTrace((Level)worldIn, caster, range, 3.0);
            Vec3 vec3 = hitResult.m_82450_();
            double d0 = Math.min(vec3.f_82480_, caster.m_20186_());
            double d1 = Math.max(vec3.f_82480_, caster.m_20186_()) + 1.0;
            float f = (float)Mth.m_14136_((double)(vec3.f_82481_ - caster.m_20189_()), (double)(vec3.f_82479_ - caster.m_20185_()));
            LivingEntity target = this.getTarget(caster);
            if (target != null) {
                d0 = Math.min(target.m_20186_(), caster.m_20186_());
                d1 = Math.max(target.m_20186_(), caster.m_20186_()) + 1.0;
                f = (float)Mth.m_14136_((double)(target.m_20189_() - caster.m_20189_()), (double)(target.m_20185_() - caster.m_20185_()));
            }
            float f2 = Mth.m_14089_((float)(caster.m_146908_() * ((float)Math.PI / 180))) * 2.0f;
            float f3 = Mth.m_14031_((float)(caster.m_146908_() * ((float)Math.PI / 180))) * 2.0f;
            for (k = 0; k < 10; ++k) {
                double d2 = 1.5 * (double)(k + 1);
                int j = (int)(1.25f * (float)k);
                this.spawnFangs(caster.m_20185_() + (double)f2 + (double)Mth.m_14089_((float)f) * d2, caster.m_20189_() + (double)f3 + (double)Mth.m_14031_((float)f) * d2, d0, d1, f, j, caster, potency);
                this.spawnFangs(caster.m_20185_() - (double)f2 + (double)Mth.m_14089_((float)f) * d2, caster.m_20189_() - (double)f3 + (double)Mth.m_14031_((float)f) * d2, d0, d1, f, j, caster, potency);
            }
            for (k = 0; k < 6; ++k) {
                float f4 = f + (float)k * (float)Math.PI * 2.0f / 6.0f + 0.83775806f;
                this.spawnFangs(caster.m_20185_() + (double)Mth.m_14089_((float)f4) * 2.5, caster.m_20189_() + (double)Mth.m_14031_((float)f4) * 2.5, d0, d1, f2, 5, caster, potency);
            }
            for (k = 0; k < 8; ++k) {
                this.spawnFangs(caster.m_20185_() + caster.m_217043_().m_188583_() * 4.5, caster.m_20189_() + caster.m_217043_().m_188583_() * 4.5, d0, d1, f3, 15, caster, potency);
            }
        }
    }

    private void spawnFangs(double x, double y, double z, int lowestYCheck, float yRot, int warmupDelayTicks, LivingEntity caster, int potency) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = caster.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)caster.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!caster.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = caster.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)caster.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= lowestYCheck);
        if (flag) {
            caster.m_9236_().m_7967_((Entity)new Void_Rune_Entity(caster.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, yRot, warmupDelayTicks, ((Double)GCSpellConfig.VoidRuneDamage.get()).floatValue() * WandUtil.damageMultiply() + (float)potency, caster));
        }
    }

    private void spawnFangs(double x, double z, double minY, double y, float rotation, int delay, LivingEntity caster, int potency) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = caster.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)caster.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!caster.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = caster.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)caster.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            caster.m_9236_().m_7967_((Entity)new Void_Rune_Entity(caster.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, ((Double)GCSpellConfig.VoidRuneDamage.get()).floatValue() * WandUtil.damageMultiply() + (float)potency, caster));
        }
    }
}

