/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.spells.storm;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.WandUtil;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import com.Polarice3.goety_cataclysm.init.GoetySounds;
import com.github.L_Ender.cataclysm.client.particle.CircleLightningParticle;
import com.github.L_Ender.cataclysm.client.particle.StormParticle;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Lightning_Spear_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Water_Spear_Entity;
import com.github.L_Ender.cataclysm.init.ModParticle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ThunderRageSpell
extends Spell {
    public int defaultSoulCost() {
        return (Integer)GCSpellConfig.ThunderRageCost.get();
    }

    public int defaultCastDuration() {
        return 150;
    }

    public int castDuration(LivingEntity caster, ItemStack staff) {
        return 150;
    }

    public int defaultSpellCooldown() {
        return (Integer)GCSpellConfig.ThunderRageCoolDown.get();
    }

    @Nullable
    public SoundEvent CastingSound(LivingEntity caster) {
        return (SoundEvent)GoetySounds.ZAP.get();
    }

    public SpellType getSpellType() {
        return SpellType.STORM;
    }

    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.VELOCITY.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    public void useSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, int castTime, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        float velocity = spellStat.getVelocity();
        double radius = spellStat.getRadius();
        if (WandUtil.enchantedFocus((LivingEntity)caster)) {
            potency += WandUtil.getPotencyLevel((LivingEntity)caster);
            velocity += (float)WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.VELOCITY.get()), (LivingEntity)caster) / 10.0f;
            radius += (double)WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.RADIUS.get()), (LivingEntity)caster);
        }
        float f = Mth.m_14089_((float)(caster.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(caster.f_20883_ * ((float)Math.PI / 180)));
        double theta = (double)caster.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        BlockPos.MutableBlockPos moved = new BlockPos.MutableBlockPos(caster.m_20185_(), caster.m_20186_(), caster.m_20189_());
        while ((double)moved.m_123342_() < caster.m_20186_() + 9.0 && !worldIn.m_8055_((BlockPos)moved).m_280555_()) {
            moved.m_122173_(Direction.UP);
        }
        double height = (double)moved.m_123342_() - caster.m_20186_();
        if (castTime < 115 && castTime > 55) {
            this.CircleLighning(worldIn, caster, 0.2f, 0.2f, (caster.m_217043_().m_188501_() - 0.5f) * 12.0f, height, 3, 1);
            this.Stormknockback(caster, 0.7f, 5.5);
            float r = 0.56078434f;
            float g = 0.94509804f;
            float b = 0.84313726f;
            worldIn.m_8767_((ParticleOptions)new StormParticle.OrbData(0.3882353f, 0.7607843f, 0.8784314f, 6.0f + caster.m_217043_().m_188501_() * 0.25f, 1.5f + caster.m_217043_().m_188501_() * 0.45f, caster.m_19879_()), caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            worldIn.m_8767_((ParticleOptions)new StormParticle.OrbData(r, g, b, 4.0f + caster.m_217043_().m_188501_() * 1.2f, 1.0f + caster.m_217043_().m_188501_() * 0.45f, caster.m_19879_()), caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            worldIn.m_8767_((ParticleOptions)new StormParticle.OrbData(r, g, b, 2.0f + caster.m_217043_().m_188501_() * 0.7f, 0.35f + caster.m_217043_().m_188501_() * 0.45f, caster.m_19879_()), caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (castTime < 140 && castTime > 55) {
            this.Nimbo(worldIn, caster, 0.2f, 0.2f, 5.0f, height + 0.5, 5, 2);
        }
        if (castTime == 55) {
            ScreenShake_Entity.ScreenShake((Level)worldIn, (Vec3)caster.m_20182_(), (float)15.0f, (float)0.02f, (int)20, (int)10);
        }
        if (castTime == 75) {
            ScreenShake_Entity.ScreenShake((Level)worldIn, (Vec3)caster.m_20182_(), (float)20.0f, (float)0.03f, (int)20, (int)10);
        }
        if (castTime == 95) {
            ScreenShake_Entity.ScreenShake((Level)worldIn, (Vec3)caster.m_20182_(), (float)25.0f, (float)0.04f, (int)20, (int)10);
        }
        if (castTime == 114) {
            this.playSound(worldIn, (Entity)caster, (SoundEvent)CataclysmSounds.SUPER_LIGHTNING.get(), 0.4f, 1.0f + caster.m_217043_().m_188501_() * 0.1f);
            double d0 = caster.m_20185_() + vecX * (double)0.2f + (double)(f * 0.2f);
            double d1 = caster.m_20186_() + height;
            double d2 = caster.m_20189_() + vecZ * (double)0.2f + (double)(f1 * 0.2f);
            worldIn.m_8767_((ParticleOptions)((SimpleParticleType)ModParticle.LIGHTNING_EXPLODE.get()), d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
        }
        int i = 4;
        if (this.rightStaff(staff)) {
            i -= 2;
        }
        for (int l = 115; l <= 145; l += i) {
            if (castTime != l) continue;
            float f2 = caster.m_217043_().m_188501_() * ((float)Math.PI * 2);
            float f3 = Mth.m_14116_((float)caster.m_217043_().m_188501_()) * 5.0f;
            float math = 0.2f;
            double d0 = caster.m_20185_() + (double)(f * math) + (double)(Mth.m_14089_((float)f2) * f3);
            double d1 = caster.m_20186_() + 0.9333 * height;
            double d2 = caster.m_20189_() + (double)(f1 * math) + (double)(Mth.m_14031_((float)f2) * f3);
            HitResult rayTrace = this.rayTrace((Level)worldIn, caster, 16, 3.0);
            Vec3 location = rayTrace.m_82450_();
            LivingEntity target = this.getTarget(caster);
            if (target != null) {
                location = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.35, 0.0);
            }
            double d3 = location.f_82479_ - (caster.m_217043_().m_188500_() - 0.5) * 6.0 - d0;
            double d4 = location.f_82480_ - caster.m_217043_().m_188500_() - d1;
            double d5 = location.f_82481_ - (caster.m_217043_().m_188500_() - 0.5) * 6.0 - d2;
            Vec3 vec3 = new Vec3(d3, d4, d5).m_82541_();
            float yRot = (float)(Mth.m_14136_((double)vec3.f_82481_, (double)vec3.f_82479_) * 57.29577951308232) + 90.0f;
            float xRot = (float)(-(Mth.m_14136_((double)vec3.f_82480_, (double)Math.sqrt(vec3.f_82479_ * vec3.f_82479_ + vec3.f_82481_ * vec3.f_82481_)) * 57.29577951308232));
            float waterDamage = ((Double)GCSpellConfig.WaterSpearDamage.get()).floatValue() * WandUtil.damageMultiply();
            Water_Spear_Entity water = new Water_Spear_Entity(caster, vec3, caster.m_9236_(), waterDamage + (float)potency);
            water.accelerationPower += (double)velocity;
            water.m_146922_(yRot);
            water.m_146926_(xRot);
            water.m_20343_(d0, d1, d2);
            water.setTotalBounces(3 + potency);
            worldIn.m_7967_((Entity)water);
            float lightningDamage = ((Double)GCSpellConfig.LightningSpearDamage.get()).floatValue() * WandUtil.damageMultiply();
            Lightning_Spear_Entity lightning = new Lightning_Spear_Entity(caster, vec3, caster.m_9236_(), lightningDamage + (float)potency);
            lightning.accelerationPower += (double)velocity;
            lightning.m_146922_(yRot);
            lightning.m_146926_(xRot);
            lightning.m_20343_(d0, d1, d2);
            lightning.setAreaDamage(((Double)GCSpellConfig.LightningSpearAreaDamage.get()).floatValue() + (float)potency);
            if (this.rightStaff(staff)) {
                lightning.setHpDamage(((Double)GCSpellConfig.LightningSpearHPDamage.get()).floatValue());
            }
            lightning.setAreaRadius((float)radius);
            worldIn.m_7967_((Entity)lightning);
        }
    }

    private void CircleLighning(ServerLevel worldIn, LivingEntity caster, float vec, float math, float radius, double EndHeight, int amount, int randamount) {
        float f = Mth.m_14089_((float)(caster.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(caster.f_20883_ * ((float)Math.PI / 180)));
        double theta = (double)caster.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        double d0 = caster.m_20185_() + vecX * (double)vec + (double)(f * math);
        double d1 = caster.m_20186_() + EndHeight;
        double d2 = caster.m_20189_() + vecZ * (double)vec + (double)(f1 * math);
        for (int i = 0; i < amount + caster.m_217043_().m_188503_(randamount + 1); ++i) {
            double theta2 = caster.m_217043_().m_188500_() * 2.0 * Math.PI;
            double phi = caster.m_217043_().m_188500_() * Math.PI;
            double posX = (double)radius * Math.sin(phi) * Math.cos(theta2);
            double posY = (double)radius * Math.cos(phi);
            double posZ = (double)radius * Math.sin(phi) * Math.sin(theta2);
            worldIn.m_8767_((ParticleOptions)new CircleLightningParticle.CircleData(143, 241, 215), d0 + posX, d1 + posY, d2 + posZ, 0, d0, d1, d2, 1.0);
        }
    }

    private void Stormknockback(LivingEntity caster, float scale, double distance) {
        List<Entity> hit = this.getEntitiesNearby(caster, Entity.class, distance, distance, distance, distance);
        for (Entity target : hit) {
            double d0 = target.m_20185_() - caster.m_20185_();
            double d1 = target.m_20189_() - caster.m_20189_();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            double power = target.m_6144_() ? (double)(scale / 3.0f) : (double)scale;
            target.m_5997_(d0 / d2 * power, 0.0, d1 / d2 * power);
        }
    }

    public List<LivingEntity> getEntityLivingBaseNearby(LivingEntity caster, double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(caster, LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(LivingEntity caster, Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return caster.m_9236_().m_6443_(entityClass, caster.m_20191_().m_82377_(dX, dY, dZ), e -> e != caster && (double)caster.m_20270_(e) <= r + (double)(e.m_20205_() / 2.0f) && e.m_20186_() <= caster.m_20186_() + dY);
    }

    private void Nimbo(ServerLevel world, LivingEntity caster, float vec, float math, float radius, double EndHeight, int amount, int randamount) {
        for (int j = 0; j < amount + caster.m_217043_().m_188503_(randamount); ++j) {
            float f2 = caster.m_217043_().m_188501_() * ((float)Math.PI * 2);
            float f3 = Mth.m_14116_((float)caster.m_217043_().m_188501_()) * radius;
            float f = Mth.m_14089_((float)(caster.f_20883_ * ((float)Math.PI / 180)));
            float f1 = Mth.m_14031_((float)(caster.f_20883_ * ((float)Math.PI / 180)));
            double theta = (double)caster.f_20883_ * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            double d0 = caster.m_20185_() + vecX * (double)vec + (double)(f * math) + (double)(Mth.m_14089_((float)f2) * f3);
            double d2 = caster.m_20186_() + EndHeight;
            double d4 = caster.m_20189_() + vecZ * (double)vec + (double)(f1 * math) + (double)(Mth.m_14031_((float)f2) * f3);
            world.m_8767_((ParticleOptions)((SimpleParticleType)ModParticle.RAIN_CLOUD.get()), d0, d2, d4, 1, caster.m_217043_().m_188583_() * 0.03, caster.m_217043_().m_188583_() * 0.01, caster.m_217043_().m_188583_() * 0.03, 0.0);
        }
    }

    public void stopSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, ItemStack focus, int castTime, SpellStat spellStat) {
        if (castTime >= 115 && caster instanceof Player) {
            Player player = (Player)caster;
            SEHelper.addCooldown((Player)player, (Item)focus.m_41720_(), (int)this.spellCooldown((LivingEntity)player));
            SEHelper.sendSEUpdatePacket((Player)player);
        }
    }
}

