/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.spells.storm;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.WandUtil;
import com.Polarice3.goety_cataclysm.common.entities.projectiles.StormSerpent;
import com.Polarice3.goety_cataclysm.common.network.GCNetwork;
import com.Polarice3.goety_cataclysm.common.network.server.SRingParticlePacket;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import com.github.L_Ender.cataclysm.client.particle.Gathering_Water_Particle;
import com.github.L_Ender.cataclysm.client.particle.RoarParticle;
import com.github.L_Ender.cataclysm.client.particle.StormParticle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class StormSerpentSpell
extends Spell {
    public int defaultSoulCost() {
        return (Integer)GCSpellConfig.StormSerpentCost.get();
    }

    public int defaultCastDuration() {
        return 75;
    }

    public int castDuration(LivingEntity caster, ItemStack staff) {
        return 75;
    }

    public int defaultSpellCooldown() {
        return (Integer)GCSpellConfig.StormSerpentCoolDown.get();
    }

    public SpellType getSpellType() {
        return SpellType.STORM;
    }

    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        return list;
    }

    public void useSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, int castTime, SpellStat spellStat) {
        Vec3 vec3;
        double d5;
        double d4;
        double d3;
        Vec3 location;
        HitResult rayTrace;
        double d2;
        double d1;
        double d0;
        double math;
        double firstAngleOffset;
        float f1;
        float f;
        int i;
        int potency = spellStat.getPotency();
        if (WandUtil.enchantedFocus((LivingEntity)caster)) {
            potency += WandUtil.getPotencyLevel((LivingEntity)caster);
        }
        LivingEntity target = this.getTarget(caster);
        float multiply = WandUtil.damageMultiply();
        float damage = (float)((Double)GCSpellConfig.StormSerpentDamage.get() * (double)multiply);
        damage += (float)potency;
        if (castTime < 20 && castTime > 1) {
            for (i = 0; i < 2; ++i) {
                float r = 0.36862746f;
                float g = 0.5882353f;
                float b = 0.8862745f;
                double p0 = caster.m_20185_();
                double p1 = caster.m_20186_() + 0.1;
                double p2 = caster.m_20189_();
                worldIn.m_8767_((ParticleOptions)new Gathering_Water_Particle.GatheringData(r, g, b), p0 + (double)((caster.m_217043_().m_188501_() - 0.5f) * 12.0f), p1 + (double)((caster.m_217043_().m_188501_() - 0.5f) * 2.0f), p2 + (double)((caster.m_217043_().m_188501_() - 0.5f) * 12.0f), 0, p0, p1, p2, 0.5);
            }
        }
        if (castTime == 30) {
            GCNetwork.sentToTrackingEntityAndPlayer((Entity)caster, new SRingParticlePacket(0.0f, 1.5707964f, 30, 94, 150, 226, 1.0f, 65.0f, false, 1, caster.m_20185_(), caster.m_20186_() + (double)0.02f, caster.m_20189_()));
        }
        if (castTime < 40 && castTime > 30) {
            float r = 0.56078434f;
            float g = 0.94509804f;
            float b = 0.84313726f;
            worldIn.m_8767_((ParticleOptions)new StormParticle.OrbData(0.3882353f, 0.7607843f, 0.8784314f, 6.0f + caster.m_217043_().m_188501_() * 0.25f, 1.5f + caster.m_217043_().m_188501_() * 0.45f, caster.m_19879_()), caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            worldIn.m_8767_((ParticleOptions)new StormParticle.OrbData(r, g, b, 4.0f + caster.m_217043_().m_188501_() * 1.2f, 1.0f + caster.m_217043_().m_188501_() * 0.45f, caster.m_19879_()), caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            worldIn.m_8767_((ParticleOptions)new StormParticle.OrbData(r, g, b, 2.0f + caster.m_217043_().m_188501_() * 0.7f, 0.35f + caster.m_217043_().m_188501_() * 0.45f, caster.m_19879_()), caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (castTime == 30) {
            this.playSound(worldIn, (Entity)caster, (SoundEvent)CataclysmSounds.SCYLLA_ROAR.get(), 0.6f, 1.0f);
            this.RoarParticle(caster, -0.4f, 0.0f, 2.4f, 20, 99, 194, 224, 0.4f, 0.4f, 0.5f, 2.5f);
        }
        if (castTime == 33 || castTime == 36 || castTime == 39) {
            this.RoarParticle(caster, -0.4f, 0.0f, 2.4f, 20, 99, 194, 224, 0.4f, 0.4f, 0.5f, 2.5f);
        }
        if (castTime == 28) {
            for (i = 0; i < 2; ++i) {
                f = Mth.m_14089_((float)(caster.f_20883_ * ((float)Math.PI / 180)));
                f1 = Mth.m_14031_((float)(caster.f_20883_ * ((float)Math.PI / 180)));
                double dis = 8.0;
                firstAngleOffset = 0.5 * dis;
                math = 0.0 - firstAngleOffset + (double)i * dis;
                d0 = caster.m_20185_() + (double)f * math;
                d1 = caster.m_20186_() + (double)(caster.m_20206_() * 0.7f);
                d2 = caster.m_20189_() + (double)f1 * math;
                rayTrace = this.rayTrace((Level)worldIn, caster, 16, 3.0);
                location = rayTrace.m_82450_();
                if (target != null) {
                    location = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.35, 0.0);
                }
                d3 = location.f_82479_ - d0;
                d4 = location.f_82480_ - d1;
                d5 = location.f_82481_ - d2;
                vec3 = new Vec3(d3, d4, d5).m_82541_();
                worldIn.m_7967_((Entity)new StormSerpent((Level)worldIn, d0, caster.m_20186_(), d2, (float)Mth.m_14136_((double)vec3.f_82481_, (double)vec3.f_82479_), i * 8, caster, damage, target, i == 0));
            }
        }
        if (this.rightStaff(staff) && castTime == 40) {
            for (i = 0; i < 2; ++i) {
                f = Mth.m_14089_((float)(caster.f_20883_ * ((float)Math.PI / 180)));
                f1 = Mth.m_14031_((float)(caster.f_20883_ * ((float)Math.PI / 180)));
                double dis = 12.0;
                firstAngleOffset = 0.5 * dis;
                math = 0.0 - firstAngleOffset + (double)i * dis;
                d0 = caster.m_20185_() + (double)f * math;
                d1 = caster.m_20186_() + (double)(caster.m_20206_() * 0.7f);
                d2 = caster.m_20189_() + (double)f1 * math;
                rayTrace = this.rayTrace((Level)worldIn, caster, 16, 3.0);
                location = rayTrace.m_82450_();
                if (target != null) {
                    location = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.35, 0.0);
                }
                d3 = location.f_82479_ - d0;
                d4 = location.f_82480_ - d1;
                d5 = location.f_82481_ - d2;
                vec3 = new Vec3(d3, d4, d5).m_82541_();
                worldIn.m_7967_((Entity)new StormSerpent((Level)worldIn, d0, caster.m_20186_(), d2, (float)Mth.m_14136_((double)vec3.f_82481_, (double)vec3.f_82479_), i * 8, caster, damage, target, i == 0));
            }
        }
    }

    private void RoarParticle(LivingEntity caster, float vec, float math, float y, int duration, int r, int g, int b, float a, float start, float inc, float end) {
        Level level = caster.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            float f = Mth.m_14089_((float)(caster.f_20883_ * ((float)Math.PI / 180)));
            float f1 = Mth.m_14031_((float)(caster.f_20883_ * ((float)Math.PI / 180)));
            double theta = (double)caster.f_20883_ * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            serverLevel.m_8767_((ParticleOptions)new RoarParticle.RoarData(duration, r, g, b, a, start, inc, end), caster.m_20185_() + (double)vec * vecX + (double)(f * math), caster.m_20186_() + (double)y, caster.m_20189_() + (double)vec * vecZ + (double)(f1 * math), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void stopSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, ItemStack focus, int castTime, SpellStat spellStat) {
        if (castTime >= 28 && caster instanceof Player) {
            Player player = (Player)caster;
            SEHelper.addCooldown((Player)player, (Item)focus.m_41720_(), (int)this.spellCooldown());
            SEHelper.sendSEUpdatePacket((Player)player);
        }
    }
}

