/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.spells.nether;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.utils.WandUtil;
import com.Polarice3.goety_cataclysm.common.entities.GCEntityType;
import com.Polarice3.goety_cataclysm.common.entities.projectiles.FlareBomb;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FlareBombSpell
extends Spell {
    public SpellStat defaultStats() {
        return super.defaultStats().setVelocity(1.0f);
    }

    public int defaultSoulCost() {
        return (Integer)GCSpellConfig.FlareBombCost.get();
    }

    public int defaultCastDuration() {
        return (Integer)GCSpellConfig.FlareBombDuration.get();
    }

    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)CataclysmSounds.MONSTROSITYGROWL.get();
    }

    public int defaultSpellCooldown() {
        return (Integer)GCSpellConfig.FlareBombCoolDown.get();
    }

    public SpellType getSpellType() {
        return SpellType.NETHER;
    }

    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.VELOCITY.get());
        return list;
    }

    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        float velocity = spellStat.getVelocity();
        if (WandUtil.enchantedFocus((LivingEntity)caster)) {
            potency += WandUtil.getPotencyLevel((LivingEntity)caster);
            velocity += (float)WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.VELOCITY.get()), (LivingEntity)caster) / 3.0f;
        }
        int i1 = this.rightStaff(staff) ? 5 : 1;
        for (int i = 0; i < i1; ++i) {
            FlareBomb lava = new FlareBomb((EntityType<? extends FlareBomb>)((EntityType)GCEntityType.FLARE_BOMB.get()), (Level)worldIn, caster);
            lava.setExtraDamage(potency);
            lava.m_20343_(caster.m_20185_(), caster.m_20227_(0.65), caster.m_20189_());
            lava.m_37251_((Entity)caster, caster.m_146909_(), caster.m_146908_(), 0.0f, velocity, 1 + i * 8);
            worldIn.m_7967_((Entity)lava);
        }
        worldIn.m_6269_(null, (Entity)caster, (SoundEvent)CataclysmSounds.MONSTROSITYSHOOT.get(), this.getSoundSource(), 3.0f, 0.75f);
    }
}

