/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.spells.nether;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import com.Polarice3.goety_cataclysm.common.entities.projectiles.IgnisAbyssFireball;
import com.Polarice3.goety_cataclysm.common.entities.projectiles.IgnisFireball;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ExtinctFlameSpell
extends Spell {
    public SpellStat defaultStats() {
        return super.defaultStats().setRadius(((Double)GCSpellConfig.ExtinctFlameRadius.get()).doubleValue());
    }

    public int defaultSoulCost() {
        return (Integer)GCSpellConfig.ExtinctFlameCost.get();
    }

    public int defaultCastDuration() {
        return (Integer)GCSpellConfig.ExtinctFlameDuration.get();
    }

    @Nullable
    public SoundEvent CastingSound() {
        return SoundEvents.f_271165_;
    }

    public int defaultSpellCooldown() {
        return (Integer)GCSpellConfig.ExtinctFlameCoolDown.get();
    }

    public SpellType getSpellType() {
        return SpellType.NETHER;
    }

    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    public void startSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        worldIn.m_6263_(null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), SoundEvents.f_11868_, this.getSoundSource(), 5.0f, 1.4f + caster.m_217043_().m_188501_() * 0.1f);
    }

    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        float radius = (float)spellStat.getRadius();
        if (WandUtil.enchantedFocus((LivingEntity)caster)) {
            potency += WandUtil.getPotencyLevel((LivingEntity)caster);
            radius += (float)WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.RADIUS.get()), (LivingEntity)caster) / 2.0f;
        }
        switch (worldIn.f_46441_.m_188503_(5)) {
            case 0: {
                if (this.rightStaff(staff)) {
                    this.shootAbyssFireball(caster, new Vec3(-5.0, 3.0, 0.0), 109, potency, radius);
                    this.shootFireball(caster, new Vec3(5.0, 3.0, 0.0), 93, potency, radius);
                }
                this.shootFireball(caster, new Vec3(-2.0, 3.0, 0.0), 45, potency, radius);
                this.shootFireball(caster, new Vec3(0.0, 3.0, 0.0), 61, potency, radius);
                this.shootFireball(caster, new Vec3(2.0, 3.0, 0.0), 77, potency, radius);
                break;
            }
            case 1: {
                if (this.rightStaff(staff)) {
                    this.shootFireball(caster, new Vec3(-5.0, 3.0, 0.0), 45, potency, radius);
                    this.shootFireball(caster, new Vec3(5.0, 3.0, 0.0), 93, potency, radius);
                }
                this.shootAbyssFireball(caster, new Vec3(-2.0, 3.0, 0.0), 109, potency, radius);
                this.shootFireball(caster, new Vec3(0.0, 3.0, 0.0), 61, potency, radius);
                this.shootFireball(caster, new Vec3(2.0, 3.0, 0.0), 77, potency, radius);
                break;
            }
            case 2: {
                if (this.rightStaff(staff)) {
                    this.shootFireball(caster, new Vec3(-5.0, 3.0, 0.0), 45, potency, radius);
                    this.shootFireball(caster, new Vec3(5.0, 3.0, 0.0), 93, potency, radius);
                }
                this.shootFireball(caster, new Vec3(-2.0, 3.0, 0.0), 61, potency, radius);
                this.shootAbyssFireball(caster, new Vec3(0.0, 3.0, 0.0), 109, potency, radius);
                this.shootFireball(caster, new Vec3(2.0, 3.0, 0.0), 77, potency, radius);
                break;
            }
            case 3: {
                if (this.rightStaff(staff)) {
                    this.shootFireball(caster, new Vec3(-5.0, 3.0, 0.0), 45, potency, radius);
                    this.shootFireball(caster, new Vec3(5.0, 3.0, 0.0), 93, potency, radius);
                }
                this.shootFireball(caster, new Vec3(-2.0, 3.0, 0.0), 61, potency, radius);
                this.shootFireball(caster, new Vec3(0.0, 3.0, 0.0), 77, potency, radius);
                this.shootAbyssFireball(caster, new Vec3(2.0, 3.0, 0.0), 109, potency, radius);
                break;
            }
            case 4: {
                if (this.rightStaff(staff)) {
                    this.shootFireball(caster, new Vec3(-5.0, 3.0, 0.0), 45, potency, radius);
                    this.shootAbyssFireball(caster, new Vec3(5.0, 3.0, 0.0), 109, potency, radius);
                }
                this.shootFireball(caster, new Vec3(-2.0, 3.0, 0.0), 61, potency, radius);
                this.shootFireball(caster, new Vec3(0.0, 3.0, 0.0), 77, potency, radius);
                this.shootFireball(caster, new Vec3(2.0, 3.0, 0.0), 93, potency, radius);
            }
        }
    }

    private void shootAbyssFireball(LivingEntity caster, Vec3 shotAt, int timer, int potency, float radius) {
        shotAt = shotAt.m_82524_(-caster.m_146908_() * ((float)Math.PI / 180));
        IgnisAbyssFireball shot = new IgnisAbyssFireball(caster.m_9236_(), caster, this.getTarget(caster));
        shot.setExtraDamage(potency);
        shot.setRadius(radius + 1.0f);
        shot.m_6034_(caster.m_20185_() - (double)(caster.m_20205_() + 1.0f) * 0.15 * (double)Mth.m_14031_((float)(caster.f_20883_ * ((float)Math.PI / 180))), caster.m_20186_() + 1.0, caster.m_20189_() + (double)(caster.m_20205_() + 1.0f) * 0.15 * (double)Mth.m_14089_((float)(caster.f_20883_ * ((float)Math.PI / 180))));
        double d0 = shotAt.f_82479_;
        double d1 = shotAt.f_82480_;
        double d2 = shotAt.f_82481_;
        float f = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2))) * 0.35f;
        shot.m_6686_(d0, d1 + (double)f, d2, 0.25f, 3.0f);
        shot.setUp(timer);
        caster.m_9236_().m_7967_((Entity)shot);
    }

    private void shootFireball(LivingEntity caster, Vec3 shotAt, int timer, int potency, float radius) {
        shotAt = shotAt.m_82524_(-caster.m_146908_() * ((float)Math.PI / 180));
        IgnisFireball shot = new IgnisFireball(caster.m_9236_(), caster, this.getTarget(caster));
        shot.setExtraDamage(potency);
        shot.setRadius(radius);
        shot.m_6034_(caster.m_20185_() - (double)(caster.m_20205_() + 1.0f) * 0.15 * (double)Mth.m_14031_((float)(caster.f_20883_ * ((float)Math.PI / 180))), caster.m_20186_() + 1.0, caster.m_20189_() + (double)(caster.m_20205_() + 1.0f) * 0.15 * (double)Mth.m_14089_((float)(caster.f_20883_ * ((float)Math.PI / 180))));
        double d0 = shotAt.f_82479_;
        double d1 = shotAt.f_82480_;
        double d2 = shotAt.f_82481_;
        float f = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2))) * 0.35f;
        shot.m_6686_(d0, d1 + (double)f, d2, 0.25f, 3.0f);
        shot.setUp(timer);
        if (MobUtil.healthIsHalved((LivingEntity)caster)) {
            shot.setSoul(true);
        }
        caster.m_9236_().m_7967_((Entity)shot);
    }
}

