/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.spells.nether;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.EverChargeSpell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class AshenBreathSpell
extends EverChargeSpell {
    private static final int ARC = 45;

    public SpellStat defaultStats() {
        return super.defaultStats().setRange(7);
    }

    public int defaultSoulCost() {
        return (Integer)GCSpellConfig.AshenBreathCost.get();
    }

    public int defaultCastUp() {
        return (Integer)GCSpellConfig.AshenBreathChargeUp.get();
    }

    public int shotsNumber() {
        return (Integer)GCSpellConfig.AshenBreathDuration.get();
    }

    public int shotsNumber(LivingEntity caster, ItemStack staff) {
        int duration = 0;
        if (WandUtil.enchantedFocus((LivingEntity)caster)) {
            duration += WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.DURATION.get()), (LivingEntity)caster);
        }
        return this.shotsNumber() + MathHelper.secondsToTicks((int)duration);
    }

    public int defaultSpellCooldown() {
        return (Integer)GCSpellConfig.AshenBreathCoolDown.get();
    }

    public SpellType getSpellType() {
        return SpellType.NETHER;
    }

    public SoundEvent CastingSound() {
        return (SoundEvent)CataclysmSounds.REVENANT_BREATH.get();
    }

    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    public boolean conditionsMet(ServerLevel worldIn, LivingEntity caster, SpellStat spellStat) {
        Mob mob;
        if (caster instanceof Mob && (mob = (Mob)caster).m_5448_() != null) {
            int range = spellStat.getRange();
            if (WandUtil.enchantedFocus((LivingEntity)caster)) {
                range += WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.RANGE.get()), (LivingEntity)caster);
            }
            return mob.m_142582_((Entity)mob.m_5448_()) && (double)mob.m_20270_((Entity)mob.m_5448_()) <= (double)range + 4.0;
        }
        return super.conditionsMet(worldIn, caster, spellStat);
    }

    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        double zSpeed;
        double ySpeed;
        double xSpeed;
        int i;
        int potency = spellStat.getPotency();
        int range = spellStat.getRange();
        if (WandUtil.enchantedFocus((LivingEntity)caster)) {
            potency += WandUtil.getPotencyLevel((LivingEntity)caster);
            range += WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.RANGE.get()), (LivingEntity)caster);
        }
        float yaw = (float)Math.toRadians(-caster.m_146908_());
        float pitch = (float)Math.toRadians(-caster.m_146909_());
        float spread = 0.25f;
        float speed = 0.56f;
        float xComp = (float)(Math.sin(yaw) * Math.cos(pitch));
        float yComp = (float)Math.sin(pitch);
        float zComp = (float)(Math.cos(yaw) * Math.cos(pitch));
        double theta = (double)caster.m_146908_() * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        double vec = 0.9;
        for (i = 0; i < 80; ++i) {
            xSpeed = (double)(speed * xComp) + (double)(spread * 1.0f * (caster.m_217043_().m_188501_() * 2.0f - 1.0f)) * Math.sqrt(1.0f - xComp * xComp);
            ySpeed = (double)(speed * yComp) + (double)(spread * 1.0f * (caster.m_217043_().m_188501_() * 2.0f - 1.0f)) * Math.sqrt(1.0f - yComp * yComp);
            zSpeed = (double)(speed * zComp) + (double)(spread * 1.0f * (caster.m_217043_().m_188501_() * 2.0f - 1.0f)) * Math.sqrt(1.0f - zComp * zComp);
            worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123762_, caster.m_20185_() + vec * vecX, caster.m_20188_(), caster.m_20189_() + vec * vecZ, 0, xSpeed, ySpeed, zSpeed, 1.0);
        }
        for (i = 0; i < 2; ++i) {
            xSpeed = (double)(speed * xComp) + (double)spread * 0.7 * (double)(caster.m_217043_().m_188501_() * 2.0f - 1.0f) * Math.sqrt(1.0f - xComp * xComp);
            ySpeed = (double)(speed * yComp) + (double)spread * 0.7 * (double)(caster.m_217043_().m_188501_() * 2.0f - 1.0f) * Math.sqrt(1.0f - yComp * yComp);
            zSpeed = (double)(speed * zComp) + (double)spread * 0.7 * (double)(caster.m_217043_().m_188501_() * 2.0f - 1.0f) * Math.sqrt(1.0f - zComp * zComp);
            worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123744_, caster.m_20185_() + vec * vecX, caster.m_20188_(), caster.m_20189_() + vec * vecZ, 0, xSpeed, ySpeed, zSpeed, 1.0);
        }
        if (caster.f_19797_ > 2) {
            this.hitEntities(caster, range, potency);
        }
    }

    public void hitEntities(LivingEntity caster, int range, int potency) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(caster, range, range, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            boolean CloseCheck;
            int distance;
            float entityHitYaw = (float)((Math.atan2(entityHit.m_20189_() - caster.m_20189_(), entityHit.m_20185_() - caster.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingYaw = caster.m_146908_() % 360.0f;
            if (entityHitYaw < 0.0f) {
                entityHitYaw += 360.0f;
            }
            if (entityAttackingYaw < 0.0f) {
                entityAttackingYaw += 360.0f;
            }
            float entityRelativeYaw = entityHitYaw - entityAttackingYaw;
            float xzDistance = (float)Math.sqrt((entityHit.m_20189_() - caster.m_20189_()) * (entityHit.m_20189_() - caster.m_20189_()) + (entityHit.m_20185_() - caster.m_20185_()) * (entityHit.m_20185_() - caster.m_20185_()));
            double hitY = entityHit.m_20186_() + (double)entityHit.m_20206_() / 2.0;
            float entityHitPitch = (float)(Math.atan2(hitY - caster.m_20188_(), xzDistance) * 57.29577951308232 % 360.0);
            float entityAttackingPitch = -caster.m_146909_() % 360.0f;
            if (entityHitPitch < 0.0f) {
                entityHitPitch += 360.0f;
            }
            if (entityAttackingPitch < 0.0f) {
                entityAttackingPitch += 360.0f;
            }
            float entityRelativePitch = entityHitPitch - entityAttackingPitch;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - caster.m_20189_()) * (entityHit.m_20189_() - caster.m_20189_()) + (entityHit.m_20185_() - caster.m_20185_()) * (entityHit.m_20185_() - caster.m_20185_()) + (hitY - caster.m_20188_()) * (hitY - caster.m_20188_()));
            boolean inRange = entityHitDistance <= (float)(distance = caster.f_19797_ / 2) + 1.0f;
            boolean yawCheck = entityRelativeYaw <= 22.5f && entityRelativeYaw >= -22.5f || entityRelativeYaw >= 337.5f || entityRelativeYaw <= -337.5f;
            boolean pitchCheck = entityRelativePitch <= 22.5f && entityRelativePitch >= -22.5f || entityRelativePitch >= 337.5f || entityRelativePitch <= -337.5f;
            boolean bl = CloseCheck = entityHitDistance <= 2.0f;
            if ((!inRange || !yawCheck || !pitchCheck) && !CloseCheck || caster.f_19797_ % 3 != 0 || MobUtil.areAllies((Entity)caster, (Entity)entityHit)) continue;
            float damage = (float)((Double)GCSpellConfig.AshenBreathDamage.get() * (double)WandUtil.damageMultiply());
            boolean flag = entityHit.m_6469_(caster.m_269291_().m_269104_((Entity)caster, (Entity)caster), damage + (float)potency);
            if (!flag) continue;
            MobEffectInstance effectinstance = new MobEffectInstance(MobEffects.f_19610_, 60, 0, false, false, true);
            entityHit.m_7292_(effectinstance);
        }
    }

    public List<LivingEntity> getEntityLivingBaseNearby(LivingEntity caster, double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(caster, LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(LivingEntity caster, Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return caster.m_9236_().m_6443_(entityClass, caster.m_20191_().m_82377_(dX, dY, dZ), e -> e != caster && (double)caster.m_20270_(e) <= r + (double)(e.m_20205_() / 2.0f) && e.m_20186_() <= caster.m_20188_() + dY);
    }
}

