/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.spells.necromancy;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.magic.SummonSpell;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.EffectsUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.SoundUtil;
import com.Polarice3.Goety.utils.WandUtil;
import com.Polarice3.goety_cataclysm.common.entities.GCEntityType;
import com.Polarice3.goety_cataclysm.common.entities.ally.InternalAnimationSummon;
import com.Polarice3.goety_cataclysm.common.entities.ally.undead.draugr.EliteDraugrServant;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.GoetySounds;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class EliteDraugrSpell
extends SummonSpell {
    public int defaultSoulCost() {
        return (Integer)GCSpellConfig.EliteDraugrCost.get();
    }

    public int defaultCastDuration() {
        return (Integer)GCSpellConfig.EliteDraugrDuration.get();
    }

    public int SummonDownDuration() {
        return (Integer)GCSpellConfig.EliteDraugrSummonDown.get();
    }

    public SoundEvent CastingSound() {
        return (SoundEvent)GoetySounds.PREPARE_SUMMON.get();
    }

    public int defaultSpellCooldown() {
        return (Integer)GCSpellConfig.EliteDraugrCoolDown.get();
    }

    public SpellType getSpellType() {
        return SpellType.NECROMANCY;
    }

    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    public Predicate<LivingEntity> summonPredicate() {
        return livingEntity -> livingEntity instanceof EliteDraugrServant;
    }

    public int summonLimit() {
        return (Integer)GCSpellConfig.EliteDraugrLimit.get();
    }

    public void commonResult(ServerLevel worldIn, LivingEntity caster) {
        if (this.isShifting(caster)) {
            for (Entity entity : worldIn.m_8583_()) {
                if (!(entity instanceof EliteDraugrServant)) continue;
                this.teleportServants(caster, entity);
            }
            for (int i = 0; i < caster.m_9236_().f_46441_.m_188503_(35) + 10; ++i) {
                worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123759_, caster.m_20185_(), caster.m_20188_(), caster.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            worldIn.m_6263_(null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), (SoundEvent)GoetySounds.SUMMON_SPELL.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        this.commonResult(worldIn, caster);
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus((LivingEntity)caster)) {
            potency += WandUtil.getPotencyLevel((LivingEntity)caster);
            duration += WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.DURATION.get()), (LivingEntity)caster) + 1;
        }
        if (!this.isShifting(caster)) {
            int i = 1;
            if (this.rightStaff(staff)) {
                i = 2 + worldIn.f_46441_.m_188503_(4);
            } else if (this.typeStaff(staff, SpellType.FROST)) {
                i = 2;
            }
            for (int i1 = 0; i1 < i; ++i1) {
                EliteDraugrServant summonedentity = new EliteDraugrServant((EntityType<? extends InternalAnimationSummon>)((EntityType)GCEntityType.ELITE_DRAUGR_SERVANT.get()), (Level)worldIn);
                BlockPos blockPos = BlockFinder.SummonRadius((BlockPos)caster.m_20183_(), (Entity)summonedentity, (Level)worldIn);
                summonedentity.setTrueOwner(caster);
                summonedentity.m_20035_(blockPos, 0.0f, 0.0f);
                MobUtil.moveDownToGround((Entity)summonedentity);
                summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)worldIn) * duration);
                summonedentity.m_21530_();
                summonedentity.m_6518_((ServerLevelAccessor)worldIn, caster.m_9236_().m_6436_(caster.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                if (potency > 0) {
                    int boost = Mth.m_14045_((int)(potency - 1), (int)0, (int)10);
                    summonedentity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BUFF.get(), EffectsUtil.infiniteEffect(), boost, false, false));
                }
                this.SummonSap(caster, (LivingEntity)summonedentity);
                this.setTarget(caster, (Mob)summonedentity);
                if (worldIn.m_7967_((Entity)summonedentity)) {
                    ColorUtil colorUtil = new ColorUtil(2804175);
                    ServerParticleUtil.windShockwaveParticle((ServerLevel)worldIn, (ColorUtil)colorUtil, (float)0.1f, (float)0.1f, (float)0.05f, (int)-1, (Vec3)summonedentity.m_20182_());
                }
                this.summonAdvancement(caster, (LivingEntity)summonedentity);
            }
            this.SummonDown(caster);
            SoundUtil.playNecromancerSummon((Entity)caster);
        }
    }
}

