/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.spells.geomancy;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.utils.WandUtil;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.GoetySounds;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.EarthQuake_Entity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EarthShakeSpell
extends Spell {
    public SpellStat defaultStats() {
        return super.defaultStats().setVelocity(0.25f);
    }

    public int defaultSoulCost() {
        return (Integer)GCSpellConfig.EarthShakeCost.get();
    }

    public int defaultCastDuration() {
        return (Integer)GCSpellConfig.EarthShakeDuration.get();
    }

    public int defaultSpellCooldown() {
        return (Integer)GCSpellConfig.EarthShakeCoolDown.get();
    }

    @Nullable
    public SoundEvent CastingSound(LivingEntity caster) {
        return (SoundEvent)GoetySounds.RUMBLE.get();
    }

    public SpellType getSpellType() {
        return SpellType.GEOMANCY;
    }

    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.VELOCITY.get());
        return list;
    }

    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        float velocity = spellStat.getVelocity();
        if (WandUtil.enchantedFocus((LivingEntity)caster)) {
            potency += WandUtil.getPotencyLevel((LivingEntity)caster);
            velocity += (float)WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.VELOCITY.get()), (LivingEntity)caster) / 3.0f;
        }
        int quakeCount = 16;
        if (this.rightStaff(staff)) {
            quakeCount = 22 + worldIn.m_213780_().m_188503_(8);
            velocity += 0.2f;
        }
        float angle = 360.0f / (float)quakeCount;
        for (int i = 0; i < quakeCount; ++i) {
            EarthQuake_Entity peq = new EarthQuake_Entity((Level)worldIn, caster);
            float damage = (float)((Double)GCSpellConfig.EarthShakeDamage.get() * (double)WandUtil.damageMultiply());
            peq.setDamage(damage + (float)potency);
            peq.m_37251_((Entity)caster, 0.0f, angle * (float)i, 0.0f, velocity, 0.0f);
            peq.m_6034_(caster.m_20185_(), caster.m_20186_(), caster.m_20189_());
            worldIn.m_7967_((Entity)peq);
        }
        ScreenShake_Entity.ScreenShake((Level)worldIn, (Vec3)caster.m_20182_(), (float)15.0f, (float)0.1f, (int)0, (int)20);
        this.playSound(worldIn, (Entity)caster, SoundEvents.f_11913_, 1.0f, 1.0f + worldIn.m_213780_().m_188501_() * 0.1f);
    }
}

